/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.TimeBase.UtcT;

public class ReplyReceiver
extends ReplyPlaceholder
implements Configurable {
    private final Delegate delegate;
    private final ClientInterceptorHandler interceptors;
    private final ReplyHandler replyHandler;
    private final String operation;
    private final Timer timer;
    private Logger logger;
    private boolean retry_on_failure = false;

    public ReplyReceiver(Delegate delegate, String operation, UtcT replyEndTime, ClientInterceptorHandler interceptors, ReplyHandler replyHandler) {
        super((ORB)delegate.orb(null));
        this.delegate = delegate;
        this.operation = operation;
        this.interceptors = interceptors;
        this.replyHandler = replyHandler;
        if (replyEndTime != null) {
            this.timer = new Timer(replyEndTime);
            this.timer.setName("ReplyReceiver Timer");
            this.timer.start();
        } else {
            this.timer = null;
        }
    }

    public void configure(Configuration configuration) {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.rep_recv");
        this.retry_on_failure = configuration.getAttributeAsBoolean("jacorb.connection.client.retry_on_failure", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream in) {
        Set pending_replies;
        if (this.timeoutException) {
            return;
        }
        if (this.timer != null) {
            this.timer.wakeup();
        }
        Set set = pending_replies = this.delegate.get_pending_replies();
        synchronized (set) {
            java.lang.Object object = this.lock;
            synchronized (object) {
                if (this.timeoutException) {
                    return;
                }
                this.in = in;
                this.delegate.replyDone(this);
                if (this.replyHandler != null) {
                    this.performCallback((ReplyInputStream)in);
                } else {
                    this.ready = true;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCallback(ReplyInputStream reply) {
        ServantObject so;
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        try {
            so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        }
        catch (Exception e) {
            this.logger.warn("Exception during servant_preinvoke in ReplyReceiver.performCallback", e);
            return;
        }
        try {
            switch (reply.getStatus().value()) {
                case 0: {
                    ((InvokeHandler)so.servant)._invoke(this.operation, reply, new DummyResponseHandler());
                    return;
                }
                case 1: 
                case 2: {
                    ExceptionHolderImpl holder = new ExceptionHolderImpl(reply);
                    org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
                    orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
                    CDRInputStream input = new CDRInputStream(orb, holder.marshal());
                    ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.logger.warn("Exception during callback", e);
            return;
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performExceptionCallback(ExceptionHolderImpl holder) {
        ServantObject so;
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        try {
            so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        }
        catch (Exception e) {
            this.logger.warn("Exception during servant_preinvoke in ReplyReceiver.performExceptionCallback", e);
            return;
        }
        try {
            org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
            orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
            CDRInputStream input = new CDRInputStream(orb, holder.marshal());
            ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception during callback: " + e.toString());
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream(this.timer != null);
            }
            catch (COMM_FAILURE ex) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw ex;
            }
        }
        catch (SystemException se) {
            this.interceptors.handle_receive_exception(se);
            throw se;
        }
        catch (RemarshalException re) {
            this.delegate.waitOnBarrier();
            throw new RemarshalException();
        }
        ReplyInputStream reply = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 status = this.delegate.doNotCheckExceptions() ? ReplyStatusType_1_2.NO_EXCEPTION : reply.getStatus();
        switch (status.value()) {
            case 0: {
                this.interceptors.handle_receive_reply(reply);
                return reply;
            }
            case 1: {
                ApplicationException ae = this.getApplicationException(reply);
                this.interceptors.handle_receive_exception(ae, reply);
                throw ae;
            }
            case 2: {
                SystemException se = SystemExceptionHelper.read(reply);
                this.interceptors.handle_receive_exception(se, reply);
                throw se;
            }
            case 3: 
            case 4: {
                Object forward_reference = reply.read_Object();
                this.interceptors.handle_location_forward(reply, forward_reference);
                this.doRebind(forward_reference);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + status.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebind(Object forward_reference) {
        this.delegate.lockBarrier();
        try {
            Set pending_replies;
            Set set = pending_replies = this.delegate.get_pending_replies();
            synchronized (set) {
                Iterator i = pending_replies.iterator();
                while (i.hasNext()) {
                    ReplyPlaceholder p = (ReplyPlaceholder)i.next();
                    p.retry();
                }
            }
            this.delegate.rebind(forward_reference);
        }
        finally {
            this.delegate.openBarrier();
        }
    }

    private ApplicationException getApplicationException(ReplyInputStream reply) {
        reply.mark(0);
        String id = reply.read_string();
        try {
            reply.reset();
        }
        catch (IOException ioe) {
            this.logger.error("unexpected Exception in reset()", ioe);
        }
        return new ApplicationException(id, reply);
    }

    private class Timer
    extends Thread {
        private final UtcT endTime;
        private boolean awakened;

        public Timer(UtcT endTime) {
            super("ReplyReceiverTimer");
            this.awakened = false;
            this.endTime = endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    long time = Time.millisTo(this.endTime);
                    if (time > 0L) {
                        try {
                            ReplyReceiver.this.lock.wait(time);
                        }
                        catch (InterruptedException ex) {
                            ReplyReceiver.this.logger.info("Interrupted while waiting for timeout");
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver.this.timeoutException = true;
                        if (ReplyReceiver.this.replyHandler != null) {
                            ExceptionHolderImpl exHolder = new ExceptionHolderImpl(new TIMEOUT());
                            ReplyReceiver.this.performExceptionCallback(exHolder);
                        }
                        ReplyReceiver.this.ready = true;
                        ReplyReceiver.this.lock.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            java.lang.Object object = ReplyReceiver.this.lock;
            synchronized (object) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                ReplyReceiver.this.lock.notifyAll();
            }
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        private ExceptionHolderFactory() {
        }

        public Serializable read_value(InputStream is) {
            ExceptionHolderImpl result = new ExceptionHolderImpl();
            result._read(is);
            return result;
        }
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        private DummyResponseHandler() {
        }

        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }
    }
}

