/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.IORMutator;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Stack;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    private Stack encaps_stack;
    private Map repeatedTCMap;
    private Map cachedTypecodes;
    private int marked_pos;
    private int marked_index;
    private boolean closed;
    private Logger logger;
    private boolean cometInteropFix;
    private boolean laxBooleanEncoding;
    private boolean cacheTypecodes;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    protected int giop_minor = 2;
    private Map valueMap;
    private int currentValueIndex;
    private Map repIdMap;
    private Map codebaseMap;
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    private boolean chunkedValue = false;
    private int valueNestingLevel = 0;
    private int chunk_end_pos = -1;
    private IORMutator mutator;
    private boolean isMutatorEnabled;
    private boolean codesetEnabled;
    private final org.omg.CORBA.ORB orb;
    private static final int MAX_BLOCK_SIZE = 0x7FFFFF00;
    private boolean sunInteropFix;
    private Map tcMap;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$Any;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf) {
        this.buffer = buf;
        if (orb != null) {
            this.orb = orb;
            if (orb instanceof ORB) {
                try {
                    this.configure(((ORB)orb).getConfiguration());
                }
                catch (ConfigurationException ce) {
                    throw new INTERNAL("ConfigurationException: " + ce);
                }
            }
        } else {
            this.orb = org.omg.CORBA.ORB.init();
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB orb, byte[] buf, boolean littleEndian) {
        this(orb, buf);
        this.littleEndian = littleEndian;
    }

    public CDRInputStream(byte[] buffer, boolean littleEndian) {
        this(null, buffer, littleEndian);
    }

    private void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration jacorbConfig = (org.jacorb.config.Configuration)configuration;
        this.logger = jacorbConfig.getNamedLogger("jacorb.orb.cdr");
        this.codesetEnabled = configuration.getAttribute("jacorb.codeset", "on").equals("on");
        this.cometInteropFix = configuration.getAttribute("jacorb.interop.comet", "off").equals("on");
        this.laxBooleanEncoding = configuration.getAttribute("jacorb.interop.lax_boolean_encoding", "off").equals("on");
        this.cacheTypecodes = configuration.getAttribute("jacorb.cacheTypecodes", "off").equals("on");
        this.sunInteropFix = configuration.getAttribute("jacorb.interop.sun", "off").equalsIgnoreCase("on");
        boolean bl = this.isMutatorEnabled = configuration.getAttribute("jacorb.iormutator", "").length() > 0;
        if (this.isMutatorEnabled) {
            this.mutator = (IORMutator)jacorbConfig.getAttributeAsObject("jacorb.iormutator");
        }
    }

    private Map getValueMap() {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        return this.valueMap;
    }

    private Map getRepIdMap() {
        if (this.repIdMap == null) {
            this.repIdMap = new HashMap();
        }
        return this.repIdMap;
    }

    private Map getCodebaseMap() {
        if (this.codebaseMap == null) {
            this.codebaseMap = new HashMap();
        }
        return this.codebaseMap;
    }

    private Pair getCachedTypecode(java.lang.Object id) {
        Pair result;
        if (this.cacheTypecodes) {
            if (this.cachedTypecodes == null) {
                this.cachedTypecodes = new HashMap();
                result = null;
            } else {
                result = (Pair)this.cachedTypecodes.get(id);
            }
        } else {
            result = null;
        }
        return result;
    }

    private void putCachedTypecode(java.lang.Object id, Pair result) {
        if (this.cacheTypecodes) {
            this.cachedTypecodes.put(id, result);
        }
    }

    public void setGIOPMinor(int giop_minor) {
        this.giop_minor = giop_minor;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.buffer = null;
        this.encaps_stack = null;
        this.closed = true;
        if (this.tcMap != null) {
            this.tcMap.clear();
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public void setCodeSet(int codeSet, int codeSetWide) {
        this.codeSet = codeSet;
        this.codeSetW = codeSetWide;
    }

    private static final int _read4int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return ((_buffer[_pos + 3] & 0xFF) << 24) + ((_buffer[_pos + 2] & 0xFF) << 16) + ((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0);
        }
        return ((_buffer[_pos] & 0xFF) << 24) + ((_buffer[_pos + 1] & 0xFF) << 16) + ((_buffer[_pos + 2] & 0xFF) << 8) + ((_buffer[_pos + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean _littleEndian, byte[] _buffer, int _pos) {
        if (_littleEndian) {
            return (short)(((_buffer[_pos + 1] & 0xFF) << 8) + ((_buffer[_pos] & 0xFF) << 0));
        }
        return (short)(((_buffer[_pos] & 0xFF) << 8) + ((_buffer[_pos + 1] & 0xFF) << 0));
    }

    private final int _read_long() {
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    private final long _read_longlong() {
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    private final void handle_chunking() {
        int aligned_pos;
        int remainder = 4 - this.index % 4;
        int n = aligned_pos = remainder != 4 ? this.pos + remainder : this.pos;
        if (this.chunk_end_pos >= this.pos && this.chunk_end_pos <= aligned_pos) {
            this.chunk_end_pos = -1;
            int saved_pos = this.pos;
            int saved_index = this.index;
            int tag = this.read_long();
            if (tag < 0) {
                if (-tag > this.valueNestingLevel) {
                    throw new INTERNAL("received end tag " + tag + " with value nesting level " + this.valueNestingLevel);
                }
                this.valueNestingLevel = -tag;
                --this.valueNestingLevel;
                if (this.valueNestingLevel > 0) {
                    this.chunk_end_pos = this.pos;
                    this.handle_chunking();
                }
            } else if (tag < 0x7FFFFF00) {
                this.chunk_end_pos = this.pos + tag;
            } else {
                this.pos = saved_pos;
                this.index = saved_index;
            }
        }
    }

    protected final void skip(int distance) {
        this.pos += distance;
        this.index += distance;
    }

    public final void closeEncapsulation() {
        if (this.encaps_stack == null) {
            throw new MARSHAL("Internal Error - closeEncapsulation failed");
        }
        EncapsInfo ei = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = ei.littleEndian;
        int start = ei.start;
        int size = ei.size;
        if (this.pos < start + size) {
            this.pos = start + size;
        }
        this.index = ei.index + size;
    }

    public final int openEncapsulation() {
        boolean old_endian = this.littleEndian;
        int size = this.read_long();
        if (this.cometInteropFix && (size < 0 || size > this.buffer.length)) {
            int temp = (size >> 24 & 0xFF) + (size >> 8 & 0xFF00) + (size << 8 & 0xFF0000) + (size << 24 & 0xFF000000);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size of CDR encapsulation larger than buffer, swapping byte order\nSize of CDR encapsulation was " + size + ", is now " + temp);
            }
            size = temp;
        }
        if (this.encaps_stack == null) {
            this.encaps_stack = new Stack();
        }
        this.encaps_stack.push(new EncapsInfo(old_endian, this.index, this.pos, size));
        this.openEncapsulatedArray();
        return size;
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBufferCopy() {
        byte[] result = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, result, 0, this.buffer.length);
        return result;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        ++this.index;
        return this.buffer[this.pos++];
    }

    public int available() {
        return this.buffer.length - this.index;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IOException("buffer may not be null");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("buffer index out of bounds");
        }
        if (len == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int min = Math.min(len, this.available());
        System.arraycopy(this.buffer, this.index, b, off, min);
        this.pos += min;
        this.index += min;
        return min;
    }

    public final Any read_any() {
        org.omg.CORBA.TypeCode _tc = this.read_TypeCode();
        Any any = this.orb.create_any();
        any.read_value(this, _tc);
        return any;
    }

    public final boolean read_boolean() {
        this.handle_chunking();
        ++this.index;
        byte value = this.buffer[this.pos++];
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        if (this.laxBooleanEncoding) {
            return true;
        }
        throw new MARSHAL("Unexpected boolean value: " + value + " pos: " + this.pos + " index: " + this.index);
    }

    public final void read_boolean_array(boolean[] value, int offset, int length) {
        this.handle_chunking();
        for (int j = offset; j < offset + length; ++j) {
            byte bb;
            ++this.index;
            if ((bb = this.buffer[this.pos++]) == 1) {
                value[j] = true;
                continue;
            }
            if (bb == 0) {
                value[j] = false;
                continue;
            }
            throw new MARSHAL("Unexpected boolean value: " + bb + " pos: " + this.pos + " index: " + this.index);
        }
    }

    public final char read_char() {
        this.handle_chunking();
        ++this.index;
        return (char)(this.buffer[this.pos++] & 0xFF);
    }

    public final void read_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw new MARSHAL("Cannot marshall result into null array.");
        }
        if (offset + length > value.length || length < 0 || offset < 0) {
            throw new MARSHAL("Cannot marshall as indices for array are out bounds.");
        }
        this.handle_chunking();
        for (int j = offset; j < offset + length; ++j) {
            ++this.index;
            value[j] = (char)(0xFF & this.buffer[this.pos++]);
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = Double.longBitsToDouble(this._read_longlong());
        }
    }

    public final BigDecimal read_fixed() {
        this.handle_chunking();
        StringBuffer sb = new StringBuffer();
        int c = this.read_fixed_internal(sb);
        BigDecimal result = new BigDecimal(new BigInteger(sb.toString()));
        return this.read_fixed_negate(c, result);
    }

    private BigDecimal read_fixed_negate(int c, BigDecimal result) {
        if (c == 13) {
            return result.negate();
        }
        return result;
    }

    private int read_fixed_internal(StringBuffer sb) {
        byte b = this.buffer[this.pos++];
        int c = b & 0xF;
        ++this.index;
        while (true) {
            c = (b & 0xF0) >>> 4;
            sb.append(c);
            c = b & 0xF;
            if (c == 12 || c == 13) break;
            sb.append(c);
            b = this.buffer[this.pos++];
            ++this.index;
        }
        return c;
    }

    public final BigDecimal read_fixed(short digits, short scale) {
        this.handle_chunking();
        StringBuffer sb = new StringBuffer();
        int c = this.read_fixed_internal(sb);
        BigDecimal result = new BigDecimal(new BigInteger(sb.toString()), scale);
        return this.read_fixed_negate(c, result);
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = Float.intBitsToFloat(this._read_long());
        }
    }

    public final int read_long() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    public final void read_long_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    public final long read_longlong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_longlong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final Object read_Object() {
        ParsedIOR pior;
        if (!(this.orb instanceof ORB)) {
            throw new MARSHAL("Cannot use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        this.handle_chunking();
        IOR ior = IORHelper.read(this);
        if (this.isMutatorEnabled) {
            ior = this.mutator.mutateIncoming(ior);
        }
        if ((pior = new ParsedIOR((ORB)this.orb, ior)).isNull()) {
            return null;
        }
        return ((ORB)this.orb)._getObject(pior);
    }

    public Object read_Object(Class clazz) {
        if (ObjectImpl.class.isAssignableFrom(clazz)) {
            Object obj = this.read_Object();
            if (obj instanceof ObjectImpl) {
                ObjectImpl stub = null;
                try {
                    stub = (ObjectImpl)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new MARSHAL("Exception in stub instantiation: " + e);
                }
                catch (IllegalAccessException e) {
                    throw new MARSHAL("Exception in stub instantiation: " + e);
                }
                stub._set_delegate(((ObjectImpl)obj)._get_delegate());
                return stub;
            }
            return obj;
        }
        if (clazz.isInterface() && Remote.class.isAssignableFrom(clazz)) {
            return (Object)ValueHandler.portableRemoteObject_narrow(this.read_Object(), clazz);
        }
        return this.read_Object();
    }

    public final byte read_octet() {
        this.handle_chunking();
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] value, int offset, int length) {
        this.handle_chunking();
        System.arraycopy(this.buffer, this.pos, value, offset, length);
        this.index += length;
        this.pos += length;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final short read_short() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    public final void read_short_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    public final String read_string() {
        String result = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        int start = this.pos + 4;
        this.index += size + 4;
        this.pos += size + 4;
        if (size > 0 && this.buffer[start + size - 1] == 0) {
            --size;
        }
        if (size == 0) {
            return "";
        }
        if (start + size > this.buffer.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Size (" + size + ") invalid for string extraction from buffer length of " + this.buffer.length + " from position " + start);
            }
            throw new MARSHAL("Invalid size for string extraction");
        }
        if (this.codesetEnabled) {
            String csname = CodeSet.csName(this.codeSet);
            try {
                result = new String(this.buffer, start, size, csname);
            }
            catch (UnsupportedEncodingException ex) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("Charset " + csname + " is unsupported");
                    result = "";
                }
            }
        } else {
            char[] buf = new char[size];
            for (int i = 0; i < size; ++i) {
                buf[i] = (char)(0xFF & this.buffer[start + i]);
            }
            result = new String(buf);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final org.omg.CORBA.TypeCode read_TypeCode() {
        if (this.tcMap == null) {
            this.tcMap = new TreeMap();
        }
        if (this.repeatedTCMap == null) {
            this.repeatedTCMap = new HashMap();
        }
        try {
            org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(this.tcMap, this.repeatedTCMap);
            return typeCode;
        }
        finally {
            this.repeatedTCMap.clear();
        }
    }

    private final org.omg.CORBA.TypeCode read_TypeCode(Map recursiveTCMap, Map repeatedTCMap) {
        org.omg.CORBA.TypeCode result;
        int kind = this.read_long();
        int start_pos = this.pos - 4;
        Integer startPosition = ObjectUtil.newInteger(start_pos);
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Read Type code of kind " + kind + " at pos: " + start_pos);
        }
        switch (kind) {
            case -1: {
                int negative_offset = this.read_long();
                Integer origTCStartPos = ObjectUtil.newInteger(this.pos - 4 + negative_offset);
                org.omg.CORBA.TypeCode repeatedTC = (org.omg.CORBA.TypeCode)repeatedTCMap.get(origTCStartPos);
                if (repeatedTC != null) {
                    result = repeatedTC;
                    break;
                }
                String recursiveId = (String)recursiveTCMap.get(origTCStartPos);
                if (recursiveId != null) {
                    try {
                        result = this.orb.create_recursive_tc(recursiveId);
                        break;
                    }
                    catch (SystemException e) {
                        throw new MARSHAL("Failed to create recursive typecode: " + e);
                    }
                }
                throw new MARSHAL("Found indirection marker, but no corresponding original typecode (pos: " + origTCStartPos + ")");
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                result = this.orb.get_primitive_tc(TCKind.from_int(kind));
                break;
            }
            case 14: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    result = this.orb.create_interface_tc(id, name);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.skip(skipAmount);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 15: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    int member_count = this.read_long();
                    recursiveTCMap.put(startPosition, id);
                    StructMember[] struct_members = new StructMember[member_count];
                    for (int i = 0; i < member_count; ++i) {
                        struct_members[i] = new StructMember(this.read_string(), this.read_TypeCode(recursiveTCMap, repeatedTCMap), null);
                    }
                    result = ((ORBSingleton)this.orb).create_struct_tc(id, name, struct_members, false);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 16: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    recursiveTCMap.put(startPosition, id);
                    org.omg.CORBA.TypeCode discriminator_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                    org.omg.CORBA.TypeCode orig_disc_type = TypeCode.originalType(discriminator_type);
                    int default_index = this.read_long();
                    int member_count = this.read_long();
                    UnionMember[] union_members = new UnionMember[member_count];
                    for (int i = 0; i < member_count; ++i) {
                        Any label = this.orb.create_any();
                        if (i == default_index) {
                            label.insert_octet(this.read_octet());
                        } else {
                            label.read_value(this, orig_disc_type);
                        }
                        union_members[i] = new UnionMember(this.read_string(), label, this.read_TypeCode(recursiveTCMap, repeatedTCMap), null);
                    }
                    result = ((ORBSingleton)this.orb).create_union_tc(id, name, discriminator_type, union_members, false);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 17: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    int member_count = this.read_long();
                    String[] member_names = new String[member_count];
                    for (int i = 0; i < member_count; ++i) {
                        member_names[i] = this.read_string();
                    }
                    result = ((ORBSingleton)this.orb).create_enum_tc(id, name, member_names, false);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.skip(skipAmount);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 18: {
                result = this.orb.create_string_tc(this.read_long());
                break;
            }
            case 19: {
                int size = this.openEncapsulation();
                org.omg.CORBA.TypeCode content_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                Pair cachedObject = this.getCachedTypecode(content_type);
                if (cachedObject == null) {
                    int length = this.read_long();
                    result = this.orb.create_sequence_tc(length, content_type);
                    this.putCachedTypecode(result, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.skip(skipAmount);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 20: {
                int size = this.openEncapsulation();
                org.omg.CORBA.TypeCode content_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                Pair cachedObject = this.getCachedTypecode(content_type);
                if (cachedObject == null) {
                    result = this.orb.create_array_tc(this.read_long(), content_type);
                    this.putCachedTypecode(result, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.skip(skipAmount);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 21: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    recursiveTCMap.put(startPosition, id);
                    org.omg.CORBA.TypeCode content_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                    result = this.orb.create_alias_tc(id, name, content_type);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 22: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    int member_count = this.read_long();
                    recursiveTCMap.put(startPosition, id);
                    StructMember[] members = new StructMember[member_count];
                    for (int i = 0; i < member_count; ++i) {
                        members[i] = new StructMember(this.read_string(), this.read_TypeCode(recursiveTCMap, repeatedTCMap), null);
                    }
                    result = ((ORBSingleton)this.orb).create_exception_tc(id, name, members, false);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 23: 
            case 24: {
                result = this.orb.get_primitive_tc(TCKind.from_int(kind));
                break;
            }
            case 25: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
            }
            case 26: {
                result = this.orb.get_primitive_tc(TCKind.from_int(kind));
                break;
            }
            case 27: {
                result = this.orb.create_wstring_tc(this.read_long());
                break;
            }
            case 28: {
                result = this.orb.create_fixed_tc(this.read_ushort(), this.read_short());
                break;
            }
            case 29: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    recursiveTCMap.put(startPosition, id);
                    short type_modifier = this.read_short();
                    org.omg.CORBA.TypeCode concrete_base_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                    int member_count = this.read_long();
                    ValueMember[] vMembers = new ValueMember[member_count];
                    for (int i = 0; i < member_count; ++i) {
                        vMembers[i] = new ValueMember(this.read_string(), null, null, null, this.read_TypeCode(recursiveTCMap, repeatedTCMap), null, this.read_short());
                    }
                    result = this.orb.create_value_tc(id, name, type_modifier, concrete_base_type, vMembers);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 30: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    recursiveTCMap.put(startPosition, id);
                    org.omg.CORBA.TypeCode content_type = this.read_TypeCode(recursiveTCMap, repeatedTCMap);
                    result = this.orb.create_value_box_tc(id, name, content_type);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            case 31: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
            }
            case 32: {
                int size = this.openEncapsulation();
                String id = this.validateID(this.read_string());
                Pair cachedObject = this.getCachedTypecode(id);
                if (cachedObject == null) {
                    String name = this.validateName(this.read_string());
                    recursiveTCMap.put(startPosition, id);
                    result = this.orb.create_abstract_interface_tc(id, name);
                    this.putCachedTypecode(id, new Pair(result, startPosition));
                } else {
                    int skipAmount = this.calcSkipAmount(size, start_pos);
                    this.updateTcMap(recursiveTCMap, start_pos, skipAmount, cachedObject.position);
                    this.skip(skipAmount);
                    recursiveTCMap.put(startPosition, id);
                    result = cachedObject.typeCode;
                }
                this.closeEncapsulation();
                break;
            }
            default: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
            }
        }
        repeatedTCMap.put(startPosition, result);
        return result;
    }

    private int calcSkipAmount(int size, int start_pos) {
        return size - (this.pos - start_pos - 4 - 4);
    }

    private void updateTcMap(Map tcMap, int new_start, int size, Integer old_start) {
        SortedMap sortedMap = ((TreeMap)tcMap).subMap(old_start, ObjectUtil.newInteger(size + old_start));
        if (sortedMap.size() > 0) {
            TreeMap toMerge = new TreeMap();
            Iterator iterator = sortedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int value = entry.getKey();
                toMerge.put(ObjectUtil.newInteger(new_start + (value - old_start)), entry.getValue());
            }
            tcMap.putAll(toMerge);
        }
    }

    public final int read_ulong() {
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        int result = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return result;
    }

    public final void read_ulong_array(int[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
        }
        this.index += 4 * length;
    }

    public final long read_ulonglong() {
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            return ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
        }
        return ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
    }

    public final void read_ulonglong_array(long[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 8 - this.index % 8;
        if (remainder != 8) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.littleEndian) {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() & 0xFFFFFFFFL) + ((long)this._read_long() << 32);
            }
        } else {
            for (int j = offset; j < offset + length; ++j) {
                value[j] = ((long)this._read_long() << 32) + ((long)this._read_long() & 0xFFFFFFFFL);
            }
        }
    }

    public final short read_ushort() {
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        short result = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return result;
    }

    public final void read_ushort_array(short[] value, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.handle_chunking();
        int remainder = 2 - this.index % 2;
        if (remainder != 2) {
            this.index += remainder;
            this.pos += remainder;
        }
        for (int j = offset; j < offset + length; ++j) {
            value[j] = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
            this.pos += 2;
        }
        this.index += length * 2;
    }

    public final char read_wchar() {
        this.handle_chunking();
        if (this.giop_minor == 2) {
            this.read_wchar_size();
            boolean wchar_little_endian = this.readBOM();
            return this.read_wchar(wchar_little_endian);
        }
        return this.read_wchar(this.littleEndian);
    }

    private final int read_wchar_size() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    private final char read_wchar(boolean wchar_little_endian) {
        switch (this.codeSetW) {
            case 0x5010001: {
                if (this.giop_minor < 2) {
                    throw new MARSHAL("GIOP 1." + this.giop_minor + " only allows 2 Byte encodings for wchar, but the selected TCSW is UTF-8");
                }
                short value = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((value & 0x80) == 0) {
                    return (char)value;
                }
                if ((value & 0xE0) == 192) {
                    ++this.index;
                    return (char)((value & 0x1F) << 6 | this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short b2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((value & 0xF) << 12 | (b2 & 0x3F) << 6 | this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                char value = wchar_little_endian ? (char)(this.buffer[this.pos++] & 0xFF | this.buffer[this.pos++] << 8) : (char)(this.buffer[this.pos++] << 8 | this.buffer[this.pos++] & 0xFF);
                this.index += 2;
                return value;
            }
        }
        throw new MARSHAL("Bad CodeSet: " + this.codeSetW);
    }

    private final boolean readBOM() {
        if (this.buffer[this.pos] == -2 && this.buffer[this.pos + 1] == -1) {
            this.pos += 2;
            this.index += 2;
            return false;
        }
        if (this.buffer[this.pos] == -1 && this.buffer[this.pos + 1] == -2) {
            this.pos += 2;
            this.index += 2;
            return true;
        }
        return false;
    }

    public final void read_wchar_array(char[] value, int offset, int length) {
        this.handle_chunking();
        for (int j = offset; j < offset + length; ++j) {
            value[j] = this.read_wchar();
        }
    }

    public final String read_wstring() {
        String result = null;
        char[] buf = null;
        this.handle_chunking();
        int remainder = 4 - this.index % 4;
        if (remainder != 4) {
            this.index += remainder;
            this.pos += remainder;
        }
        if (this.giop_minor == 2) {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            if (size == 0) {
                return "";
            }
            buf = new char[size];
            int i = 0;
            int endPos = this.pos + size;
            boolean wchar_litte_endian = this.readBOM();
            while (this.pos < endPos) {
                buf[i++] = this.read_wchar(wchar_litte_endian);
            }
            result = new String(buf, 0, i);
        } else {
            int size = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.index += 4;
            this.pos += 4;
            buf = new char[size];
            int endPos = this.pos + size;
            if (this.codeSetW == 65801) {
                endPos += size;
            }
            int i = 0;
            while (this.pos < endPos) {
                buf[i++] = this.read_wchar(this.littleEndian);
            }
            result = i != 0 && buf[i - 1] == '\u0000' ? new String(buf, 0, i - 1) : new String(buf, 0, i);
        }
        buf = null;
        return result;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readLimit) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new MARSHAL("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean b) {
        this.littleEndian = b;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.portable.OutputStream out) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int kind = typeCode.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    out.write_short(this.read_short());
                    break;
                }
                case 3: {
                    out.write_long(this.read_long());
                    break;
                }
                case 4: {
                    out.write_ushort(this.read_ushort());
                    break;
                }
                case 5: {
                    out.write_ulong(this.read_ulong());
                    break;
                }
                case 6: {
                    out.write_float(this.read_float());
                    break;
                }
                case 7: {
                    out.write_double(this.read_double());
                    break;
                }
                case 8: {
                    out.write_boolean(this.read_boolean());
                    break;
                }
                case 9: {
                    out.write_char(this.read_char());
                    break;
                }
                case 10: {
                    out.write_octet(this.read_octet());
                    break;
                }
                case 11: {
                    out.write_any(this.read_any());
                    break;
                }
                case 12: {
                    out.write_TypeCode(this.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    out.write_Object(this.read_Object());
                    break;
                }
                case 15: {
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.read_value(typeCode.member_type(i), out);
                    }
                    break;
                }
                case 16: {
                    org.omg.CORBA.TypeCode disc = typeCode.discriminator_type();
                    disc = TypeCode.originalType(disc);
                    int def_idx = typeCode.default_index();
                    int member_idx = -1;
                    block33 : switch (disc.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            out.write_short(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_short()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 3: {
                            int s = this.read_long();
                            out.write_long(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_long()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            out.write_ushort(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ushort()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 5: {
                            int s = this.read_ulong();
                            out.write_ulong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ulong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 6: 
                        case 7: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 8: {
                            boolean b = this.read_boolean();
                            out.write_boolean(b);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || b != typeCode.member_label(i).extract_boolean()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 9: {
                            char s = this.read_char();
                            out.write_char(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_char()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 17: {
                            int s = this.read_long();
                            out.write_long(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                int label;
                                if (i == def_idx || s != (label = typeCode.member_label(i).create_input_stream().read_long())) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                        case 23: {
                            long s = this.read_longlong();
                            out.write_longlong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_longlong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        case 24: {
                            long s = this.read_ulonglong();
                            out.write_ulonglong(s);
                            for (int i = 0; i < typeCode.member_count(); ++i) {
                                if (i == def_idx || s != typeCode.member_label(i).extract_ulonglong()) continue;
                                member_idx = i;
                                break block33;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + disc);
                        }
                    }
                    if (member_idx != -1) {
                        this.read_value(typeCode.member_type(member_idx), out);
                        break;
                    }
                    if (def_idx != -1) {
                        this.read_value(typeCode.member_type(def_idx), out);
                    }
                    break;
                }
                case 17: {
                    out.write_long(this.read_long());
                    break;
                }
                case 18: {
                    out.write_string(this.read_string());
                    break;
                }
                case 19: {
                    int len = this.read_long();
                    out.write_long(len);
                    for (int i = 0; i < len; ++i) {
                        this.read_value(typeCode.content_type(), out);
                    }
                    break;
                }
                case 20: {
                    int length = typeCode.length();
                    for (int i = 0; i < length; ++i) {
                        this.read_value(typeCode.content_type(), out);
                    }
                    break;
                }
                case 21: {
                    this.read_value(typeCode.content_type(), out);
                    break;
                }
                case 22: {
                    out.write_string(this.read_string());
                    for (int i = 0; i < typeCode.member_count(); ++i) {
                        this.read_value(typeCode.member_type(i), out);
                    }
                    break;
                }
                case 23: {
                    out.write_longlong(this.read_longlong());
                    break;
                }
                case 24: {
                    out.write_ulonglong(this.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    out.write_wchar(this.read_wchar());
                    break;
                }
                case 27: {
                    out.write_wstring(this.read_wstring());
                    break;
                }
                case 28: {
                    out.write_fixed(this.read_fixed());
                    break;
                }
                case 29: {
                    Serializable val = this.read_value();
                    ((OutputStream)out).write_value(val, typeCode.id());
                    break;
                }
                case 30: {
                    String id = typeCode.id();
                    BoxedValueHelper helper = ((ORB)this.orb).getBoxedValueHelper(id);
                    if (helper == null) {
                        throw new MARSHAL("No BoxedValueHelper for id " + id);
                    }
                    Serializable value = this.read_value(helper);
                    ((OutputStream)out).write_value(value, helper);
                    break;
                }
                default: {
                    throw new MARSHAL("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
        catch (BadKind ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
        catch (Bounds ex) {
            throw new MARSHAL("When processing TypeCode with kind: " + kind + " caught " + ex);
        }
    }

    public Serializable read_value() {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            throw new MARSHAL("missing value type information");
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(String rep_id) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{rep_id}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(Serializable value) {
        if (value instanceof Streamable) {
            this.register_value(value);
            ((Streamable)((java.lang.Object)value))._read(this);
        } else if (value instanceof CustomValue) {
            this.register_value(value);
            ((CustomValue)value).unmarshal(new DataInputStream(this));
        } else {
            throw new BAD_PARAM("read_value is only implemented for Streamables");
        }
        return value;
    }

    public Serializable read_value(Class clz) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            return this.read_untyped_value(new String[]{ValueHandler.getRMIRepositoryID(clz)}, start_offset, codebase);
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        if (tag == 2147483398) {
            return this.read_multi_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    public Serializable read_value(BoxedValueHelper factory) {
        int tag = this.read_long();
        int start_offset = this.pos - 4;
        if (tag == -1) {
            return this.read_indirect_value();
        }
        if (tag == 0) {
            return null;
        }
        String codebase = (tag & 1) != 0 ? this.read_codebase() : null;
        this.chunkedValue = (tag & 8) != 0;
        int theTag = tag;
        if ((tag &= 0xFFFFFFF6) == 0x7FFFFF00) {
            Serializable result = factory.read_value(this);
            if (result != null) {
                this.getValueMap().put(ObjectUtil.newInteger(start_offset), result);
            }
            return result;
        }
        if (tag == 2147483394) {
            return this.read_typed_value(start_offset, codebase);
        }
        throw new MARSHAL("unknown value tag: 0x" + Integer.toHexString(theTag) + " (offset=0x" + Integer.toHexString(start_offset) + ")");
    }

    private Serializable read_untyped_value(String[] repository_ids, int index, String codebase) {
        java.lang.Object result = null;
        if (this.chunkedValue || this.valueNestingLevel > 0) {
            ++this.valueNestingLevel;
            int chunk_size_tag = this.readChunkSizeTag();
            this.chunk_end_pos = this.pos + chunk_size_tag;
        }
        for (int i = 0; i < repository_ids.length; ++i) {
            if (repository_ids[i].equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                result = this.read_wstring();
                break;
            }
            if (repository_ids[i].startsWith("RMI:javax.rmi.CORBA.ClassDesc:")) {
                String classCodebase = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                String reposId = (String)((java.lang.Object)this.read_value(class$java$lang$String == null ? CDRInputStream.class$("java.lang.String") : class$java$lang$String));
                String className = RepositoryID.className(reposId, null);
                try {
                    result = this.loadClass(className, classCodebase);
                    break;
                }
                catch (ClassNotFoundException e) {
                    if (i < repository_ids.length - 1) continue;
                    throw new MARSHAL("class not found: " + className);
                }
            }
            if (repository_ids[i].startsWith("IDL:")) {
                ValueFactory factory = ((org.omg.CORBA_2_3.ORB)this.orb()).lookup_value_factory(repository_ids[i]);
                if (factory != null) {
                    this.currentValueIndex = index;
                    result = factory.read_value(this);
                    break;
                }
                if (i < repository_ids.length - 1) continue;
                throw new MARSHAL("No factory found for: " + repository_ids[0]);
            }
            String className = RepositoryID.className(repository_ids[i], null);
            try {
                Class clazz = this.loadClass(className, codebase);
                if ((class$org$omg$CORBA$portable$IDLEntity == null ? CDRInputStream.class$("org.omg.CORBA.portable.IDLEntity") : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clazz)) {
                    Method readMethod = null;
                    if (clazz != (class$org$omg$CORBA$Any == null ? CDRInputStream.class$("org.omg.CORBA.Any") : class$org$omg$CORBA$Any)) {
                        String helperClassName = clazz.getName() + "Helper";
                        try {
                            ClassLoader classLoader = clazz.getClassLoader();
                            Class<?> helperClass = classLoader == null ? ObjectUtil.classForName(helperClassName) : classLoader.loadClass(helperClassName);
                            Class[] paramTypes = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? CDRInputStream.class$("org.omg.CORBA.portable.InputStream") : class$org$omg$CORBA$portable$InputStream};
                            readMethod = helperClass.getMethod("read", paramTypes);
                        }
                        catch (ClassNotFoundException e) {
                            throw new MARSHAL("Error loading class " + helperClassName + ": " + e);
                        }
                        catch (NoSuchMethodException e) {
                            throw new MARSHAL("No read method in helper class " + helperClassName + ": " + e);
                        }
                    }
                    if (readMethod == null) {
                        result = this.read_any();
                        continue;
                    }
                    try {
                        result = (Serializable)readMethod.invoke(null, this);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new MARSHAL("Internal error: " + e);
                    }
                    catch (InvocationTargetException e) {
                        throw new MARSHAL("Exception unmarshaling IDLEntity: " + e.getTargetException());
                    }
                }
                result = ValueHandler.readValue(this, index, clazz, repository_ids[i], null);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (i < repository_ids.length - 1) continue;
                throw new MARSHAL("class not found: " + className);
            }
        }
        if (result != null) {
            this.getValueMap().put(ObjectUtil.newInteger(index), result);
        }
        return result;
    }

    private Class loadClass(String className, String codebase) throws ClassNotFoundException {
        Class clazz;
        ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader();
        if (clazzLoader == null) {
            clazz = ValueHandler.loadClass(className, codebase, null);
        } else {
            try {
                clazz = clazzLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = ValueHandler.loadClass(className, codebase, null);
            }
        }
        return clazz;
    }

    private int readChunkSizeTag() {
        int savedPos = this.pos;
        int savedIndex = this.index;
        int chunk_size_tag = this.read_long();
        if (!this.sunInteropFix || chunk_size_tag > 0 && chunk_size_tag < 0x7FFFFF00) {
            return chunk_size_tag;
        }
        this.pos = savedPos;
        this.index = savedIndex;
        return 0x7FFFFF00;
    }

    private Serializable read_typed_value(int index, String codebase) {
        return this.read_untyped_value(new String[]{this.read_repository_id()}, index, codebase);
    }

    private Serializable read_multi_typed_value(int index, String codebase) {
        int id_count = this.read_long();
        String[] ids = new String[id_count];
        for (int i = 0; i < id_count; ++i) {
            ids[i] = this.read_repository_id();
        }
        return this.read_untyped_value(ids, index, codebase);
    }

    private String read_repository_id() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String repId = (String)this.getRepIdMap().get(ObjectUtil.newInteger(index));
            if (repId == null) {
                throw new MARSHAL("stale RepositoryID indirection");
            }
            return repId;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String repId = this.read_string();
        this.getRepIdMap().put(ObjectUtil.newInteger(start_offset), repId);
        return repId;
    }

    private String read_codebase() {
        int tag = this.read_long();
        if (tag == -1) {
            int index = this.read_long();
            index = index + this.pos - 4;
            String codebase = (String)this.getCodebaseMap().get(ObjectUtil.newInteger(index));
            if (codebase == null) {
                throw new MARSHAL("stale codebase indirection");
            }
            return codebase;
        }
        this.pos -= 4;
        this.index -= 4;
        int start_offset = this.pos;
        String codebase = this.read_string();
        this.getCodebaseMap().put(ObjectUtil.newInteger(start_offset), codebase);
        return codebase;
    }

    private Serializable read_indirect_value() {
        int index = this.read_long();
        index = index + this.pos - 4;
        java.lang.Object value = this.getValueMap().get(ObjectUtil.newInteger(index));
        if (value == null) {
            throw new IndirectionException(index);
        }
        return (Serializable)value;
    }

    private String validateName(String name) {
        if (name != null && name.length() == 0) {
            return null;
        }
        return name;
    }

    private String validateID(String id) {
        if (id == null || id.length() == 0) {
            return "IDL:";
        }
        return id;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_boolean() ? this.read_Object() : this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        return this.read_boolean() ? this.read_Object(clazz) : this.read_value(clazz);
    }

    public int get_pos() {
        return this.pos;
    }

    public void register_value(Serializable value) {
        this.getValueMap().put(ObjectUtil.newInteger(this.currentValueIndex), value);
    }

    public void updateMutatorConnection(GIOPConnection connection) {
        if (this.isMutatorEnabled) {
            this.mutator.updateConnection(connection.getTransport());
        }
    }

    private static final class Pair {
        public final org.omg.CORBA.TypeCode typeCode;
        public final Integer position;

        public Pair(org.omg.CORBA.TypeCode typeCode, Integer position) {
            this.typeCode = typeCode;
            this.position = position;
        }

        public String toString() {
            return this.typeCode + " and " + this.position;
        }
    }
}

