/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.config.LogKitLoggerFactory;
import org.jacorb.config.LoggerFactory;
import org.jacorb.util.ObjectUtil;

public class LogUtil {
    private static final LoggerFactory sLoggerFactory = LogUtil.newLoggerFactory();

    private static LoggerFactory newLoggerFactory() {
        try {
            org.jacorb.config.Configuration config = JacORBConfiguration.getConfiguration(new Properties(), null, false);
            LoggerFactory factory = LogUtil.newLog4jLoggerFactory(config);
            if (factory == null) {
                factory = LogUtil.newLogKitFactory(config);
            }
            if (factory == null) {
                throw new RuntimeException();
            }
            return factory;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("unable to create LoggerFactory for class " + LogUtil.class.getName());
        }
    }

    private static LoggerFactory newLog4jLoggerFactory(org.jacorb.config.Configuration config) {
        String clazzName = "org.jboss.util.Log4jLoggerFactory";
        try {
            ObjectUtil.classForName("org.apache.log4j.Level");
            Class clazz = ObjectUtil.classForName(clazzName);
            Constructor ctor = clazz.getConstructor(new Class[0]);
            LoggerFactory factory = (LoggerFactory)ctor.newInstance(new Object[0]);
            factory.configure(config);
            return factory;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    private static LoggerFactory newLogKitFactory(org.jacorb.config.Configuration config) {
        try {
            LogKitLoggerFactory loggerFactory = new LogKitLoggerFactory();
            loggerFactory.configure(config);
            return loggerFactory;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException();
        }
    }

    public static Logger getLogger(Configuration config, String name) {
        try {
            return ((org.jacorb.config.Configuration)config).getNamedLogger(name);
        }
        catch (ClassCastException e) {
            return LogUtil.getLogger(name);
        }
    }

    public static Logger getLogger(String name) {
        return sLoggerFactory.getNamedLogger(name);
    }
}

