/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.AbstractPoolable;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.WeakHashSet;

public abstract class AbstractObjectPool
implements Runnable,
Configurable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 5000L;
    public static final int LOWER_WATERMARK_DEFAULT = 5;
    public static final int SIZE_INCREASE_DEFAULT = 3;
    public static final int INITIAL_SIZE_DEFAULT = 10;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 20;
    public static final int MAXIMUM_SIZE_DEFAULT = 0;
    private static final List sPoolsToLookAfter = new ArrayList();
    private static AbstractObjectPool[] asArray;
    private static boolean modified;
    private static final AbstractObjectPool[] ARRAY_TEMPLATE;
    private static Thread sCleanerThread;
    private static final Logger sLogger_;
    private static ListCleaner sListCleaner;
    private static boolean sUseListCleaner;
    private final String name_;
    private final LinkedList pool_;
    private boolean isInitialized_;
    private final Set active_ = Collections.synchronizedSet(new WeakHashSet());
    private int lowerWatermark_;
    private int maxWatermark_;
    private int sizeIncrease_;
    private int initialSize_;
    private int maximumSize_;
    protected final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    protected Configuration config_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractObjectPool[] getAllPools() {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            if (modified) {
                asArray = sPoolsToLookAfter.toArray(ARRAY_TEMPLATE);
                modified = false;
            }
        }
        return asArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPool(AbstractObjectPool pool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.add(pool);
            modified = true;
            AbstractObjectPool.startListCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterPool(AbstractObjectPool pool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.remove(pool);
            modified = true;
            if (sPoolsToLookAfter.isEmpty()) {
                AbstractObjectPool.getAllPools();
                AbstractObjectPool.stopListCleaner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListCleaner getListCleaner() {
        Class clazz = AbstractObjectPool.class;
        synchronized (clazz) {
            if (sListCleaner == null) {
                sListCleaner = new ListCleaner();
            }
            return sListCleaner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopListCleaner() {
        Class clazz = AbstractObjectPool.class;
        synchronized (clazz) {
            if (sCleanerThread != null) {
                sListCleaner.setInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startListCleaner() {
        Class clazz = AbstractObjectPool.class;
        synchronized (clazz) {
            if (sCleanerThread == null && sUseListCleaner) {
                sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                sCleanerThread.setName("ObjectPoolCleaner");
                sCleanerThread.setPriority(2);
                sCleanerThread.setDaemon(true);
                sCleanerThread.start();
            }
        }
    }

    public void configure(Configuration conf) {
        this.config_ = conf;
        this.init();
    }

    protected AbstractObjectPool(String name) {
        this(name, 5, 3, 10, 20, 0);
    }

    protected AbstractObjectPool(String name, int lowerWatermark, int sizeincrease, int initialsize, int maxWatermark, int maximumSize) {
        if (maximumSize > 0 && initialsize > maximumSize) {
            throw new IllegalArgumentException("InitialSize: " + initialsize + " may not be larger than MaximumSize: " + maximumSize);
        }
        this.name_ = name;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = lowerWatermark;
        this.sizeIncrease_ = sizeincrease;
        this.initialSize_ = initialsize;
        this.maxWatermark_ = maxWatermark;
        this.maximumSize_ = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int maxToBeCreated;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (this.pool_.size() > this.lowerWatermark_) {
                return;
            }
            maxToBeCreated = this.getNumberOfCreationsAllowed();
        }
        int sizeIncrease = Math.min(this.sizeIncrease_, maxToBeCreated);
        if (sizeIncrease > 0) {
            ArrayList<Object> os = new ArrayList<Object>(sizeIncrease);
            for (int x = 0; x < sizeIncrease; ++x) {
                Object _i = this.createInstance();
                os.add(_i);
            }
            LinkedList linkedList2 = this.pool_;
            synchronized (linkedList2) {
                this.pool_.addAll(os);
            }
        }
    }

    private int getNumberOfCreationsAllowed() {
        int maxToBeCreated = this.maximumSize_ > 0 ? this.maximumSize_ - this.active_.size() - this.pool_.size() : Integer.MAX_VALUE;
        return maxToBeCreated;
    }

    private Object createInstance() {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("created newInstance " + this.getInfo());
        }
        return this.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AbstractObjectPool.registerPool(this);
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (this.isInitialized_) {
                throw new IllegalStateException("Already Initialized");
            }
            for (int x = 0; x < this.initialSize_; ++x) {
                Object _i = this.createInstance();
                this.pool_.add(_i);
            }
            this.isInitialized_ = true;
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
        this.disposeCollection(this.pool_);
        this.pool_.clear();
        this.disposeCollection(this.active_);
        this.active_.clear();
    }

    private void disposeCollection(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            try {
                Disposable disposable = (Disposable)o;
                try {
                    ((AbstractPoolable)o).setObjectPool(null);
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                disposable.dispose();
            }
            catch (ClassCastException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lendObject() {
        this.checkIsInitialized();
        Object _result = null;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.pool_.isEmpty()) {
                _result = this.pool_.removeFirst();
            }
            if (_result == null) {
                while (!this.isCreationAllowed()) {
                    this.poolIsEmpty();
                }
            }
        }
        if (_result == null) {
            _result = this.createInstance();
        }
        try {
            ((Configurable)_result).configure(this.config_);
        }
        catch (ClassCastException cce) {
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException("Could not configure instance");
        }
        this.doActivateObject(_result);
        this.active_.add(_result);
        return _result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsInitialized() {
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.isInitialized_) {
                throw new IllegalStateException("Not initialized");
            }
        }
    }

    protected boolean isCreationAllowed() {
        return this.getNumberOfCreationsAllowed() > 0;
    }

    protected void poolIsEmpty() {
        throw new RuntimeException(this.getInfo() + ": No more Elements allowed. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object o) {
        this.checkIsInitialized();
        if (this.active_.remove(o)) {
            this.doPassivateObject(o);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(o);
                    this.pool_.notifyAll();
                }
            } else {
                this.doDestroyObject(o);
            }
        } else {
            throw new IllegalArgumentException("Object " + o + " was not created by this pool");
        }
    }

    public String toString() {
        return this.getInfo();
    }

    private String getInfo() {
        return "[" + this.name_ + "] Active=" + this.active_.size() + " Pooled=" + this.pool_.size() + " MaximumSize=" + (this.maximumSize_ > 0 ? Integer.toString(this.maximumSize_) : "unlimited");
    }

    public abstract Object newInstance();

    public void doPassivateObject(Object o) {
    }

    public void doActivateObject(Object o) {
    }

    public void doDestroyObject(Object o) {
    }

    static {
        modified = true;
        ARRAY_TEMPLATE = new AbstractObjectPool[0];
        sLogger_ = LogUtil.getLogger(AbstractObjectPool.class.getName());
        sUseListCleaner = true;
    }

    private static class ListCleaner
    extends Thread {
        private AtomicBoolean active_ = new AtomicBoolean(true);

        private ListCleaner() {
        }

        public void setInactive() {
            this.active_.set(false);
            this.interrupt();
        }

        private void ensureIsActive() throws InterruptedException {
            if (!this.active_.get()) {
                throw new InterruptedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz;
            try {
                while (this.active_.get()) {
                    try {
                        this.runLoop();
                    }
                    catch (InterruptedException e) {
                        sLogger_.info("PoolCleaner was interrupted");
                    }
                    catch (Exception e) {
                        sLogger_.error("Error cleaning Pool", e);
                    }
                }
                clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            }
            catch (Throwable throwable) {
                Class clazz2 = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
                synchronized (clazz2) {
                    sCleanerThread = null;
                }
                throw throwable;
            }
            synchronized (clazz) {
                sCleanerThread = null;
            }
        }

        private void runLoop() throws InterruptedException {
            block4: while (true) {
                try {
                    ListCleaner.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.ensureIsActive();
                AbstractObjectPool[] poolsToCheck = AbstractObjectPool.getAllPools();
                int x = 0;
                while (true) {
                    if (x >= poolsToCheck.length) continue block4;
                    try {
                        poolsToCheck[x].run();
                    }
                    catch (Exception t) {
                        sLogger_.error("Error cleaning up Pool", t);
                    }
                    ++x;
                }
                break;
            }
        }
    }
}

