/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.MessagePushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImplMBean;
import org.omg.CORBA.ORB;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerOperations;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class StructuredProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements StructuredProxyPushSupplierOperations,
StructuredProxyPushSupplierImplMBean {
    private StructuredPushConsumerOperations pushConsumer_;
    private long timeSpent_;

    public StructuredProxyPushSupplierImpl(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_STRUCTURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushEvent() {
        Message _message = this.getMessageNoBlock();
        if (_message != null) {
            try {
                boolean bl = this.deliverMessageWithRetry(_message);
                return bl;
            }
            finally {
                _message.dispose();
            }
        }
        return false;
    }

    private boolean deliverMessageWithRetry(Message message) {
        try {
            this.deliverMessageInternal(message);
            return true;
        }
        catch (Exception e) {
            PushStructuredOperation _failedOperation = new PushStructuredOperation(message);
            this.handleFailedPushOperation(_failedOperation, e);
            return false;
        }
    }

    private void deliverMessageInternal(Message message) throws Disconnected {
        long now = System.currentTimeMillis();
        this.pushConsumer_.push_structured_event(message.toStructuredEvent());
        long _duration = System.currentTimeMillis() - now;
        this.timeSpent_ += _duration;
        this.resetErrorCounter();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Push took " + _duration + " ms");
        }
    }

    public void connect_structured_push_consumer(StructuredPushConsumer consumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("connect structured_push_consumer");
        }
        this.pushConsumer_ = consumer;
        this.connectClient(consumer);
    }

    public void disconnect_structured_push_supplier() {
        this.destroy();
    }

    protected void connectionResumed() {
        this.scheduleFlush();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_structured_push_consumer();
        this.pushConsumer_ = null;
    }

    public Servant newServant() {
        return new StructuredProxyPushSupplierPOATie(this);
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    private class PushStructuredOperation
    extends MessagePushOperation {
        public PushStructuredOperation(Message message) {
            super(message);
        }

        public void invokePush() throws Disconnected {
            StructuredProxyPushSupplierImpl.this.deliverMessageInternal(this.message_);
        }
    }
}

