/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxySupplierTask
extends AbstractFilterTask {
    public static final AlternateMessageMap EMPTY_MAP = new AlternateMessageMap(Collections.EMPTY_MAP){

        public void clear() {
        }
    };
    final AlternateMessageMap changedMessages_ = new AlternateMessageMap();
    private static int sCount = 0;
    private int id_ = ++sCount;

    public FilterProxySupplierTask(TaskFactory taskFactory, TaskExecutor taskExecutor) {
        super(taskFactory, taskExecutor);
    }

    public String toString() {
        return "[FilterProxySupplierTask#" + this.id_ + "]";
    }

    public void reset() {
        super.reset();
        this.changedMessages_.clear();
    }

    public void doFilter() throws InterruptedException {
        this.filter();
        this.getTaskFactory().enqueueMessage(this);
    }

    private Message updatePriority(int indexOfCurrentEvent, Message message) {
        Message _currentMessage;
        block4: {
            AnyHolder _priorityFilterResult = new AnyHolder();
            _currentMessage = message;
            try {
                boolean priorityMatch = message.match(this.arrayCurrentFilterStage_[indexOfCurrentEvent].getPriorityFilter(), _priorityFilterResult);
                if (priorityMatch) {
                    _currentMessage = (Message)this.getMessage().clone();
                    _currentMessage.setPriority(_priorityFilterResult.value.extract_long());
                }
            }
            catch (UnsupportedFilterableData e) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("unable to evaluate PriorityFilter", e);
                }
                if (!this.logger_.isInfoEnabled()) break block4;
                this.logger_.info("unable to evaluate PriorityFilter");
            }
        }
        return _currentMessage;
    }

    private Message updateTimeout(int indexOfCurrentFilterStage, Message message) {
        Message _currentMessage;
        block4: {
            AnyHolder _lifetimeFilterResult = new AnyHolder();
            _currentMessage = message;
            try {
                boolean lifetimeMatch = _currentMessage.match(this.arrayCurrentFilterStage_[indexOfCurrentFilterStage].getLifetimeFilter(), _lifetimeFilterResult);
                if (lifetimeMatch && _currentMessage == this.getMessage()) {
                    _currentMessage = (Message)this.getMessage().clone();
                    _currentMessage.setTimeout(_lifetimeFilterResult.value.extract_long());
                }
            }
            catch (UnsupportedFilterableData e) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("unable to evaluate PriorityFilter", e);
                }
                if (!this.logger_.isInfoEnabled()) break block4;
                this.logger_.info("unable to evaluate PriorityFilter");
            }
        }
        return _currentMessage;
    }

    private void filter() {
        for (int x = 0; x < this.arrayCurrentFilterStage_.length; ++x) {
            boolean _forward = false;
            if (!this.arrayCurrentFilterStage_[x].isDestroyed()) {
                Message _currentMessage = this.getMessage();
                if (this.arrayCurrentFilterStage_[x].hasPriorityFilter()) {
                    _currentMessage = this.updatePriority(x, _currentMessage);
                }
                if (this.arrayCurrentFilterStage_[x].hasLifetimeFilter()) {
                    _currentMessage = this.updateTimeout(x, _currentMessage);
                }
                if (_currentMessage != this.getMessage()) {
                    this.changedMessages_.putAlternateMessage(this.arrayCurrentFilterStage_[x], _currentMessage);
                }
                _forward = _currentMessage.match(this.arrayCurrentFilterStage_[x]);
            }
            if (!_forward) continue;
            this.addFilterStage(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
        }
    }

    static class AlternateMessageMap {
        private final Map alternateMessages_;

        public AlternateMessageMap() {
            this(new HashMap());
        }

        AlternateMessageMap(Map m) {
            this.alternateMessages_ = m;
        }

        public Message getAlternateMessage(FilterStage s) {
            if (this.alternateMessages_.containsKey(s)) {
                return (Message)this.alternateMessages_.get(s);
            }
            return null;
        }

        public void putAlternateMessage(FilterStage s, Message e) {
            this.alternateMessages_.put(s, e);
        }

        public void clear() {
            this.alternateMessages_.clear();
        }
    }
}

