/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxyConsumerTask
extends AbstractFilterTask {
    private static int sCount = 0;
    private final int id_ = ++sCount;
    private boolean orSemantic_ = false;

    public FilterProxyConsumerTask(TaskFactory factory, TaskExecutor executor) {
        super(factory, executor);
    }

    public String toString() {
        return "[FilterProxyConsumerTask#" + this.id_ + "]";
    }

    public void reset() {
        super.reset();
        this.orSemantic_ = false;
    }

    public boolean getSkip() {
        return this.orSemantic_;
    }

    private void updatePriority() {
        try {
            AnyHolder newPriority = new AnyHolder();
            boolean priorityMatch = this.getMessage().match(this.arrayCurrentFilterStage_[0].getPriorityFilter(), newPriority);
            if (priorityMatch) {
                this.getMessage().setPriority(newPriority.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData e) {
            this.logger_.error("Error evaluating PriorityFilter", e);
        }
    }

    private void updateLifetime() {
        try {
            AnyHolder newLifetime = new AnyHolder();
            boolean lifetimeMatch = this.getMessage().match(this.arrayCurrentFilterStage_[0].getLifetimeFilter(), newLifetime);
            if (lifetimeMatch) {
                this.getMessage().setTimeout(newLifetime.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData e) {
            this.logger_.error("Error evaluating LifetimeFilter", e);
        }
    }

    public void doFilter() throws InterruptedException {
        boolean _filterMatch;
        if (this.arrayCurrentFilterStage_[0].hasPriorityFilter()) {
            this.updatePriority();
        }
        if (this.arrayCurrentFilterStage_[0].hasLifetimeFilter()) {
            this.updateLifetime();
        }
        if (!(_filterMatch = this.filter()) && this.arrayCurrentFilterStage_[0].hasInterFilterGroupOperatorOR()) {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("filter failed, but the ProxyConsumer" + this.arrayCurrentFilterStage_[0] + " has InterFilterGroupOperator OR_OP Enabled");
            }
            this.addFilterStage(this.arrayCurrentFilterStage_[0].getSubsequentFilterStages());
        }
        if (!this.isFilterStageListEmpty()) {
            this.getTaskFactory().newFilterSupplierAdminTask(this).schedule();
        }
    }

    private boolean filter() {
        boolean _forward = false;
        _forward = this.getMessage().match(this.arrayCurrentFilterStage_[0]);
        if (_forward) {
            this.addFilterStage(this.arrayCurrentFilterStage_[0].getSubsequentFilterStages());
        }
        if (this.arrayCurrentFilterStage_[0].hasInterFilterGroupOperatorOR()) {
            this.orSemantic_ = true;
        }
        return _forward;
    }

    public void schedule() {
        this.schedule(false);
    }
}

