/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Date;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.DefaultTaskExecutor;
import org.jacorb.notification.engine.DefaultTaskProcessorMBean;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.util.DisposableManager;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;

public class DefaultTaskProcessor
implements TaskProcessor,
Disposable,
JMXManageable,
DefaultTaskProcessorMBean {
    final Logger logger_;
    private TaskExecutor pullTaskExecutor_;
    private ScheduledExecutorService clockDaemon_;
    private final TaskFactory taskFactory_;
    private final DisposableManager disposables_ = new DisposableManager();
    private int pullWorkerPoolSize_;
    private int filterWorkerPoolSize_;

    public DefaultTaskProcessor(Configuration config, TaskFactory taskFactory) {
        this.clockDaemon_ = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactory(){

            public Thread newThread(Runnable command) {
                Thread _t = new Thread(command);
                _t.setName("ClockDaemonThread");
                return _t;
            }
        });
        this.logger_ = ((org.jacorb.config.Configuration)config).getNamedLogger(this.getClass().getName());
        this.logger_.info("create TaskProcessor");
        this.pullWorkerPoolSize_ = config.getAttributeAsInteger("jacorb.notification.proxyconsumer.thread_pool_size", 2);
        this.pullTaskExecutor_ = new DefaultTaskExecutor("PullThread", this.pullWorkerPoolSize_, true);
        this.filterWorkerPoolSize_ = config.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.taskFactory_ = taskFactory;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutdown();
        this.pullTaskExecutor_.dispose();
        this.disposables_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message mesg) {
        if (mesg.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (mesg.getStopTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(mesg);
                mesg.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(mesg);
        }
        if (mesg.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(mesg);
        }
        if (mesg.hasStartTime() && mesg.getStartTime() > System.currentTimeMillis()) {
            new DeferedStartTask(mesg);
        } else {
            this.processMessageInternal(mesg);
        }
    }

    protected void processMessageInternal(Message event) {
        Schedulable _task = this.taskFactory_.newFilterProxyConsumerTask(event);
        _task.schedule();
    }

    public void scheduleTimedPullTask(MessageSupplier messageSupplier) {
        PullFromSupplierTask _task = new PullFromSupplierTask(this.pullTaskExecutor_);
        _task.setTarget(messageSupplier);
        _task.schedule();
    }

    private ScheduledExecutorService getClockDaemon() {
        return this.clockDaemon_;
    }

    public ScheduledFuture executeTaskPeriodically(long intervall, Runnable task, boolean startImmediately) {
        return this.getClockDaemon().scheduleAtFixedRate(task, startImmediately ? 0L : intervall, intervall, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture executeTaskAfterDelay(long delay, Runnable task) {
        return this.clockDaemon_.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    Object executeTaskAt(long startTime, Runnable task) {
        return this.executeTaskAt(new Date(startTime), task);
    }

    Object executeTaskAt(Date startTime, Runnable task) {
        long now = System.currentTimeMillis();
        long then = startTime.getTime();
        long delay = then - now;
        if (delay < 1000L) {
            delay = 1000L;
        }
        return this.clockDaemon_.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    private void fireEventDiscarded(Message event) {
        switch (event.getType()) {
            case 0: {
                this.fireEventDiscarded(event.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(event.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void fireEventDiscarded(Any a) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + a + " has been discarded");
        }
    }

    private void fireEventDiscarded(StructuredEvent e) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + e + " has been discarded");
        }
    }

    public String getJMXObjectName() {
        return "service=TaskProcessor";
    }

    public void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public String[] getJMXNotificationTypes() {
        return null;
    }

    public void setJMXCallback(JMXManageable.JMXCallback callback) {
    }

    public int getFilterWorkerPoolSize() {
        return this.filterWorkerPoolSize_;
    }

    public int getPullWorkerPoolSize() {
        return this.pullWorkerPoolSize_;
    }

    class DeferedStartTask
    implements Runnable {
        final Message message_;

        DeferedStartTask(Message m) {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Message with Option StartTime=" + m.getStartTime() + " will be defered until then");
            }
            this.message_ = m;
            DefaultTaskProcessor.this.executeTaskAt(this.message_.getStartTime(), (Runnable)this);
        }

        public void run() {
            if (DefaultTaskProcessor.this.logger_.isDebugEnabled()) {
                DefaultTaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            DefaultTaskProcessor.this.processMessageInternal(this.message_);
        }
    }

    private class DeferedStopTask
    implements Runnable {
        final Message message_;

        public DeferedStopTask(Message message) {
            this.message_ = message;
            DefaultTaskProcessor.this.executeTaskAt(message.getStopTime(), (Runnable)this);
        }

        public void run() {
            this.message_.actionTimeout();
        }
    }

    private class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        ScheduledFuture timerRegistration_;
        final Message message_;

        public TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }

        public void actionLifetimeChanged(long timeout) {
            this.timerRegistration_.cancel(true);
            this.timerRegistration_ = DefaultTaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            DefaultTaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }
    }
}

