/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.engine.DefaultTaskExecutor;
import org.jacorb.notification.engine.FilterConsumerAdminTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.FilterSupplierAdminTask;
import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.util.AbstractPoolablePool;

public class DefaultTaskFactory
implements Disposable,
TaskFactory {
    private final TaskExecutor filterTaskExecutor_;
    private final int filterWorkerPoolSize_;
    private final AbstractPoolablePool filterProxyConsumerTaskPool_ = new AbstractPoolablePool("FilterProxyConsumerTaskPool"){

        public Object newInstance() {
            return new FilterProxyConsumerTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterSupplierAdminTaskPool_ = new AbstractPoolablePool("FilterSupplierAdminTaskPool"){

        public Object newInstance() {
            return new FilterSupplierAdminTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterConsumerAdminTaskPool_ = new AbstractPoolablePool("FilterConsumerAdminTaskPool"){

        public Object newInstance() {
            return new FilterConsumerAdminTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };
    private final AbstractPoolablePool filterProxySupplierTaskPool_ = new AbstractPoolablePool("FilterProxySupplierTaskPool"){

        public Object newInstance() {
            return new FilterProxySupplierTask(DefaultTaskFactory.this, DefaultTaskFactory.this.filterTaskExecutor_);
        }
    };

    public DefaultTaskFactory(Configuration config) {
        this.filterWorkerPoolSize_ = config.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.filterTaskExecutor_ = new DefaultTaskExecutor("FilterThread", this.filterWorkerPoolSize_);
        this.configure(config);
    }

    private void configure(Configuration conf) {
        this.filterProxyConsumerTaskPool_.configure(conf);
        this.filterProxySupplierTaskPool_.configure(conf);
        this.filterConsumerAdminTaskPool_.configure(conf);
        this.filterSupplierAdminTaskPool_.configure(conf);
    }

    public void dispose() {
        this.filterTaskExecutor_.dispose();
        this.filterProxyConsumerTaskPool_.dispose();
        this.filterProxySupplierTaskPool_.dispose();
        this.filterConsumerAdminTaskPool_.dispose();
        this.filterSupplierAdminTaskPool_.dispose();
    }

    private FilterProxyConsumerTask newFilterProxyConsumerTask() {
        return (FilterProxyConsumerTask)this.filterProxyConsumerTaskPool_.lendObject();
    }

    public Schedulable newFilterProxyConsumerTask(Message message) {
        FilterProxyConsumerTask task = this.newFilterProxyConsumerTask();
        task.setMessage(message);
        task.setCurrentFilterStage(new FilterStage[]{message.getInitialFilterStage()});
        return task;
    }

    private FilterSupplierAdminTask newFilterSupplierAdminTask() {
        return (FilterSupplierAdminTask)this.filterSupplierAdminTaskPool_.lendObject();
    }

    public Schedulable newFilterSupplierAdminTask(FilterProxyConsumerTask oldTask) {
        FilterSupplierAdminTask _newTask = this.newFilterSupplierAdminTask();
        if (oldTask.getFilterStageToBeProcessed().length != 1) {
            throw new RuntimeException();
        }
        _newTask.setMessage(oldTask.removeMessage());
        _newTask.setCurrentFilterStage(oldTask.getFilterStageToBeProcessed());
        _newTask.setSkip(oldTask.getSkip());
        return _newTask;
    }

    private FilterConsumerAdminTask newFilterConsumerAdminTask() {
        return (FilterConsumerAdminTask)this.filterConsumerAdminTaskPool_.lendObject();
    }

    public Schedulable newFilterConsumerAdminTask(FilterSupplierAdminTask oldTask) {
        FilterConsumerAdminTask _newTask = this.newFilterConsumerAdminTask();
        _newTask.setMessage(oldTask.removeMessage());
        _newTask.setCurrentFilterStage(oldTask.getFilterStageToBeProcessed());
        return _newTask;
    }

    private FilterProxySupplierTask newFilterProxySupplierTask() {
        return (FilterProxySupplierTask)this.filterProxySupplierTaskPool_.lendObject();
    }

    public Schedulable newFilterProxySupplierTask(FilterConsumerAdminTask task) {
        FilterProxySupplierTask _newTask = this.newFilterProxySupplierTask();
        _newTask.setMessage(task.removeMessage());
        FilterStage[] _filterStageList = task.getFilterStageToBeProcessed();
        _newTask.setCurrentFilterStage(_filterStageList);
        return _newTask;
    }

    public void enqueueMessage(FilterStage[] nodes, Message mesg) {
        this.enqueueMessage(nodes, mesg, FilterProxySupplierTask.EMPTY_MAP);
    }

    private void enqueueMessage(FilterStage[] filterStagesWithMessageConsumer, Message mesg, FilterProxySupplierTask.AlternateMessageMap map) {
        for (int x = 0; x < filterStagesWithMessageConsumer.length; ++x) {
            MessageConsumer consumer = filterStagesWithMessageConsumer[x].getMessageConsumer();
            Message alternateMessage = map.getAlternateMessage(filterStagesWithMessageConsumer[x]);
            if (alternateMessage != null) {
                consumer.queueMessage(alternateMessage);
                continue;
            }
            consumer.queueMessage(mesg);
        }
    }

    public void enqueueMessage(FilterProxySupplierTask task) {
        Message _message = task.removeMessage();
        FilterStage[] _seqFilterStageToBeProcessed = task.getFilterStageToBeProcessed();
        this.enqueueMessage(_seqFilterStageToBeProcessed, _message, task.changedMessages_);
    }
}

