/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractMessageTask;
import org.jacorb.notification.engine.AbstractTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.FilterStage;

public abstract class AbstractFilterTask
extends AbstractMessageTask {
    private final TaskFactory taskFactory_;
    private static final boolean STRICT_CHECKING = true;
    protected static final FilterStage[] EMPTY_FILTERSTAGE = new FilterStage[0];
    protected FilterStage[] arrayCurrentFilterStage_;
    private final List listOfFilterStageToBeProcessed_ = new ArrayList();

    protected AbstractFilterTask(TaskFactory taskFactory, TaskExecutor taskExecutor) {
        this.setTaskExecutor(taskExecutor);
        this.taskFactory_ = taskFactory;
        this.arrayCurrentFilterStage_ = EMPTY_FILTERSTAGE;
    }

    public final void doWork() throws InterruptedException {
        if (this.arrayCurrentFilterStage_.length > 0) {
            this.doFilter();
        }
    }

    protected abstract void doFilter() throws InterruptedException;

    protected TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    protected boolean isFilterStageListEmpty() {
        return this.listOfFilterStageToBeProcessed_.isEmpty();
    }

    protected void addFilterStage(FilterStage s) {
        this.listOfFilterStageToBeProcessed_.add(s);
    }

    protected void addFilterStage(List s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof FilterStage) continue;
            throw new IllegalArgumentException();
        }
        this.listOfFilterStageToBeProcessed_.addAll(s);
    }

    public void setCurrentFilterStage(FilterStage[] currentFilterStage) {
        this.arrayCurrentFilterStage_ = currentFilterStage;
    }

    public FilterStage[] getFilterStageToBeProcessed() {
        return this.listOfFilterStageToBeProcessed_.toArray(EMPTY_FILTERSTAGE);
    }

    public void clearFilterStageToBeProcessed() {
        this.listOfFilterStageToBeProcessed_.clear();
    }

    public synchronized void reset() {
        super.reset();
        this.clearFilterStageToBeProcessed();
        this.arrayCurrentFilterStage_ = EMPTY_FILTERSTAGE;
    }

    public void handleTaskError(AbstractTask task, Exception error) {
        this.logger_.fatalError("Error while Filtering in Task:" + task, error);
    }

    public void schedule() {
        this.schedule(false);
    }
}

