/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;

public class FilterManager
implements FilterAdminOperations {
    public static final FilterManager EMPTY_FILTER_MANAGER = new FilterManager(Collections.EMPTY_MAP);
    private static final Integer[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private final Map filters_;
    private final Object filtersLock_ = new Object();
    private boolean filtersModified_;
    private final List filterList_ = new ArrayList();
    private final List filtersReadOnlyView_ = Collections.unmodifiableList(this.filterList_);
    private final AtomicInteger filterIdPool_ = new AtomicInteger(0);
    private final Logger logger_;

    protected FilterManager(Map filters) {
        this.filters_ = filters;
        this.filtersModified_ = true;
        this.logger_ = LogUtil.getLogger(this.getClass().getName());
    }

    public FilterManager() {
        this(new HashMap());
    }

    private Integer newFilterID() {
        return new Integer(this.filterIdPool_.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add_filter(Filter filter) {
        Integer _key = this.newFilterID();
        if (this.logger_.isInfoEnabled()) {
            try {
                if (!((ObjectImpl)((Object)filter))._is_local()) {
                    this.logger_.info("filter is not local!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.put(_key, filter);
            this.filtersModified_ = true;
        }
        return _key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_filter(int filterId) throws FilterNotFound {
        Integer _key = new Integer(filterId);
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filters_.containsKey(_key)) {
                this.filters_.remove(_key);
                this.filtersModified_ = true;
            } else {
                this.throwFilterNotFound(_key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter get_filter(int filterId) throws FilterNotFound {
        Filter _filter;
        Integer _key = new Integer(filterId);
        Object object = this.filtersLock_;
        synchronized (object) {
            _filter = (Filter)this.filters_.get(_key);
        }
        if (_filter == null) {
            this.throwFilterNotFound(_key);
        }
        return _filter;
    }

    private void throwFilterNotFound(Integer filterId) throws FilterNotFound {
        throw new FilterNotFound("Filter with ID=" + filterId + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get_all_filters() {
        Integer[] _keys;
        Object object = this.filtersLock_;
        synchronized (object) {
            _keys = this.filters_.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        }
        int[] _intKeys = new int[_keys.length];
        for (int x = 0; x < _keys.length; ++x) {
            _intKeys[x] = _keys[x];
        }
        return _intKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_filters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.clear();
            this.filtersModified_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filtersModified_) {
                this.filterList_.clear();
                this.filterList_.addAll(this.filters_.values());
                this.filtersModified_ = false;
            }
        }
        return this.filtersReadOnlyView_;
    }
}

