/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class ContextLister {
    public NamingContextExt root_context;
    private Hashtable contexts = new Hashtable();
    private ORB orb;

    public ContextLister(ORB orb) {
        this.orb = orb;
        try {
            Object obj = orb.resolve_initial_references("NameService");
            this.root_context = NamingContextExtHelper.narrow(obj);
        }
        catch (InvalidName inex) {
            inex.printStackTrace();
        }
        catch (SystemException corba_exception) {
            System.err.println(corba_exception);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    public ContextLister(ORB orb, String str) {
        this.orb = orb;
        try {
            Object obj = orb.string_to_object(str);
            this.root_context = NamingContextExtHelper.narrow(obj);
        }
        catch (SystemException corba_exception) {
            System.err.println(corba_exception);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    private void mark(NamingContextExt nc) {
        this.contexts.put(this.orb.object_to_string(nc), "");
    }

    private boolean isMarked(NamingContextExt nc) {
        return this.contexts.containsKey(this.orb.object_to_string(nc));
    }

    public void list(PrintStream ps) {
        this.list(this.root_context, "   ", ps);
    }

    private void list(NamingContextExt n, String indent, PrintStream ps) {
        if (this.isMarked(n)) {
            return;
        }
        this.mark(n);
        try {
            BindingListHolder blsoh = new BindingListHolder(new Binding[0]);
            BindingIteratorHolder bioh = new BindingIteratorHolder();
            n.list(0, blsoh, bioh);
            BindingHolder bh = new BindingHolder();
            if (bioh.value == null) {
                return;
            }
            while (bioh.value.next_one(bh)) {
                String stringName = this.root_context.to_string(bh.value.binding_name);
                ps.print(indent + stringName);
                if (bh.value.binding_type.value() == 1) {
                    String _indent = indent + "\t";
                    ps.println("/");
                    NameComponent[] name = this.root_context.to_name(stringName);
                    NamingContextExt sub_context = NamingContextExtHelper.narrow(n.resolve(name));
                    this.list(sub_context, _indent, ps);
                    continue;
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ORB orb = ORB.init(args, null);
        PrintStream pw = System.out;
        String url = null;
        for (int i = 0; i < args.length; i += 2) {
            try {
                if (args[i].startsWith("-f")) {
                    try {
                        pw = new PrintStream(new FileOutputStream(args[i + 1]));
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe.getMessage());
                        System.exit(1);
                    }
                    continue;
                }
                if (!args[i].startsWith("-url")) continue;
                url = args[i + 1];
                continue;
            }
            catch (Exception e) {
                System.err.println("Usage: org.jacorb.naming.ContextLister [-url object url] [-f output file]");
                System.exit(1);
            }
        }
        ContextLister ctxLister = url != null ? new ContextLister(orb, url) : new ContextLister(orb);
        ctxLister.list(pw);
        orb.shutdown(true);
    }
}

