/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;

public class JacORBConfiguration
extends DefaultConfiguration
implements Configuration {
    private static final String CONFIG_LOG_VERBOSITY = "jacorb.config.log.verbosity";
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private final ORB orb;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private static final String loggerFactoryClzName = "org.jacorb.config.LogKitLoggerFactory";

    public static Configuration getConfiguration(Properties props, ORB orb, boolean isApplet) throws ConfigurationException {
        String tmp;
        String orbID = "jacorb";
        String myOrbID = null;
        if (!isApplet) {
            try {
                myOrbID = System.getProperty("ORBid");
            }
            catch (SecurityException e) {
                isApplet = true;
                JacORBConfiguration.println("Could not access system property 'ORBid' - will use default...");
            }
        }
        if (props != null && (tmp = (String)props.get("ORBid")) != null) {
            myOrbID = tmp;
        }
        if (myOrbID != null) {
            if (myOrbID.equals("orb") || myOrbID.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + myOrbID + "> is reserved");
            }
            orbID = myOrbID;
        }
        return new JacORBConfiguration(orbID, props, orb, isApplet);
    }

    private JacORBConfiguration(String name, Properties orbProperties, ORB orb, boolean isApplet) throws ConfigurationException {
        super(name);
        this.orb = orb;
        if (isApplet) {
            this.initApplet(name, orbProperties);
        } else {
            this.init(name, orbProperties);
        }
        this.initLogging();
    }

    private static void println(String mesg) {
        System.out.println(mesg);
    }

    private static void printErr(String mesg) {
        System.err.println(mesg);
    }

    private void init(String name, Properties orbProperties) throws ConfigurationException {
        List customPropFileNames;
        String configDir;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String separator = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String lib = System.getProperty("java.home");
        boolean loaded = false;
        this.setAttributes(System.getProperties());
        int logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
        Properties commonProps = JacORBConfiguration.loadPropertiesFromFile(lib + separator + "lib" + separator + COMMON_PROPS);
        if (commonProps != null) {
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            loaded = true;
            if (logLevel > 2) {
                JacORBConfiguration.println("[ base configuration loaded from file " + lib + separator + "lib" + separator + COMMON_PROPS + " ]");
            }
        }
        if ((commonProps = JacORBConfiguration.loadPropertiesFromFile(home + separator + COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ base configuration loaded from file " + home + separator + COMMON_PROPS + " ]");
            }
        }
        if ((commonProps = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            loaded = true;
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((configDir = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            configDir = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (configDir.length() != 0) {
            configDir = configDir + separator + "etc";
        } else {
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 0) {
                JacORBConfiguration.printErr("[ jacorb.home unset! Will use '.' ]");
            }
            configDir = ".";
        }
        String propFileName = configDir + separator + name + fileSuffix;
        Properties orbConfig = JacORBConfiguration.loadPropertiesFromFile(propFileName);
        if (orbConfig != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ configuration " + name + " loaded from file " + propFileName + " ]");
            }
        } else {
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 0) {
                JacORBConfiguration.printErr("[ File " + propFileName + " for configuration " + name + " not found ]");
            }
        }
        if ((orbConfig = JacORBConfiguration.loadPropertiesFromClassPath(name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ configuration " + name + " loaded from classpath]");
            }
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iter = customPropFileNames.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                Properties customProps = JacORBConfiguration.loadPropertiesFromFile(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
                    if (logLevel <= 2) continue;
                    JacORBConfiguration.println("[ custom properties loaded from file " + fileName + " ]");
                    continue;
                }
                if (logLevel <= 0) continue;
                JacORBConfiguration.printErr("[ custom properties not found in " + fileName + " ]");
            }
        }
        this.setAttributes(System.getProperties());
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded && logLevel > 0) {
            JacORBConfiguration.println("[ No configuration properties found for configuration " + name + " ]");
        }
    }

    private void initApplet(String name, Properties orbProperties) throws ConfigurationException {
        List customPropFileNames;
        String propFileName;
        Properties orbConfig;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean loaded = false;
        if (orbProperties != null) {
            this.setAttributes(orbProperties);
        }
        int logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
        Properties commonProps = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS);
        if (commonProps != null) {
            loaded = true;
            this.setAttributes(commonProps);
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((orbConfig = JacORBConfiguration.loadPropertiesFromClassPath(propFileName = name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 2) {
                JacORBConfiguration.println("[ configuration " + name + " loaded from classpath " + propFileName + " ]");
            }
        } else {
            logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
            if (logLevel > 0) {
                JacORBConfiguration.printErr("[ File " + propFileName + " for configuration " + name + " not found in classpath]");
            }
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iter = customPropFileNames.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                Properties customProps = JacORBConfiguration.loadPropertiesFromClassPath(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    logLevel = this.getAttributeAsInteger(CONFIG_LOG_VERBOSITY, 0);
                    if (logLevel <= 2) continue;
                    JacORBConfiguration.println("[ custom properties loaded from classpath " + fileName + " ]");
                    continue;
                }
                if (logLevel <= 0) continue;
                JacORBConfiguration.printErr("[ custom properties " + fileName + "not found in classpath ]");
            }
        }
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            JacORBConfiguration.println("[ No configuration properties found for configuration " + name + " ]");
        }
    }

    void setAttributes(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        while (iter.hasNext()) {
            String key;
            Object value;
            Object obj = iter.next();
            if (!(obj instanceof String) || !((value = properties.get(key = (String)obj)) instanceof String) && value != null) continue;
            this.setAttribute(key, (String)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String fileName) {
        Properties properties;
        FileInputStream stream = new FileInputStream(fileName);
        try {
            Properties result = new Properties();
            result.load(stream);
            properties = result;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                JacORBConfiguration.println("could not read config file: " + fileName);
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromClassPath(String name) {
        Properties result;
        block6: {
            result = null;
            try {
                ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : JacORBConfiguration.class.getClassLoader();
                URL url = clazzLoader.getResource(name);
                if (url == null) break block6;
                result = new Properties();
                InputStream stream = url.openStream();
                try {
                    result.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                JacORBConfiguration.println("could not read config file: " + name);
                ioe.printStackTrace();
            }
        }
        return result;
    }

    private void initLogging() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMdHm");
        String logFileName = this.getAttribute("jacorb.logfile", EMPTY_STR);
        int maxLogSize = this.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0);
        if (!logFileName.equals(EMPTY_STR)) {
            if (this.orb == null) {
                String singletonLogFile = this.getAttribute("jacorb.logfile.singleton", EMPTY_STR);
                if (singletonLogFile.equals(EMPTY_STR)) {
                    logFileName = EMPTY_STR;
                } else if (logFileName.endsWith("$implname")) {
                    logFileName = logFileName.substring(0, logFileName.indexOf("$implname") - 1);
                    logFileName = logFileName + File.separatorChar + singletonLogFile + dateFormatter.format(new Date()) + ".log";
                } else {
                    File file = new File(logFileName);
                    String parent = file.getParent();
                    logFileName = parent != null ? logFileName + singletonLogFile + dateFormatter.format(new Date()) + ".log" : singletonLogFile + dateFormatter.format(new Date()) + ".log";
                }
            } else if (logFileName.endsWith("$implname")) {
                logFileName = logFileName.substring(0, logFileName.length() - 9);
                String serverId = new String(this.orb.getServerId());
                String implName = this.getAttribute("jacorb.implname", serverId);
                logFileName = logFileName + implName + ".log";
            }
        }
        String clzName = this.getAttribute("jacorb.log.loggerFactory", EMPTY_STR);
        Class loggerFactoryClz = null;
        try {
            loggerFactoryClz = !clzName.equals(EMPTY_STR) ? ObjectUtil.classForName(clzName) : ObjectUtil.classForName(loggerFactoryClzName);
            this.loggerFactory = (LoggerFactory)loggerFactoryClz.newInstance();
            this.loggerFactory.configure(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.loggerFactory == null) {
            JacORBConfiguration.printErr("Configuration Error, could not create logger!");
        }
        if (!logFileName.equals(EMPTY_STR)) {
            try {
                this.loggerFactory.setDefaultLogFile(logFileName, maxLogSize);
                this.logger = this.loggerFactory.getNamedLogger("jacorb", logFileName, maxLogSize);
            }
            catch (IOException e) {
                this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create logger with file target: " + logFileName + ", falling back to console log!");
                }
            }
        } else {
            this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getNamedLogger(String name) {
        return this.loggerFactory.getNamedLogger(name);
    }

    public String getLoggerName(Class clz) {
        String clazzName = clz.getName();
        String packageName = clazzName.substring(0, clazzName.lastIndexOf(46));
        if (packageName != null && packageName.startsWith("org.jacorb")) {
            return packageName.substring(4);
        }
        return packageName;
    }

    public List getAttributeList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String value = null;
        try {
            value = this.getAttribute(key);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().trim());
            }
        }
        return result;
    }

    public Object getAttributeAsObject(String key) throws ConfigurationException {
        String className = this.getAttribute(key, null);
        if (className != null && className.length() > 0) {
            return this.newInstance(key, className);
        }
        return null;
    }

    private Object newInstance(String key, String className) throws ConfigurationException {
        try {
            Class clazz = ObjectUtil.classForName(className);
            Object instance = clazz.newInstance();
            if (instance instanceof Configurable) {
                ((Configurable)instance).configure(this);
            }
            return instance;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build class from key >" + key + "<: " + e);
        }
    }

    public Object getAttributeAsObject(String key, String defaultValue) throws ConfigurationException {
        Object result = this.getAttributeAsObject(key);
        if (result == null) {
            return this.newInstance("default", defaultValue);
        }
        return result;
    }

    public boolean getAttributeAsBoolean(String key) throws ConfigurationException {
        String value = this.getAttribute(key);
        if (value != null && value.length() > 0) {
            return ON.equals(value = value.trim().toLowerCase()) || TRUE.equals(value);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        String value = this.getAttribute(key, EMPTY_STR);
        if (value.length() > 0) {
            return ON.equals(value = value.trim().toLowerCase()) || TRUE.equals(value);
        }
        return defaultValue;
    }

    public List getAttributeNamesWithPrefix(String prefix) {
        ArrayList<String> attributesWithPrefix = new ArrayList<String>();
        String[] allAttributes = this.getAttributeNames();
        for (int x = 0; x < allAttributes.length; ++x) {
            if (!allAttributes[x].startsWith(prefix)) continue;
            attributesWithPrefix.add(allAttributes[x]);
        }
        return Collections.unmodifiableList(attributesWithPrefix);
    }
}

