/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.web;

import com.interstarinc.xm.report.ApplicationContext;
import com.interstarinc.xm.report.DownloadManager;
import com.interstarinc.xm.report.ReportsConfig;
import com.interstarinc.xm.report.ResponseManager;
import com.interstarinc.xm.report.dao.NotFoundException;
import com.interstarinc.xm.report.dao.ReportEditor;
import com.interstarinc.xm.report.dao.ReportManager;
import com.interstarinc.xm.report.model.Administrator;
import com.interstarinc.xm.report.model.Report;
import com.interstarinc.xm.report.model.Site;
import com.interstarinc.xm.report.security.SessionNotificationListener;
import com.interstarinc.xm.report.security.SharedSessionStorage;
import com.interstarinc.xm.report.web.ReportToken;
import com.sun.org.apache.xml.internal.utils.LocaleUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 2806130154823421028L;
    private static Logger logger = Logger.getLogger(ReportServlet.class.getName());
    private static SessionNotificationListener listener;
    public static String SERVLET_NAME;

    public void init() {
        logger.log(Level.INFO, "Initializing Report Servlet...");
        String workingFolder = this.getServletContext().getRealPath(this.getServletContext().getInitParameter("BIRT_VIEWER_WORKING_FOLDER"));
        logger.log(Level.INFO, "BIRT Resource folder is : " + workingFolder);
        DownloadManager.init(workingFolder);
        listener = new SessionNotificationListener(){

            public void handleAdd(HttpSession session) {
            }

            public void handleRemove(String sessionId) {
                logger.log(Level.INFO, "Cleaning up temp folder {0}...", sessionId);
                DownloadManager.cleanUp(sessionId);
            }
        };
        SharedSessionStorage.registerNotificationListener(listener);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ReportToken token = (ReportToken)request.getSession().getAttribute("REPORT_TOKEN");
            ReportManager reportManager = ApplicationContext.getContext().getReportManager();
            Report report = reportManager.findReport(token.getReportName());
            if (report == null) {
                ResponseManager.returnNotFound(response, token.getReportName());
                return;
            }
            File reportFile = DownloadManager.download(report, token);
            Administrator admin = (Administrator)SharedSessionStorage.get(token.getSessionId()).getAttribute(Administrator.class.getName());
            this.injectParametersToReport(admin, reportFile, this.getLocale(request), request.getParameter("__site"));
            ResponseManager.redirectToBirtServlet(request, response, token);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An error occurred during processing the request :", e);
            ResponseManager.returnInternalError(response, e);
        }
    }

    public void destroy() {
        logger.log(Level.INFO, "Shutting down Report Servlet...");
        ApplicationContext.shutdown();
        DownloadManager.cleanUp();
        if (listener != null) {
            SharedSessionStorage.deregisterNotificationListener(listener);
        }
    }

    private void injectParametersToReport(Administrator admin, File reportFile, Locale locale, String siteGuid) throws NotFoundException, Exception {
        ReportEditor editor = new ReportEditor(new FileInputStream(reportFile), true);
        ApplicationContext context = ApplicationContext.getContext();
        editor.updateDataSource("FaxArchive", context.getDataSourceManager().getBest());
        int rowFetchLimit = ReportsConfig.getInt("reportviewer.rowFetchLimit");
        if (rowFetchLimit > 0) {
            editor.setRowFetchLimit(rowFetchLimit);
        }
        if (admin.isSiteAdmin()) {
            editor.updateSiteParameter(admin.getSiteGuid());
        } else if (siteGuid != null) {
            editor.updateSiteParameter(siteGuid);
        } else {
            Collator collator = Collator.getInstance(locale);
            collator.setStrength(1);
            TreeMap<CollationKey, Site> sortedSites = new TreeMap<CollationKey, Site>();
            List<Site> sites = context.getSiteManager().findSites();
            for (Site site : sites) {
                sortedSites.put(collator.getCollationKey(site.getName()), site);
            }
            ArrayList<Site> sortedList = new ArrayList<Site>();
            sortedList.addAll(sortedSites.values());
            editor.updateSiteParameter(sortedList);
        }
        editor.saveAs(new FileOutputStream(reportFile), true);
    }

    private Locale getLocale(HttpServletRequest request) {
        Locale locale = Locale.US;
        String lang = request.getParameter("__locale");
        if (lang != null) {
            locale = LocaleUtility.langToLocale(lang.replace("_", "-"));
        }
        return locale;
    }

    static {
        SERVLET_NAME = "/generate";
    }
}

