/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.security;

import com.interstarinc.xm.report.DownloadManager;
import com.interstarinc.xm.report.ResponseManager;
import com.interstarinc.xm.report.model.Administrator;
import com.interstarinc.xm.report.security.ReportServletRequestWrapper;
import com.interstarinc.xm.report.security.SharedSessionStorage;
import com.interstarinc.xm.report.web.ReportServlet;
import com.interstarinc.xm.report.web.ReportToken;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SharedSessionStorageFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SharedSessionStorageFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log(Level.INFO, "Search the sessionId of request...");
        ReportToken token = null;
        String reportParam = request.getParameter("__report");
        token = reportParam != null ? new ReportToken(reportParam) : (ReportToken)((HttpServletRequest)request).getSession().getAttribute("REPORT_TOKEN");
        logger.log(Level.INFO, "SessionId of request is: " + token.getSessionId());
        if (token.getSessionId() == null || !SharedSessionStorage.contains(token.getSessionId())) {
            logger.log(Level.INFO, "SessionId is not found in the shared storage: " + token.getSessionId());
            ResponseManager.redirectSessionTimeout((HttpServletRequest)request, (HttpServletResponse)response, token);
            return;
        }
        ((HttpServletRequest)request).getSession().setAttribute("REPORT_TOKEN", (Object)token);
        if (!DownloadManager.exists(token) && !((HttpServletRequest)request).getServletPath().startsWith(ReportServlet.SERVLET_NAME)) {
            ResponseManager.redirectToReportServlet((HttpServletRequest)request, (HttpServletResponse)response, token);
        }
        HttpSession session = SharedSessionStorage.get(token.getSessionId());
        Administrator admin = (Administrator)session.getAttribute(Administrator.class.getName());
        chain.doFilter((ServletRequest)new ReportServletRequestWrapper((HttpServletRequest)request, admin), response);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

