/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.security;

import com.interstarinc.xm.report.security.SessionNotificationListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public class SharedSessionStorage {
    private static Logger logger = Logger.getLogger(SharedSessionStorage.class.getName());
    public static final String KEY_REPORT_TOKEN = "REPORT_TOKEN";
    private static Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();
    private static CopyOnWriteArrayList<SessionNotificationListener> listeners = new CopyOnWriteArrayList();

    public static synchronized void add(final HttpSession session) {
        logger.log(Level.INFO, "Add session to the shared storage: " + session.getId());
        sessions.put(session.getId(), session);
        Thread notifier = new Thread(){

            public void run() {
                for (SessionNotificationListener listener : listeners) {
                    try {
                        listener.handleAdd(session);
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "An error occurred in calling a session notifier: " + e.getMessage());
                    }
                }
            }
        };
        notifier.start();
    }

    public static synchronized void remove(HttpSession session) {
        final String sessionId = session.getId();
        logger.log(Level.INFO, "Remove session from the shared storage: " + sessionId);
        sessions.remove(sessionId);
        Thread notifier = new Thread(){

            public void run() {
                for (SessionNotificationListener listener : listeners) {
                    try {
                        listener.handleRemove(sessionId);
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "An error occurred in calling a session notifier: " + e.getMessage());
                    }
                }
            }
        };
        notifier.start();
    }

    public static synchronized HttpSession get(String sessionId) {
        return sessions.get(sessionId);
    }

    public static synchronized boolean contains(String sessionId) {
        return sessions.containsKey(sessionId);
    }

    public static void registerNotificationListener(SessionNotificationListener listener) {
        listeners.add(listener);
    }

    public static void deregisterNotificationListener(SessionNotificationListener listener) {
        listeners.remove(listener);
    }
}

