/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.security;

import com.interstarinc.xm.report.ApplicationContext;
import com.interstarinc.xm.report.ResponseManager;
import com.interstarinc.xm.report.model.Administrator;
import com.interstarinc.xm.report.model.Report;
import com.interstarinc.xm.report.security.SharedSessionStorage;
import com.interstarinc.xm.report.web.ReportToken;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AccessControllerFilter
implements Filter {
    private static Logger logger = Logger.getLogger(AccessControllerFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.log(Level.INFO, "Checking the access rights of administrator to the report...");
        ReportToken token = (ReportToken)((HttpServletRequest)request).getSession().getAttribute("REPORT_TOKEN");
        HttpSession session = SharedSessionStorage.get(token.getSessionId());
        Administrator admin = (Administrator)session.getAttribute(Administrator.class.getName());
        logger.log(Level.INFO, "Administrator is: " + admin.getUsername());
        if (!this.hasAccessTo(admin, "CompanyMonitoring")) {
            ResponseManager.returnNotAccess((HttpServletResponse)response, "Reports");
            return;
        }
        try {
            Report report = ApplicationContext.getContext().getReportManager().findReport(token.getReportName());
            if (report == null) {
                ResponseManager.returnNotFound((HttpServletResponse)response, token.getReportName());
                return;
            }
            if (!this.hasAdminAccessRight(admin, report)) {
                ResponseManager.returnNotAccess((HttpServletResponse)response, token.getReportName());
                return;
            }
        }
        catch (Exception e) {
            ResponseManager.returnInternalError((HttpServletResponse)response, e);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private boolean hasAdminAccessRight(Administrator admin, Report report) {
        if (!admin.isSiteAdmin() || report.isAllSites()) {
            return true;
        }
        if (admin.getSiteGuid() != null) {
            String sites = report.getSites();
            return sites.contains("\"" + admin.getSiteGuid() + "\"");
        }
        return false;
    }

    private boolean hasAccessTo(Administrator admin, String node) {
        return !admin.isSiteAdmin() || admin.getAccessRights().indexOf("\"" + node + "\"") != -1;
    }
}

