/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.dao;

import Xm.Config;
import Xm.ConfigHelper;
import Xm.JavaUtils.ConfigListLink;
import Xm.JavaUtils.CorbaObjectResolver;
import Xm.JavaUtils.Database.JavaCorbaConversion.ListConverter;
import Xm.JavaUtils.TraderCorbaObjectResolver;
import Xm.JavaUtils.TraderHelper;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.List;
import Xm.MediaStore.FileAccess;
import Xm.MediaStore.FileAccessHelper;
import Xm.MediaStore.FileId;
import Xm.MediaStore.InvalidFileId;
import Xm.MediaStore.ReadFileFailure;
import com.interstarinc.xm.report.model.Report;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportManager {
    public static final String CONFIG_CONSTRAINT = "Type == 'Web Reports'";
    public static final int BUFFER = 0x100000;
    private ConfigListLink<Report> reports;
    private final ListConverter<Report> converter = new ListConverter(Report.class);
    private final CorbaObjectResolver<FileAccess> mediaStoreResolver;

    public ReportManager(ORB orb, POA poa) {
        try {
            this.converter.addMapping("Name", "id");
            this.converter.addMapping("ReportName", "name");
            this.converter.addMapping("Visible", "visible");
            this.converter.addMapping("AllSites", "allSites");
            this.converter.addMapping("Sites", "sites");
            this.converter.addMapping("Store ID", "subStore");
            this.converter.addMapping("File ID", "url");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e.getMessage());
        }
        TraderHelper traderHelper = new TraderHelper(orb);
        CorbaObjectResolver<List> resolver = this.getReportListResolver(traderHelper);
        this.reports = new ConfigListLink(this.converter, resolver, poa, null);
        this.mediaStoreResolver = this.getMediaStoreResolver(traderHelper);
    }

    public java.util.List<Report> findReports() throws SystemException, ConfigListLink.ConfigListLinkException, CorbaObjectResolver.ResolveException {
        return this.reports.getAllRecords();
    }

    public Report findReport(String id) throws SystemException, ConfigListLink.ConfigListLinkException, CorbaObjectResolver.ResolveException {
        java.util.List<Report> reports = this.findReports();
        for (Report report : reports) {
            if (!report.getId().equals(id)) continue;
            return report;
        }
        return null;
    }

    public void download(Report report, File file) throws CorbaObjectResolver.ResolveException, ReadFileFailure, InvalidFileId, IOException {
        byte[] buffer;
        FileAccess fileAccess = (FileAccess)this.mediaStoreResolver.resolve();
        FileId fileId = new FileId();
        fileId.SubStoreId = report.getSubStore();
        fileId.EntryId = report.getUrl();
        StringHolder typeHolder = new StringHolder();
        FileOutputStream output = new FileOutputStream(file);
        int offset = 0;
        while ((buffer = fileAccess.ReadFile(fileId, 0x100000, offset, typeHolder)).length != 0) {
            output.write(buffer, 0, buffer.length);
            offset += buffer.length;
        }
        output.flush();
        output.close();
    }

    public void shutdown() {
        this.reports.unregisterToConfigUpdate();
    }

    private CorbaObjectResolver<List> getReportListResolver(final TraderHelper traderHelper) {
        return new CorbaObjectResolver<List>(){
            private CorbaObjectResolver<Config> configResolver;
            {
                this.configResolver = new TraderCorbaObjectResolver(traderHelper, "Config", new TraderHelperOptions(ReportManager.CONFIG_CONSTRAINT), ConfigHelper.class);
            }

            public List resolve() throws CorbaObjectResolver.ResolveException {
                return ((Config)this.configResolver.resolve()).GetPrimaryList();
            }
        };
    }

    private CorbaObjectResolver<FileAccess> getMediaStoreResolver(TraderHelper traderHelper) {
        return new TraderCorbaObjectResolver(traderHelper, "ConfigManagerMediaStoreFileAccessGroup", new TraderHelperOptions(), FileAccessHelper.class);
    }
}

