/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.dao;

import com.interstarinc.xm.report.dao.DataSource;
import com.interstarinc.xm.report.dao.InvalidFormat;
import com.interstarinc.xm.report.model.Site;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportEditor {
    private Document document;
    private int counter = 0;
    private static final String ODA_DRIVERCLASS = "odaDriverClass";
    private static final String ODA_URL = "odaURL";
    private static final String ODA_USER = "odaUser";
    private static final String ODA_PASSWORD = "odaPassword";
    public static final String FAX_ARCHIVE_DSN = "FaxArchive";
    public static final String ALL_SITES_VALUE = "__AllSites__";

    public ReportEditor(String inputFilename) throws IllegalStateException, InvalidFormat, IOException {
        this(new FileInputStream(inputFilename), true);
    }

    public ReportEditor(InputStream input) throws IllegalStateException, InvalidFormat, IOException {
        this(input, false);
    }

    public ReportEditor(InputStream input, boolean close) throws IllegalStateException, InvalidFormat, IOException {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SAXException ex) {
            throw new InvalidFormat(ex);
        }
        finally {
            if (close) {
                input.close();
            }
        }
    }

    public void saveAs(String outputFilename) throws IOException {
        this.saveAs(new FileOutputStream(outputFilename), true);
    }

    public void saveAs(OutputStream output) throws IOException {
        this.saveAs(output, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(OutputStream output, boolean close) throws IOException {
        try {
            OutputFormat format = new OutputFormat(this.document);
            format.setIndenting(true);
            format.setLineSeparator(System.getProperty("line.separator"));
            XMLSerializer serializer = new XMLSerializer(output, format);
            serializer.serialize(this.document);
        }
        finally {
            if (close) {
                output.close();
            }
        }
    }

    public boolean updateSiteParameter(String siteGuid) {
        Element parameters = this.getParametersElement();
        if (parameters == null) {
            return false;
        }
        Element siteParameter = ReportEditor.getElement(parameters.getElementsByTagName("scalar-parameter"), "Site");
        if (siteParameter == null) {
            return false;
        }
        if (this.isCascadedParameterGroupMember(siteParameter)) {
            siteParameter.getParentNode().removeChild(siteParameter);
            siteParameter = this.document.createElement("scalar-parameter");
            siteParameter.setAttribute("name", "Site");
            siteParameter.setAttribute("extends", "fax.Site");
            parameters.appendChild(siteParameter);
        }
        ReportEditor.removeAllChildNodes(siteParameter);
        siteParameter.appendChild(this.createProperty("hidden", "true"));
        siteParameter.appendChild(this.createProperty("valueType", "static"));
        siteParameter.appendChild(this.createProperty("dataType", "string"));
        siteParameter.appendChild(this.createProperty("paramType", "simple"));
        siteParameter.appendChild(this.createProperty("isRequired", "true"));
        siteParameter.appendChild(this.createProperty("controlType", "text-box"));
        siteParameter.appendChild(this.createProperty("distinct", "true"));
        siteParameter.appendChild(this.createDefaultValueProperty(siteGuid));
        siteParameter.appendChild(this.createTextProperty("promptText", "Site"));
        siteParameter.appendChild(this.createParameterFormatValue("Unformatted"));
        return true;
    }

    private boolean isCascadedParameterGroupMember(Element siteParameter) {
        return siteParameter.getParentNode().getParentNode().getNodeName().equals("cascading-parameter-group");
    }

    private Element getParametersElement() {
        NodeList list = this.document.getElementsByTagName("parameters");
        if (list.getLength() == 0) {
            return null;
        }
        assert (list.item(0).getNodeType() == 1);
        return (Element)list.item(0);
    }

    public boolean updateSiteParameter(List<Site> sites) {
        Element siteList = ReportEditor.getElement(this.document.getElementsByTagName("scalar-parameter"), "Site");
        if (siteList == null) {
            return false;
        }
        ReportEditor.removeAllChildNodes(siteList);
        siteList.appendChild(this.createProperty("valueType", "static"));
        siteList.appendChild(this.createProperty("dataType", "string"));
        siteList.appendChild(this.createProperty("paramType", "simple"));
        siteList.appendChild(this.createProperty("isRequired", "true"));
        siteList.appendChild(this.createProperty("controlType", "list-box"));
        siteList.appendChild(this.createProperty("mustMatch", "true"));
        siteList.appendChild(this.createProperty("fixedOrder", "true"));
        siteList.appendChild(this.createProperty("distinct", "true"));
        siteList.appendChild(this.createTextProperty("promptText", "Site"));
        siteList.appendChild(this.createParameterFormatValue("Unformatted"));
        Node selectionList = siteList.appendChild(this.createListProperty("selectionList"));
        selectionList.appendChild(this.createSelectionChoiceWithKey("AllSites", ALL_SITES_VALUE));
        for (Site site : sites) {
            selectionList.appendChild(this.createSelectionChoice(site.getName(), site.getGuid()));
        }
        return true;
    }

    private static void removeAllChildNodes(Element elem) {
        NodeList descendants = elem.getElementsByTagName("*");
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < descendants.getLength(); ++i) {
            Node node = descendants.item(i);
            if (!elem.isSameNode(node.getParentNode())) continue;
            children.add(node);
        }
        for (Node child : children) {
            elem.removeChild(child);
        }
    }

    public boolean updateDataSource(String dataSourceName, DataSource dataSource) {
        Element odaDataSource = ReportEditor.getElement(this.document.getElementsByTagName("oda-data-source"), dataSourceName);
        if (odaDataSource == null) {
            return false;
        }
        HashMap<String, Element> newProperties = new HashMap<String, Element>();
        newProperties.put(ODA_DRIVERCLASS, this.createProperty(ODA_DRIVERCLASS, "com.mysql.jdbc.Driver"));
        newProperties.put(ODA_URL, this.createProperty(ODA_URL, ReportEditor.getUrl(dataSource)));
        newProperties.put(ODA_USER, this.createProperty(ODA_USER, dataSource.user));
        newProperties.put(ODA_PASSWORD, this.createBase64Property(ODA_PASSWORD, dataSource.password));
        NodeList properties = odaDataSource.getElementsByTagName("*");
        for (String key : newProperties.keySet()) {
            Element property = ReportEditor.getElement(properties, key);
            if (property != null && odaDataSource.isSameNode(property.getParentNode())) {
                odaDataSource.replaceChild((Node)newProperties.get(key), property);
                continue;
            }
            odaDataSource.appendChild((Node)newProperties.get(key));
        }
        return true;
    }

    public boolean setRowFetchLimit(int rowFetchLimit) {
        if (rowFetchLimit <= 0) {
            throw new IllegalArgumentException("Illegal rowFetchLimit: " + rowFetchLimit);
        }
        NodeList odaDataSets = this.document.getElementsByTagName("oda-data-set");
        if (odaDataSets == null) {
            return false;
        }
        block0: for (int index = 0; index < odaDataSets.getLength(); ++index) {
            Node node = odaDataSets.item(index);
            if (node.getNodeType() != 1) continue;
            Element currOdaDataSet = (Element)node;
            String dataSetName = currOdaDataSet.getAttribute("name");
            currOdaDataSet.appendChild(this.createProperty("rowFetchLimit", Integer.toString(rowFetchLimit)));
            List<Node> nodes = this.getNodesByTag(this.document.getDocumentElement(), "property", "dataSet", dataSetName);
            for (Node n : nodes) {
                if (n.getNodeName() == "cascading-parameter-group" || n.getNodeName() == "scalar-parameter") continue;
                n.getParentNode().insertBefore(this.createWarningMessage(dataSetName, rowFetchLimit), n);
                continue block0;
            }
        }
        return true;
    }

    private static String getUrl(DataSource dataSource) {
        StringBuffer url = new StringBuffer();
        url.append("jdbc:mysql://").append(dataSource.host);
        if (dataSource.port > 0) {
            url.append(":").append(dataSource.port);
        }
        url.append("/").append(dataSource.databaseName);
        return url.toString();
    }

    private static Element getElement(NodeList nodes, String name) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node attribute;
            NamedNodeMap attributes;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (attributes = node.getAttributes()) == null || (attribute = attributes.getNamedItem("name")) == null || attribute.getNodeType() != 2 || !attribute.getNodeValue().equalsIgnoreCase(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private List<Node> getNodesByTag(Element parent, String tagName, String name, String value) {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes != null) {
            for (int index = 0; index < nodes.getLength(); ++index) {
                Element currElem;
                if (nodes.item(index).getNodeType() != 1 || !name.equals((currElem = (Element)nodes.item(index)).getAttribute("name")) || !value.equals(currElem.getFirstChild().getTextContent())) continue;
                ret.add(currElem.getParentNode());
            }
        }
        return ret;
    }

    private Element createWarningMessage(String dataSetName, int rowFetchLimit) {
        Element table = this.document.createElement("table");
        table.setAttribute("name", "WarningMessage" + dataSetName + this.counter);
        ++this.counter;
        table.setAttribute("extends", "fax.WarningMessage");
        table.appendChild(this.createProperty("dataSet", dataSetName));
        Node columnList = table.appendChild(this.createListProperty("boundDataColumns"));
        columnList.appendChild(this.createDataTypeStructure("MaxRowsFetched", "boolean", "Total.count() == " + rowFetchLimit));
        return table;
    }

    private Element createDataTypeStructure(String name, String dataType, String text) {
        Element elem = this.document.createElement("structure");
        elem.appendChild(this.createProperty("name", name));
        elem.appendChild(this.createProperty("dataType", dataType));
        Element expr = (Element)elem.appendChild(this.document.createElement("expression"));
        expr.setAttribute("name", "expression");
        expr.appendChild(this.document.createTextNode(text));
        return elem;
    }

    private Element createProperty(String name, String text) {
        Element elem = this.document.createElement("property");
        elem.setAttribute("name", name);
        elem.appendChild(this.document.createTextNode(text));
        return elem;
    }

    private Element createBase64Property(String name, String text) {
        Element elem = this.document.createElement("encrypted-property");
        elem.setAttribute("name", name);
        elem.setAttribute("encryptionID", "base64");
        BASE64Encoder encoder = new BASE64Encoder();
        elem.appendChild(this.document.createTextNode(encoder.encode(text.getBytes())));
        return elem;
    }

    private Element createTextProperty(String name, String text) {
        Element elem = this.document.createElement("text-property");
        elem.setAttribute("name", name);
        elem.appendChild(this.document.createTextNode(text));
        return elem;
    }

    private Element createListProperty(String name) {
        Element elem = this.document.createElement("list-property");
        elem.setAttribute("name", name);
        return elem;
    }

    private Element createParameterFormatValue(String category) {
        Element elem = this.document.createElement("structure");
        elem.setAttribute("name", "format");
        elem.appendChild(this.createProperty("category", category));
        return elem;
    }

    private Element createSelectionChoice(String label, String value) {
        Element elem = this.document.createElement("structure");
        elem.appendChild(this.createProperty("label", label));
        elem.appendChild(this.createProperty("value", value));
        return elem;
    }

    private Element createSelectionChoiceWithKey(String key, String value) {
        Element elem = this.document.createElement("structure");
        elem.appendChild(this.createProperty("labelID", key));
        elem.appendChild(this.createProperty("value", value));
        return elem;
    }

    private Element createConstantValue(String value) {
        Element elem = this.document.createElement("value");
        elem.setAttribute("type", "constant");
        elem.appendChild(this.document.createTextNode(value));
        return elem;
    }

    private Element createDefaultValueProperty(String value) {
        Element elem = this.document.createElement("simple-property-list");
        elem.setAttribute("name", "defaultValue");
        elem.appendChild(this.createConstantValue(value));
        return elem;
    }
}

