/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report.dao;

import Xm.Config;
import Xm.ConfigHelper;
import Xm.FaultTolerance.ComponentInstanceInfo;
import Xm.FaultTolerance.ComponentInstanceMembership;
import Xm.FaultTolerance.ComponentInstanceStatus;
import Xm.FaultTolerance.System;
import Xm.FaultTolerance.SystemHelper;
import Xm.FaultTolerance.SystemPackage.UnknownType;
import Xm.JavaUtils.CorbaObjectResolver;
import Xm.JavaUtils.HostList;
import Xm.JavaUtils.Port;
import Xm.JavaUtils.TraderCorbaObjectResolver;
import Xm.JavaUtils.TraderHelper;
import Xm.JavaUtils.TraderHelperOptions;
import Xm.List;
import Xm.Records;
import Xm.TypedValue;
import com.interstarinc.xm.report.dao.DataSource;
import com.interstarinc.xm.report.dao.FaxArchiveConfigResolverFactory;
import com.interstarinc.xm.report.dao.FaxArchiveConfigResolverFactoryI;
import com.interstarinc.xm.report.dao.NotFoundException;
import java.util.ArrayList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceManager {
    private ORB orb;
    private FaxArchiveConfigResolverFactoryI faxArchiveConfigResolverFactory;
    private CorbaObjectResolver<List> hostListResolver;
    private HostList.HostListIterator hostIterator = new HostList().createIterator();
    private volatile System system;
    private DataSource bestDataSource;
    private long expiration;
    private static final long BEST_TIMEOUT = 15000L;

    public DataSourceManager(ORB orb) {
        this.orb = orb;
        TraderHelper traderHelper = new TraderHelper(orb);
        this.faxArchiveConfigResolverFactory = new FaxArchiveConfigResolverFactory(traderHelper);
        this.hostListResolver = DataSourceManager.getHostListResolver(traderHelper);
    }

    private static CorbaObjectResolver<List> getHostListResolver(final TraderHelper traderHelper) {
        String constraint = "Type == 'Host List'";
        return new CorbaObjectResolver<List>(){
            private CorbaObjectResolver<Config> configResolver;
            {
                this.configResolver = new TraderCorbaObjectResolver(traderHelper, "Config", new TraderHelperOptions("Type == 'Host List'"), ConfigHelper.class);
            }

            public List resolve() throws CorbaObjectResolver.ResolveException {
                return ((Config)this.configResolver.resolve()).GetListInterface("Host List");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getBest() throws NotFoundException {
        DataSourceManager dataSourceManager = this;
        synchronized (dataSourceManager) {
            if (this.bestDataSource != null && this.expiration > java.lang.System.currentTimeMillis()) {
                return this.bestDataSource;
            }
        }
        return this.refreshBest();
    }

    public synchronized void reportFailure(DataSource failed) {
        if (this.bestDataSource != null && this.bestDataSource.equals(failed)) {
            this.bestDataSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource refreshBest() throws NotFoundException {
        String componentType = "Archive";
        try {
            ComponentInstanceInfo[] instances = null;
            try {
                if (this.system != null) {
                    instances = this.system.GetAllInstances("Archive");
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (instances == null) {
                this.system = DataSourceManager.resolveSystem(this.orb, this.hostIterator);
                instances = this.system.GetAllInstances("Archive");
            }
            DataSource newBestDataSource = DataSourceManager.getBest(instances, this.faxArchiveConfigResolverFactory, this.hostListResolver);
            DataSourceManager dataSourceManager = this;
            synchronized (dataSourceManager) {
                this.bestDataSource = newBestDataSource;
                this.expiration = java.lang.System.currentTimeMillis() + 15000L;
                return this.bestDataSource;
            }
        }
        catch (UnknownType ex) {
            throw new NotFoundException(ex.toString());
        }
        catch (SystemException ex) {
            throw new NotFoundException(ex.toString());
        }
    }

    private static String getSystemCorbaloc(String host) {
        StringBuffer corbaloc = new StringBuffer();
        corbaloc.append("corbaloc:iiop:");
        corbaloc.append(host);
        corbaloc.append(":");
        corbaloc.append(Port.FaultTolerancePort());
        corbaloc.append("/");
        corbaloc.append("FtSystem45");
        return corbaloc.toString();
    }

    private static System resolveSystem(ORB orb, HostList.HostListIterator hostIterator) throws NotFoundException {
        String lastMessage = null;
        int max = new HostList().GetHostNames().length;
        for (int i = 0; i < max; ++i) {
            try {
                System system = SystemHelper.narrow((Object)orb.string_to_object(DataSourceManager.getSystemCorbaloc(hostIterator.current())));
                if (null != system) {
                    return system;
                }
            }
            catch (SystemException ex) {
                lastMessage = ex.toString();
            }
            hostIterator.nextOrRefreshAndNull();
        }
        throw new NotFoundException("Failed to resolve system: " + (lastMessage != null ? lastMessage : "No system found"));
    }

    public static DataSource getBest(ComponentInstanceInfo[] instances, FaxArchiveConfigResolverFactoryI faxArchiveConfigResolverFactory, CorbaObjectResolver<List> hostListResolver) throws NotFoundException {
        ArrayList<ComponentInstanceInfo> choices = new ArrayList<ComponentInstanceInfo>();
        if (instances.length == 1) {
            choices.add(instances[0]);
        } else {
            for (ComponentInstanceInfo instance : instances) {
                if (instance.Membership == ComponentInstanceMembership.MEMBER_PRIMARY) {
                    choices.add(instance);
                    continue;
                }
                if (instance.Membership != ComponentInstanceMembership.MEMBER_BACKUP || instance.Status != ComponentInstanceStatus.STATUS_ACTIVE) continue;
                choices.add(0, instance);
            }
        }
        for (ComponentInstanceInfo instance : choices) {
            for (NameComponent component : instance.ComponentId) {
                if (!component.kind.equals("Host")) continue;
                return DataSourceManager.getDataSource(component.id, faxArchiveConfigResolverFactory, hostListResolver);
            }
        }
        throw new NotFoundException("Failed to determine best data source: No data source found");
    }

    private static DataSource getDataSource(String hostGuid, FaxArchiveConfigResolverFactoryI faxArchiveConfigResolverFactory, CorbaObjectResolver<List> hostListResolver) throws NotFoundException {
        String[] props = new String[]{"DataBase,Host", "DataBase,Port", "DataBase,Name", "DataBase,ReportsUser", "DataBase,ReportsPassword"};
        try {
            TypedValue[] values = ((Config)faxArchiveConfigResolverFactory.create(hostGuid).resolve()).GetTypedValues(props);
            String host = values[0].wstring_value().trim();
            if (host.length() == 0 || host.equals("127.0.0.1") || host.equalsIgnoreCase("localhost")) {
                host = DataSourceManager.getHost(hostGuid, hostListResolver);
            }
            return new DataSource(host, values[1].long_value(), values[2].wstring_value(), values[3].wstring_value(), values[4].wstring_value());
        }
        catch (CorbaObjectResolver.ResolveException ex) {
            throw new NotFoundException("Failed to retrieve config: " + ex.toString());
        }
        catch (UserException ex) {
            throw new NotFoundException("Failed to retrieve config: " + ex.toString());
        }
        catch (SystemException ex) {
            throw new NotFoundException("Failed to retrieve config: " + ex.toString());
        }
    }

    private static String getHost(String hostGuid, CorbaObjectResolver<List> hostListResolver) throws NotFoundException {
        String[] properties = new String[]{"Guid", "DnsName"};
        try {
            Records records = ((List)hostListResolver.resolve()).GetAllRecords(properties);
            for (int i = 0; i < records.Ids.length; ++i) {
                if (!hostGuid.equalsIgnoreCase(records.Columns[0].wstring_column()[i])) continue;
                return records.Columns[1].wstring_column()[i];
            }
            throw new NotFoundException("Host not found: " + hostGuid);
        }
        catch (CorbaObjectResolver.ResolveException ex) {
            throw new NotFoundException("Failed to retrieve host list: " + ex.toString());
        }
        catch (UserException ex) {
            throw new NotFoundException("Failed to retrieve host list: " + ex.toString());
        }
        catch (SystemException ex) {
            throw new NotFoundException("Failed to retrieve host list: " + ex.toString());
        }
    }
}

