/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report;

import com.interstarinc.xm.report.ReportsConfig;
import com.interstarinc.xm.report.web.ReportToken;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseManager {
    private static Logger logger = Logger.getLogger(ResponseManager.class.getName());
    private static final String BIRT_VIEWER_SERVLET_PATH = "/frameset?__report=";

    public static void redirectToReportServlet(HttpServletRequest request, HttpServletResponse response, ReportToken token) throws IOException, ServletException {
        if (token.getReportName() == null) {
            response.sendError(403, "Session is expired or invalid!");
        } else {
            String url = "generate?" + request.getQueryString();
            url = response.encodeRedirectURL(url);
            response.sendRedirect(url);
        }
    }

    public static void redirectSessionTimeout(HttpServletRequest request, HttpServletResponse response, ReportToken token) throws IOException, ServletException {
        if (token.getReportName() == null) {
            response.sendError(403, "Session is expired or invalid!");
        } else if (request.getParameter("attempt") == null) {
            String url = ReportsConfig.getString("faxadmin.context") + "/login.action?referer=" + URLEncoder.encode(request.getRequestURL() + "?" + request.getQueryString() + "&attempt=0", "UTF-8");
            response.sendRedirect(response.encodeRedirectURL(url));
        } else {
            response.sendError(403, "Session is expired or invalid!");
        }
    }

    public static void redirectToBirtServlet(HttpServletRequest request, HttpServletResponse response, ReportToken token) throws IOException {
        String url = request.getContextPath() + BIRT_VIEWER_SERVLET_PATH + token.toString();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals("__report") || name.equals("attempt")) continue;
            url = url + "&" + name + "=" + request.getParameter(name);
        }
        logger.log(Level.INFO, "Redirect the request to: " + url);
        response.sendRedirect(url);
    }

    public static void returnInternalError(HttpServletResponse response, Exception e) throws IOException {
        response.sendError(500, "An internal error occurred: " + e.getMessage());
    }

    public static void returnNotAccess(HttpServletResponse response, String message) throws IOException {
        response.sendError(403, message);
    }

    public static void returnNotFound(HttpServletResponse response, String message) throws IOException {
        response.sendError(404, message);
    }
}

