/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportsConfig {
    protected static Logger logger = Logger.getLogger(ReportsConfig.class.getName());
    protected static final String RESOURCE = "/faxreports.properties";
    public static final String KEY_FAXADMIN_CONTEXT = "faxadmin.context";
    protected static Properties properties = new Properties();

    public static String getString(String key) {
        return properties.getProperty(key);
    }

    public static int getInt(String key) {
        try {
            return Integer.parseInt(properties.getProperty(key));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Property {0} could not be found in config", key);
            return 0;
        }
    }

    public static boolean getBoolean(String key) {
        try {
            return Boolean.parseBoolean(properties.getProperty(key));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Property {0} could not be found in config", key);
            return false;
        }
    }

    static {
        try {
            properties.load(ReportsConfig.class.getResourceAsStream(RESOURCE));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "An error occurred in loading the faxreports config: /faxreports.properties", e);
        }
    }
}

