/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report;

import com.interstarinc.xm.report.ApplicationContext;
import com.interstarinc.xm.report.dao.ReportManager;
import com.interstarinc.xm.report.model.Report;
import com.interstarinc.xm.report.web.ReportToken;
import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadManager {
    private static Logger logger = Logger.getLogger(DownloadManager.class.getName());
    private static String BIRT_WORKING_FOLDER;

    public static void init(String workingFolder) {
        BIRT_WORKING_FOLDER = workingFolder;
        File path = new File(BIRT_WORKING_FOLDER);
        if (!path.exists()) {
            path.mkdir();
        } else {
            DownloadManager.cleanUp();
        }
    }

    public static boolean exists(ReportToken token) {
        File tempSessionFolder = DownloadManager.getSessionTempFolder(token.getSessionId());
        File reportFile = new File(tempSessionFolder, token.getReportName());
        return reportFile.exists();
    }

    public static File download(Report report, ReportToken token) throws Exception {
        File tempSessionFolder = DownloadManager.getSessionTempFolder(token.getSessionId());
        File reportFile = new File(tempSessionFolder, token.getReportName());
        ReportManager reportManager = ApplicationContext.getContext().getReportManager();
        reportManager.download(report, reportFile);
        return reportFile;
    }

    public static File getSessionTempFolder(String sessionId) {
        File tempSessionFolder = new File(BIRT_WORKING_FOLDER, sessionId);
        if (!tempSessionFolder.exists()) {
            tempSessionFolder.mkdir();
        }
        return tempSessionFolder;
    }

    public static void cleanUp(String sessionId) {
        File sessionTempFolder = new File(BIRT_WORKING_FOLDER, sessionId);
        DownloadManager.removeFolder(sessionTempFolder);
    }

    public static void cleanUp() {
        File[] tempFolders;
        logger.log(Level.INFO, "Cleaning up working folder: {0}...", BIRT_WORKING_FOLDER);
        for (File tempFolder : tempFolders = new File(BIRT_WORKING_FOLDER).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            DownloadManager.removeFolder(tempFolder);
        }
    }

    private static void removeFolder(File folder) {
        File[] tempFiles;
        for (File tempFile : tempFiles = folder.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        })) {
            tempFile.delete();
        }
        folder.delete();
    }
}

