/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xm.report;

import Xm.JavaUtils.ServiceLocator;
import Xm.JavaUtils.ServiceUnavailableX;
import com.interstarinc.xm.report.dao.DataSourceManager;
import com.interstarinc.xm.report.dao.ReportManager;
import com.interstarinc.xm.report.dao.SiteManager;

public class ApplicationContext {
    private static ApplicationContext context;
    private DataSourceManager dataSourceManager;
    private SiteManager siteManager;
    private ReportManager reportManager;

    public static synchronized ApplicationContext getContext() throws Exception {
        if (context == null) {
            context = new ApplicationContext();
            context.init();
        }
        return context;
    }

    public static synchronized void shutdown() {
        if (context != null) {
            context.destroy();
            context = null;
        }
    }

    private void init() throws ServiceUnavailableX {
        ServiceLocator locator = ServiceLocator.getInstance();
        this.dataSourceManager = new DataSourceManager(locator.getCorbaInit().getOrb());
        this.siteManager = new SiteManager(locator.getCorbaInit().getOrb(), locator.getCorbaInit().getRootPoa());
        this.reportManager = new ReportManager(locator.getCorbaInit().getOrb(), locator.getCorbaInit().getRootPoa());
    }

    private void destroy() {
        this.siteManager.shutdown();
        this.reportManager.shutdown();
    }

    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    public SiteManager getSiteManager() {
        return this.siteManager;
    }

    public ReportManager getReportManager() {
        return this.reportManager;
    }
}

