/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteListNodeId;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;

public class XmUser
extends XmBase {
    private static final int LIST_ALL = 0;
    private static final int LIST_ONE = 1;
    private static final int ADD = 2;
    private static final int MODIFY = 3;
    private static final int ADD_OR_MODIFY = 4;
    private static final int REMOVE = 5;
    private static final int REMOVE_FAX = 8;
    private static final int HELP = 6;
    private static final int MODIFY_PASS = 7;
    private int m_mode = 0;
    private boolean m_bReadFromFile = false;
    private String m_param = "";

    @Override
    public void execute(String string) {
        String[] stringArray = null;
        this.doWork(stringArray);
    }

    public static void main(String[] stringArray) {
        XmUser xmUser = new XmUser();
        xmUser.doWork(stringArray);
    }

    private void doWork(String[] stringArray) {
        System.out.println("XmUser - Add, modify, remove users");
        System.out.println("------------------------------------------------------------\n");
        this.processArgs(stringArray);
        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] stringArray) {
        XmBase.ParsedCommandLine parsedCommandLine = null;
        try {
            parsedCommandLine = XmBase.getParsedCommandLine(stringArray);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.toString());
            return;
        }
        if (!this.parseArgs(parsedCommandLine.remainingArgs)) {
            return;
        }
        if (this.m_mode == 6) {
            this.outputUsage();
            return;
        }
        BufferedReader bufferedReader = null;
        if (this.m_bReadFromFile && (bufferedReader = this.getBufferedFileReader(this.m_param)) == null) {
            return;
        }
        if (!this.validateLoginInfo(parsedCommandLine, true)) {
            return;
        }
        Session session = this.openSession(parsedCommandLine);
        if (session == null) {
            return;
        }
        try {
            parsedCommandLine.targetSite = this.getSiteGuidFromSiteName(session, parsedCommandLine.targetSite);
            SiteListNodeId siteListNodeId = SiteListNodeId.create((SiteListNodeId.Name)SiteListNodeId.Name.USERS, (String)parsedCommandLine.targetSite);
            SiteListNodeId siteListNodeId2 = SiteListNodeId.create((SiteListNodeId.Name)SiteListNodeId.Name.PROFILES, (String)parsedCommandLine.targetSite);
            ListNode listNode = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId);
            ListNode listNode2 = null;
            switch (this.m_mode) {
                case 0: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.listAll(listNode, listNode2);
                    break;
                }
                case 1: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.listOne(listNode, listNode2, this.m_param);
                    break;
                }
                case 2: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.addUsers(listNode, listNode2, bufferedReader, this.m_param);
                    break;
                }
                case 3: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.modifyUsers(listNode, listNode2, bufferedReader, this.m_param, false);
                    break;
                }
                case 7: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.modifyPassUsers(listNode, listNode2, bufferedReader, this.m_param);
                    break;
                }
                case 4: {
                    listNode2 = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId2);
                    this.modifyUsers(listNode, listNode2, bufferedReader, this.m_param, true);
                    break;
                }
                case 5: {
                    this.removeUsers(listNode, bufferedReader, this.m_param);
                    break;
                }
                case 8: {
                    this.removeUsersFax(listNode, bufferedReader, this.m_param);
                }
            }
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean parseArgs(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '-') {
                if (stringArray[i].equalsIgnoreCase("-l")) {
                    this.m_mode = 0;
                    bl = false;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-i")) {
                    this.m_mode = 1;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-a")) {
                    this.m_mode = 2;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-m")) {
                    this.m_mode = 3;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-mp")) {
                    this.m_mode = 7;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-am")) {
                    this.m_mode = 4;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-r")) {
                    this.m_mode = 5;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-rf")) {
                    this.m_mode = 8;
                    bl = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-f")) {
                    this.m_bReadFromFile = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-h")) {
                    this.m_mode = 6;
                    bl = false;
                    continue;
                }
                this.outputWarning("Invalid option: " + stringArray[i]);
                continue;
            }
            this.m_param = stringArray[i];
        }
        if (bl && this.m_param.equals("")) {
            if (this.m_bReadFromFile) {
                this.outputError("Missing file name");
            } else {
                this.outputError("Missing user description");
            }
            return false;
        }
        return true;
    }

    private void listAll(ListNode listNode, ListNode listNode2) {
        this.outputInformation("--> Getting the list all users");
        int n = 0;
        ProfileList profileList = new ProfileList();
        if (!profileList.load(listNode2)) {
            this.outputError("Failed to load the profile list");
            return;
        }
        PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.USERS_SMTPADDRESS, PropertyDef.USERS_PROFILEID, PropertyDef.USERS_NTACCOUNT};
        try {
            View view = listNode.getView(propertyDefArray);
            long[] lArray = view.recordIds();
            for (int i = 0; i < lArray.length; ++i) {
                PropertyValue[] propertyValueArray = view.values(lArray[i]);
                String string = profileList.findName(propertyValueArray[1].stringValue());
                if (string == null) {
                    string = propertyValueArray[1].stringValue();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(propertyValueArray[0].stringValue());
                stringBuffer.append(",");
                stringBuffer.append(string);
                stringBuffer.append(",");
                stringBuffer.append(propertyValueArray[2].stringValue());
                this.outputInformation("user: " + stringBuffer.toString());
                ++n;
            }
            if (n < 2) {
                this.outputInformation("count: " + n);
            } else {
                this.outputInformation("count: " + n);
            }
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    private void listOne(ListNode listNode, ListNode listNode2, String string) {
        XmBase.Tokenizer tokenizer = new XmBase.Tokenizer(string);
        String string2 = tokenizer.getNextToken("");
        this.outputInformation("--> Getting information on user " + string2);
        ProfileList profileList = new ProfileList();
        if (!profileList.load(listNode2)) {
            this.outputError("Failed to load the profile list");
            return;
        }
        PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.USERS_SMTPADDRESS, PropertyDef.USERS_PROFILEID, PropertyDef.USERS_NTACCOUNT, PropertyDef.USERS_PASSWORD};
        try {
            View view = listNode.getView(propertyDefArray);
            long[] lArray = view.recordIds();
            boolean bl = false;
            for (int i = 0; i < lArray.length; ++i) {
                PropertyValue[] propertyValueArray = view.values(lArray[i]);
                if (!propertyValueArray[0].stringValue().equalsIgnoreCase(string2)) continue;
                String string3 = profileList.findName(propertyValueArray[1].stringValue());
                if (string3 == null) {
                    string3 = propertyValueArray[1].stringValue();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(propertyValueArray[0].stringValue());
                stringBuffer.append(",");
                stringBuffer.append(string3);
                stringBuffer.append(",");
                stringBuffer.append(propertyValueArray[2].stringValue());
                stringBuffer.append(",");
                stringBuffer.append(propertyValueArray[3].stringValue());
                this.outputInformation(stringBuffer.toString());
                bl = true;
                break;
            }
            if (!bl) {
                this.outputWarning("User not found");
            }
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeUsers(ListNode listNode, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            this.outputInformation("--> Removing one user");
        } else {
            this.outputInformation("--> Removing users from file: " + string);
        }
        UserMap userMap = new UserMap();
        if (!userMap.load(listNode)) {
            this.outputError("Failed to load the user list");
            return;
        }
        int n = 0;
        boolean bl = false;
        try {
            while (!bl) {
                String string2 = null;
                if (bufferedReader != null) {
                    string2 = bufferedReader.readLine();
                } else {
                    string2 = string;
                    bl = true;
                }
                if (string2 != null) {
                    XmBase.Tokenizer tokenizer = new XmBase.Tokenizer(string2);
                    String string3 = tokenizer.getNextToken(null);
                    if (string3 == null) continue;
                    long l = userMap.find(string3);
                    if (l != -1L) {
                        try {
                            listNode.deleteRecord(l);
                            this.outputInformation(string3 + " has been removed");
                            userMap.remove(string3);
                            ++n;
                            continue;
                        }
                        catch (XmediusException xmediusException) {
                            this.outputError("An error occured while removing " + string3 + " : " + xmediusException.getMessage());
                            continue;
                        }
                    }
                    this.outputWarning("User not found. " + string3 + " has not been removed.");
                    continue;
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.outputError("An error occured while reading the input file");
        }
        if (n < 2) {
            this.outputInformation("<-- " + n + " user has been removed");
            return;
        }
        this.outputInformation("<-- " + n + " users have been removed");
    }

    private void removeUsersFax(ListNode listNode, BufferedReader bufferedReader, String string) {
        this.outputInformation("--> Removing one user");
        int n = 0;
        boolean bl = false;
        String string2 = null;
        string2 = string;
        bl = true;
        try {
            XmBase.Tokenizer tokenizer;
            String string3;
            if (string2 != null && (string3 = (tokenizer = new XmBase.Tokenizer(string2)).getNextToken(null)) != null && !string3.equals("")) {
                PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.USERS_FAX};
                View view = listNode.getView(propertyDefArray);
                long[] lArray = view.recordIds();
                long l = -1L;
                for (int i = 0; i < lArray.length; ++i) {
                    PropertyValue[] propertyValueArray = view.values(lArray[i]);
                    if (!propertyValueArray[0].stringValue().equals(string3)) continue;
                    l = lArray[i];
                }
                if (l != -1L) {
                    listNode.deleteRecord(l);
                    this.outputInformation(string3 + " has been removed");
                    ++n;
                } else {
                    this.outputWarning("User not found. " + string3 + " has not been removed.");
                }
            }
        }
        catch (Exception exception) {
            this.outputError("Ha ocurrido un error al procesar la baja" + exception.getMessage());
        }
        this.outputInformation("<-- " + n + " user has been removed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addUsers(ListNode listNode, ListNode listNode2, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            this.outputInformation("--> Adding one user");
        } else {
            this.outputInformation("--> Adding users from file: " + string);
        }
        ProfileList profileList = new ProfileList();
        if (!profileList.load(listNode2)) {
            this.outputError("Failed to load the profile list");
            return;
        }
        UserMap userMap = new UserMap();
        if (!userMap.load(listNode)) {
            this.outputError("Failed to load the user list");
            return;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue(PropertyDef.USERS_SMTPADDRESS), new PropertyValue(PropertyDef.USERS_PROFILEID), new PropertyValue(PropertyDef.USERS_NTACCOUNT), new PropertyValue(PropertyDef.USERS_PASSWORD), new PropertyValue(PropertyDef.USERS_FAX)};
        boolean bl = false;
        int n = 0;
        try {
            while (!bl) {
                String string2 = null;
                if (bufferedReader != null) {
                    string2 = bufferedReader.readLine();
                } else {
                    string2 = string;
                    bl = true;
                }
                if (string2 != null) {
                    XmBase.Tokenizer tokenizer = new XmBase.Tokenizer(string2);
                    String string3 = tokenizer.getNextToken(null);
                    String string4 = tokenizer.getNextToken("");
                    String string5 = tokenizer.getNextToken("");
                    String string6 = tokenizer.getNextToken("");
                    String string7 = tokenizer.getNextToken("");
                    if (string3 == null) continue;
                    long l = userMap.find(string3);
                    if (l == -1L) {
                        String string8 = profileList.findId(string4);
                        if (string8 != null) {
                            propertyValueArray[0].stringValue(string3);
                            propertyValueArray[1].stringValue(string8);
                            propertyValueArray[2].stringValue(string5);
                            propertyValueArray[3].stringValue(string6);
                            propertyValueArray[4].stringValue(string7);
                            try {
                                l = listNode.addRecord(propertyValueArray);
                                userMap.add(string3, l);
                                this.outputInformation(string3 + " has been added");
                                ++n;
                                continue;
                            }
                            catch (XmediusException xmediusException) {
                                this.outputError("An error occured while adding " + string3 + " : " + xmediusException.getMessage());
                                continue;
                            }
                        }
                        this.outputError("Unknown profile: '" + string4 + "'. " + string3 + " has not been added.");
                        continue;
                    }
                    this.outputWarning("User already exists. " + string3 + " has not been added.");
                    continue;
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.outputError("An error occured while reading the input file");
        }
        if (n < 2) {
            this.outputInformation("<-- " + n + " user has been added");
            return;
        }
        this.outputInformation("<-- " + n + " users have been added");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyUsers(ListNode listNode, ListNode listNode2, BufferedReader bufferedReader, String string, boolean bl) {
        if (bufferedReader == null) {
            if (bl) {
                this.outputInformation("--> Adding or modifying one user");
            } else {
                this.outputInformation("--> Modifying one user");
            }
        } else if (bl) {
            this.outputInformation("--> Adding or modifying users from file: " + string);
        } else {
            this.outputInformation("--> Modifying users from file: " + string);
        }
        ProfileList profileList = new ProfileList();
        if (!profileList.load(listNode2)) {
            this.outputError("Failed to load the profile list");
            return;
        }
        UserMap userMap = new UserMap();
        if (!userMap.load(listNode)) {
            this.outputError("Failed to load the user list");
            return;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue(PropertyDef.USERS_SMTPADDRESS), new PropertyValue(PropertyDef.USERS_PROFILEID), new PropertyValue(PropertyDef.USERS_NTACCOUNT), new PropertyValue(PropertyDef.USERS_PASSWORD), new PropertyValue(PropertyDef.USERS_FAX)};
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        try {
            while (!bl2) {
                String string2 = null;
                if (bufferedReader != null) {
                    string2 = bufferedReader.readLine();
                } else {
                    string2 = string;
                    bl2 = true;
                }
                if (string2 != null) {
                    String string3;
                    XmBase.Tokenizer tokenizer = new XmBase.Tokenizer(string2);
                    String string4 = tokenizer.getNextToken(null);
                    String string5 = tokenizer.getNextToken(null);
                    String string6 = tokenizer.getNextToken(null);
                    String string7 = tokenizer.getNextToken(null);
                    String string8 = tokenizer.getNextToken(null);
                    if (string4 == null) continue;
                    long l = userMap.find(string4);
                    if (l != -1L) {
                        if (string5 == null) continue;
                        string3 = profileList.findId(string5);
                        if (string3 != null) {
                            int n3 = 1;
                            if (string6 != null) {
                                ++n3;
                            }
                            if (string7 != null) {
                                ++n3;
                            }
                            PropertyValue[] propertyValueArray2 = new PropertyValue[n3];
                            n3 = 0;
                            propertyValueArray2[n3] = new PropertyValue(PropertyDef.USERS_PROFILEID);
                            propertyValueArray2[n3].stringValue(string3);
                            ++n3;
                            if (string6 != null) {
                                propertyValueArray2[n3] = new PropertyValue(PropertyDef.USERS_NTACCOUNT);
                                propertyValueArray2[n3].stringValue(string6);
                                ++n3;
                            }
                            if (string7 != null) {
                                propertyValueArray2[n3] = new PropertyValue(PropertyDef.USERS_PASSWORD);
                                propertyValueArray2[n3].stringValue(string7);
                                ++n3;
                            }
                            try {
                                listNode.setValues(l, propertyValueArray2);
                                this.outputInformation(string4 + " has been modified");
                                ++n2;
                                continue;
                            }
                            catch (XmediusException xmediusException) {
                                this.outputError("An error occured while modifying " + string4 + " : " + xmediusException.getMessage());
                                continue;
                            }
                        }
                        this.outputError("Unknown profile: '" + string5 + "'. " + string4 + " has not been modified.");
                        continue;
                    }
                    if (bl) {
                        if (string5 == null) {
                            string5 = "";
                        }
                        if ((string3 = profileList.findId(string5)) != null) {
                            propertyValueArray[0].stringValue(string4);
                            propertyValueArray[1].stringValue(string3);
                            propertyValueArray[2].stringValue(string6 == null ? "" : string6);
                            propertyValueArray[3].stringValue(string7 == null ? "" : string7);
                            propertyValueArray[4].stringValue(string8 == null ? "" : string8);
                            try {
                                l = listNode.addRecord(propertyValueArray);
                                userMap.add(string4, l);
                                this.outputInformation(string4 + " has been added");
                                ++n;
                                continue;
                            }
                            catch (XmediusException xmediusException) {
                                this.outputError("An error occured while adding " + string4 + " : " + xmediusException.getMessage());
                                continue;
                            }
                        }
                        this.outputError("Unknown profile: '" + string5 + "'. " + string4 + " has not been added.");
                        continue;
                    }
                    this.outputWarning("User not found. " + string4 + " has not been modified.");
                    continue;
                }
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            this.outputError("An error occured while reading the input file");
        }
        if (n2 < 2) {
            this.outputInformation("<-- " + n2 + " user has been modified");
        } else {
            this.outputInformation("<-- " + n2 + " users have been modified");
        }
        if (!bl) return;
        if (n < 2) {
            this.outputInformation("<-- " + n + " user has been added");
            return;
        }
        this.outputInformation("<-- " + n + " users have been added");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyPassUsers(ListNode listNode, ListNode listNode2, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            this.outputInformation("--> Modifying one user");
        } else {
            this.outputInformation("--> Modifying users from file: " + string);
        }
        ProfileList profileList = new ProfileList();
        if (!profileList.load(listNode2)) {
            this.outputError("Failed to load the profile list");
            return;
        }
        UserMap userMap = new UserMap();
        if (!userMap.load(listNode)) {
            this.outputError("Failed to load the user list");
            return;
        }
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue(PropertyDef.USERS_SMTPADDRESS), new PropertyValue(PropertyDef.USERS_PASSWORD)};
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        try {
            while (!bl2) {
                String string2 = null;
                if (bufferedReader != null) {
                    string2 = bufferedReader.readLine();
                } else {
                    string2 = string;
                    bl2 = true;
                }
                if (string2 != null) {
                    XmBase.Tokenizer tokenizer = new XmBase.Tokenizer(string2);
                    String string3 = tokenizer.getNextToken(null);
                    String string4 = tokenizer.getNextToken(null);
                    String string5 = tokenizer.getNextToken(null);
                    if (string3 != null) {
                        long l = userMap.find(string3);
                        if (l != -1L) {
                            int n2 = 0;
                            if (string4 != null && !string4.equals("")) {
                                ++n2;
                            }
                            if (string5 != null && !string5.equals("")) {
                                ++n2;
                            }
                            PropertyValue[] propertyValueArray2 = new PropertyValue[n2];
                            n2 = 0;
                            if (string4 != null && !string4.equals("")) {
                                propertyValueArray2[n2] = new PropertyValue(PropertyDef.USERS_SMTPADDRESS);
                                propertyValueArray2[n2].stringValue(string4);
                                ++n2;
                            }
                            if (string5 != null && !string5.equals("")) {
                                propertyValueArray2[n2] = new PropertyValue(PropertyDef.USERS_PASSWORD);
                                propertyValueArray2[n2].stringValue(string5);
                                ++n2;
                            }
                            try {
                                listNode.setValues(l, propertyValueArray2);
                                this.outputInformation(string3 + " has been modified");
                                ++n;
                                continue;
                            }
                            catch (XmediusException xmediusException) {
                                this.outputError("An error occured while modifying " + string3 + " : " + xmediusException.getMessage());
                                continue;
                            }
                        }
                        this.outputWarning("User not found. " + string3 + " has not been modified.");
                        continue;
                    }
                    this.outputWarning("User not specidiedd");
                    continue;
                }
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            this.outputError("An error occured while reading the input file");
        }
        if (n < 2) {
            this.outputInformation("<-- " + n + " user has been modified");
            return;
        }
        this.outputInformation("<-- " + n + " users have been modified");
    }

    private void outputUsage() {
        this.outputInformation("Usages:");
        this.outputInformation("");
        this.outputInformation("List all users                 : XmUser {LoginInfo} -l");
        this.outputInformation("Get information on one user    : XmUser {LoginInfo} -i \"smtpAddress\"");
        this.outputInformation("Add one user                   : XmUser {LoginInfo} -a \"smtpAddress,profileName[,assocNtAccount[,webPassword[,fax]]]\"");
        this.outputInformation("Add one or more users          : XmUser {LoginInfo} -a -f \"fileName\"");
        this.outputInformation("Add or modify a user           : XmUser {LoginInfo} -am \"smtpAddress,profileName[,assocNtAccount[,webPassword[,fax]]]\"");
        this.outputInformation("Add or modify one or more users: XmUser {LoginInfo} -am -f \"fileName\"");
        this.outputInformation("Modify a user                  : XmUser {LoginInfo} -m \"smtpAddress,profileName[,assocNtAccount[,webPassword[,fax]]]\"");
        this.outputInformation("Modify a user/passowod         : XmUser {LoginInfo} -mp \"smtpAddress,[newSmtpAddress,[,webPassword]]\"");
        this.outputInformation("Modify one or more users       : XmUser {LoginInfo} -m -f \"fileName\"");
        this.outputInformation("Remove a user                  : XmUser {LoginInfo} -r \"smtpAddress\"");
        this.outputInformation("Remove one or more users       : XmUser {LoginInfo} -r -f \"fileName\"");
        this.outputInformation("Remove a user by fax number    : XmUser {LoginInfo} -rf \"fax\"");
        this.outputInformation("");
        String[] stringArray = XmUser.GetLoginUsageSite();
        String string = "Where {LoginInfo} is: ";
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputInformation(string + stringArray[i]);
            string = "                  or: ";
        }
    }

    private class UserMap {
        private HashMap<String, Long> m_map = null;

        public boolean load(ListNode listNode) {
            if (listNode != null) {
                PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.USERS_SMTPADDRESS};
                try {
                    View view = listNode.getView(propertyDefArray);
                    long[] lArray = view.recordIds();
                    HashMap<String, Long> hashMap = new HashMap<String, Long>(lArray.length);
                    for (int i = 0; i < lArray.length; ++i) {
                        PropertyValue[] propertyValueArray = view.values(lArray[i]);
                        String string = propertyValueArray[0].stringValue();
                        if (string.equals("")) {
                            listNode.deleteRecord(lArray[i]);
                            continue;
                        }
                        hashMap.put(string.toUpperCase(), new Long(lArray[i]));
                    }
                    this.m_map = hashMap;
                    return true;
                }
                catch (XmediusException xmediusException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean contains(String string) {
            if (string != null && this.m_map != null) {
                return this.m_map.containsKey(string.toUpperCase());
            }
            return false;
        }

        public void add(String string, long l) {
            if (string != null && this.m_map != null) {
                this.m_map.put(string.toUpperCase(), new Long(l));
            }
        }

        public void remove(String string) {
            if (string != null && this.m_map != null) {
                this.m_map.remove(string.toUpperCase());
            }
        }

        public long find(String string) {
            Long l;
            if (string != null && this.m_map != null && (l = this.m_map.get(string.toUpperCase())) != null) {
                return l;
            }
            return -1L;
        }
    }

    private class ProfileList {
        private HashMap<String, String> m_nameToIdMap = null;
        private HashMap<String, String> m_idToNameMap = null;

        public boolean load(ListNode listNode) {
            if (listNode != null) {
                PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.PROFILES_NAME};
                try {
                    View view = listNode.getView(propertyDefArray);
                    long[] lArray = view.recordIds();
                    HashMap<String, String> hashMap = new HashMap<String, String>(lArray.length);
                    HashMap<String, String> hashMap2 = new HashMap<String, String>(lArray.length);
                    for (int i = 0; i < lArray.length; ++i) {
                        PropertyValue[] propertyValueArray = view.values(lArray[i]);
                        hashMap.put(propertyValueArray[0].stringValue().toUpperCase(), Long.toString(lArray[i]));
                        hashMap2.put(Long.toString(lArray[i]), propertyValueArray[0].stringValue());
                    }
                    this.m_nameToIdMap = hashMap;
                    this.m_idToNameMap = hashMap2;
                    return true;
                }
                catch (XmediusException xmediusException) {
                    // empty catch block
                }
            }
            return false;
        }

        public String findId(String string) {
            if (string != null && this.m_nameToIdMap != null) {
                return this.m_nameToIdMap.get(string.toUpperCase());
            }
            return null;
        }

        public String findName(String string) {
            if (string != null && this.m_idToNameMap != null) {
                return this.m_idToNameMap.get(string);
            }
            return null;
        }
    }
}

