/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.XmediusExceptionCause;

public class XmediusException
extends Exception {
    public static final String NAME = "com.interstarinc.xmedius.XmediusException";
    public static final long INVALID_ID = 0L;
    private XmediusExceptionCause m_cause;
    private String m_comment;
    private long m_recordId;

    public XmediusExceptionCause cause() {
        return this.m_cause;
    }

    public String comment() {
        return this.m_comment;
    }

    public boolean containsRecordId() {
        return this.m_recordId != 0L;
    }

    public long recordId() {
        return this.m_recordId;
    }

    public String getMessage() {
        return XmediusException.formatMessage(false, this.m_cause, this.m_comment, this.m_recordId);
    }

    XmediusException(XmediusExceptionCause cause) {
        this(cause, "", 0L);
    }

    XmediusException(XmediusExceptionCause cause, String comment) {
        this(cause, comment, 0L);
    }

    XmediusException(XmediusExceptionCause cause, String comment, long recordId) {
        super(XmediusException.formatMessage(true, cause, comment, recordId));
        this.m_cause = XmediusException.cause(cause);
        this.m_comment = XmediusException.comment(comment);
        this.m_recordId = XmediusException.recordId(recordId);
    }

    private static String formatMessage(boolean includeName, XmediusExceptionCause cause, String comment, long recordId) {
        StringBuffer buf = new StringBuffer();
        if (includeName) {
            buf.append(NAME);
            buf.append(": ");
        }
        if (XmediusException.recordId(recordId) != 0L) {
            buf.append("record<");
            buf.append(recordId);
            buf.append(">: ");
        }
        buf.append(XmediusException.cause(cause).toString());
        if (!XmediusException.comment(comment).equals("")) {
            buf.append(": ");
            buf.append(comment);
        }
        return buf.toString();
    }

    private static XmediusExceptionCause cause(XmediusExceptionCause cause) {
        return cause != null ? cause : XmediusExceptionCause.UNKNOWN;
    }

    private static String comment(String comment) {
        return comment != null ? comment : "";
    }

    private static long recordId(long recordId) {
        return recordId > 0L ? recordId : 0L;
    }
}

