/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.Records;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public class ViewRecords
implements View {
    private Records m_recs = null;
    private PropertyDef[] m_defs = null;
    private int m_hint = 0;

    public long[] recordIds() {
        int len = this.m_recs.Ids.length;
        long[] ids = new long[len];
        for (int i = 0; i < len; ++i) {
            ids[i] = this.m_recs.Ids[i];
        }
        return ids;
    }

    public PropertyValue[] values(long recordId) throws XmediusException {
        int i;
        int len = this.m_recs.Ids.length;
        int hint = this.m_hint;
        int index = -1;
        for (i = hint; i < len; ++i) {
            if (this.m_recs.Ids[i] != recordId) continue;
            index = i;
        }
        if (index == -1) {
            for (i = 0; i < hint; ++i) {
                if (this.m_recs.Ids[i] != recordId) continue;
                index = i;
            }
        }
        if (index == -1) {
            throw new XmediusException(XmediusExceptionCause.INVALID_RECORD_ID, "", recordId);
        }
        len = this.m_defs.length;
        PropertyValue[] values = new PropertyValue[len];
        for (i = 0; i < len; ++i) {
            values[i] = PropertyValue.fromTypedColumnIndexAndDef(this.m_recs.Columns[i], index, this.m_defs[i]);
        }
        this.m_hint = index;
        return values;
    }

    static ViewRecords fromRecordsAndDefs(Records recs, PropertyDef[] defs) throws NullPointerException, XmediusException {
        if (recs == null || defs == null) {
            throw new NullPointerException();
        }
        if (recs.Ids.length > 0 && recs.Columns.length != defs.length) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Data array size mismatch");
        }
        return new ViewRecords(recs, defs);
    }

    private ViewRecords(Records recs, PropertyDef[] defs) {
        this.m_recs = recs;
        int len = defs.length;
        this.m_defs = new PropertyDef[len];
        for (int i = 0; i < len; ++i) {
            this.m_defs[i] = defs[i];
        }
    }
}

