/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyMultiValue;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

class UserDirectoriesPropertyValueValidator
extends PropertyValueValidator {
    void onSetValues(PropertyValue[] values) throws XmediusException {
        for (int i = 0; i < values.length; ++i) {
            this.assertCanSet(values[i].def());
        }
    }

    void onSetMultiValues(PropertyMultiValue[] values) throws XmediusException {
        for (int i = 0; i < values.length; ++i) {
            this.assertCanSet(values[i].def());
        }
    }

    void onAddRecord(PropertyValue[] values) throws XmediusException {
        boolean typeFound = false;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].def() != PropertyDef.USERDIRECTORIES_TYPE) continue;
            this.assetValidType(values[i].intValue());
            typeFound = true;
        }
        if (!typeFound) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_TYPE must be set when adding a record");
        }
    }

    void onAddRecords(PropertyMultiValue[] values) throws XmediusException {
        boolean typeFound = false;
        for (int i = 0; i < values.length; ++i) {
            int[] types;
            if (values[i].def() != PropertyDef.USERDIRECTORIES_TYPE || (types = values[i].intValues()).length <= 0) continue;
            for (int j = 0; j < types.length; ++j) {
                this.assetValidType(types[j]);
            }
            typeFound = true;
        }
        if (!typeFound) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_TYPE must be set when adding a record");
        }
    }

    void onDeleteRecord() throws XmediusException {
    }

    UserDirectoriesPropertyValueValidator() {
    }

    private void assertCanSet(PropertyDef def) throws XmediusException {
        if (def == PropertyDef.USERDIRECTORIES_TYPE) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_TYPE is read only and cannot be modified.");
        }
        if (def == PropertyDef.USERDIRECTORIES_DIRECTORY) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_DIRECTORY is read only and cannot be modified.");
        }
        if (def == PropertyDef.USERDIRECTORIES_KEYATTRIBUTES) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_KEYATTRIBUTES is read only and cannot be modified.");
        }
        if (def == PropertyDef.USERDIRECTORIES_OUTPUTATTRIBUTES) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_OUTPUTATTRIBUTES is read only and cannot be modified.");
        }
        if (def == PropertyDef.USERDIRECTORIES_CONDITION) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "USERDIRECTORIES_CONDITION is read only and cannot be modified.");
        }
    }

    private void assetValidType(int type) throws XmediusException {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, "Valid values for USERDIRECTORIES_TYPE are USERDIRECTORIES_TYPE_INTERNAL, USERDIRECTORIES_TYPE_LDAP and USERDIRECTORIES_TYPE_ADNTLOOKUP.");
            }
        }
    }
}

