/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.Config;
import Xm.ConfigHelper;
import Xm.InvalidPropertiesX;
import Xm.JavaUtils.Port;
import Xm.List;
import Xm.PeerSystemManager;
import Xm.PeerSystemManagerHelper;
import Xm.PeerSystemManagerPackage.ResourceInfo;
import Xm.Records;
import Xm.StorageException;
import Xm.TypedValue;
import com.interstarinc.xmedius.HostList;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import java.util.HashMap;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Trader {
    private static final Trader m_Single = new Trader();

    static Trader getInstance() {
        return m_Single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object queryUniqueReference(ORB orb, HostList hostList, String type, String constraint) throws XmediusException {
        Lookup lookup = this.getLookup(orb, hostList);
        try {
            Object object = this.queryUniqueReference(lookup, type, constraint);
            return object;
        }
        finally {
            lookup._release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, String> getDriverNameToGuidMap(ORB orb, HostList hostList) throws XmediusException {
        Lookup lookup = this.getLookup(orb, hostList);
        try {
            HashMap<String, String> hashMap = this.getDriverNameToGuidMap(lookup);
            return hashMap;
        }
        finally {
            lookup._release();
        }
    }

    private Trader() {
    }

    private Lookup getLookup(ORB orb, HostList hostList) throws XmediusException {
        Lookup lookup = null;
        String[] hosts = hostList.getHosts();
        int index = hostList.getLastUsed();
        for (int count = hosts.length; count > 0; --count) {
            String corbaloc = "corbaloc:iiop:" + hosts[index] + ":" + Port.TraderPort() + "/TradingService";
            try {
                Object tradingObj = orb.string_to_object(corbaloc);
                if (tradingObj != null) {
                    lookup = LookupHelper.narrow((Object)tradingObj);
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (lookup != null) break;
            index = (index + 1) % hosts.length;
        }
        if (lookup == null) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Fail to resolve TradingService.");
        }
        hostList.setLastUsed(index);
        return lookup;
    }

    private Object queryUniqueReference(Lookup lookup, String type, String constraint) throws XmediusException {
        Offer offer = this.queryUniqueOffer(lookup, type, constraint);
        Object result = offer.reference;
        if (result == null) {
            throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE);
        }
        return result;
    }

    private Offer queryUniqueOffer(Lookup lookup, String type, String constraint) throws XmediusException {
        Offer result = new Offer();
        Policy[] policies = new Policy[]{};
        SpecifiedProps desired_props = new SpecifiedProps();
        int how_many = 1;
        OfferSeqHolder offers = new OfferSeqHolder();
        OfferIteratorHolder offer_itr = new OfferIteratorHolder();
        PolicyNameSeqHolder limits_applied = new PolicyNameSeqHolder();
        String pref = "first";
        desired_props.__default(HowManyProps.all);
        try {
            lookup.query(type, constraint, pref, policies, desired_props, how_many, offers, offer_itr, limits_applied);
            if (offer_itr.value != null) {
                offer_itr.value.destroy();
            }
            if (offers.value != null && offers.value.length > 0) {
                Offer offer = offers.value[0];
                result.reference = offer.reference;
                result.properties = new Property[offer.properties.length];
                for (int i = 0; i < result.properties.length; ++i) {
                    result.properties[i] = new Property();
                    result.properties[i].name = offer.properties[i].name;
                    result.properties[i].value = offer.properties[i].value;
                }
            }
        }
        catch (UserException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getNode on " + Session.ToPublicNodeName(constraint));
        }
        catch (SystemException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
        return result;
    }

    private void bankDriverData(HashMap<String, String> map, Offer offer) {
        try {
            String[] propertyNames = new String[]{"Display Name"};
            Object obj = offer.reference;
            Config config = ConfigHelper.narrow((Object)obj);
            TypedValue[] typedValues = config.GetTypedValues(propertyNames);
            String driverName = typedValues[0].wstring_value();
            Property[] props = offer.properties;
            for (int j = 0; j < props.length; ++j) {
                if (!props[j].name.equals("Guid")) continue;
                String driverGuid = props[j].value.extract_string();
                map.put(driverName, driverGuid);
                break;
            }
        }
        catch (InvalidPropertiesX ex) {
        }
        catch (StorageException ex) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    private HashMap<String, String> getDriverNameToGuidMap(Lookup lookup) {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        String type = "Config";
        String constraint = "Type == 'Driver'";
        String pref = "first";
        Policy[] policies = new Policy[]{};
        SpecifiedProps desired_props = new SpecifiedProps();
        desired_props.__default(HowManyProps.all);
        int how_many = 5;
        OfferSeqHolder offers = new OfferSeqHolder();
        OfferIteratorHolder offer_itr = new OfferIteratorHolder();
        PolicyNameSeqHolder limits_applied = new PolicyNameSeqHolder();
        try {
            lookup.query(type, constraint, pref, policies, desired_props, how_many, offers, offer_itr, limits_applied);
            if (offers.value != null) {
                for (i = 0; i < offers.value.length; ++i) {
                    this.bankDriverData(map, offers.value[i]);
                }
            }
            if (offer_itr.value != null) {
                boolean any_left = true;
                while (any_left) {
                    offers = new OfferSeqHolder();
                    any_left = offer_itr.value.next_n(how_many, offers);
                    if (offers.value == null) continue;
                    for (i = 0; i < offers.value.length; ++i) {
                        this.bankDriverData(map, offers.value[i]);
                    }
                }
                offer_itr.value.destroy();
            }
        }
        catch (UserException e) {
        }
        catch (SystemException e) {
            // empty catch block
        }
        try {
            type = "PeerSystemManager";
            constraint = "";
            lookup.query(type, constraint, pref, policies, desired_props, how_many, offers, offer_itr, limits_applied);
            if (offers.value != null && offers.value.length > 0) {
                PeerSystemManager peerSystemMgr = PeerSystemManagerHelper.narrow((Object)offers.value[0].reference);
                type = "Config";
                constraint = "Type == 'Peer Systems'";
                lookup.query(type, constraint, pref, policies, desired_props, how_many, offers, offer_itr, limits_applied);
                if (offers.value != null && offers.value.length > 0) {
                    Config peerSystems = ConfigHelper.narrow((Object)offers.value[0].reference);
                    List peerSystemList = peerSystems.GetPrimaryList();
                    String[] propertyNames = new String[]{"Guid"};
                    Records recs = peerSystemList.GetAllRecords(propertyNames);
                    int imax = recs.Ids.length;
                    for (i = 0; i < imax; ++i) {
                        ResourceInfo[] drivers = peerSystemMgr.GetDrivers(recs.Columns[0].wstring_column()[i]);
                        int jmax = drivers.length;
                        for (int j = 0; j < jmax; ++j) {
                            String name = drivers[j].Name;
                            String guid = drivers[j].Guid;
                            map.put(name, guid);
                        }
                    }
                }
            }
        }
        catch (UserException e) {
        }
        catch (SystemException e) {
            // empty catch block
        }
        return map;
    }
}

