/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.BuiltInAttributesPropertyValueValidator;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.ReadOnlyPropertyValueValidator;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.UserDirectoriesPropertyValueValidator;
import com.interstarinc.xmedius.WebReportPropertyValueValidator;
import com.interstarinc.xmedius.XmediusException;

public class SystemListNodeId
extends ListNodeId {
    private Name m_name = null;

    public static SystemListNodeId create(Name name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        return new SystemListNodeId(name);
    }

    public String nodeName() {
        return this.m_name.nodeName();
    }

    public String toString() {
        return this.m_name.toString();
    }

    String constraint(Session session) throws NullPointerException, XmediusException {
        StringBuffer buf = new StringBuffer();
        buf.append("Type");
        buf.append(" == '");
        buf.append(this.m_name.nodeName());
        buf.append("'");
        return buf.toString();
    }

    String listName() {
        return this.m_name.listName();
    }

    boolean isSub() {
        return this.m_name.isSub();
    }

    boolean isList(String name) {
        return name != null && name.equals(this.m_name.toString());
    }

    PropertyValueValidator validator() {
        return this.m_name.validator();
    }

    private SystemListNodeId(Name name) {
        this.m_name = name;
    }

    public static class Name {
        private String m_node = null;
        private String m_list = null;
        private boolean m_isSub = false;
        private PropertyValueValidator m_validator = null;
        public static final Name LCRTABLE = new Name("LCR Table");
        public static final Name MODIFICATIONTABLE = new Name("Fax Manager Modification Table");
        public static final Name MODIFICATIONTABLE_ACTIONS = new Name("Fax Manager Modification Table", "Action List", true);
        public static final Name LOADBALANCINGPROFILES = new Name("Load Balancing");
        public static final Name LOADBALANCINGPROFILES_RULES = new Name("Load Balancing", "Rules List", true);
        public static final Name LOADBALANCINGPROFILES_RULES_DRIVERS = new Name("Load Balancing", "Drivers", true);
        public static final Name SITES = new Name("Companies", "Company List", false);
        public static final Name ROUTING = new Name("Routing Table");
        public static final Name SITELOOKUPRULES = new Name("Site Lookup Rules");
        public static final Name SITELOOKUPRULES_CONDITIONS = new Name("Site Lookup Rules", "List_Conditions", true);
        public static final Name USERDIRECTORIES = new Name("User Directories", null, false, new UserDirectoriesPropertyValueValidator());
        public static final Name USERDIRECTORIES_CONDITIONS = new Name("User Directories", "Conditions", true);
        public static final Name USERDIRECTORIES_LDAPBUILTINATTRIBUTES = new Name("User Directories", "LDAP Built-in Attributes", true, new BuiltInAttributesPropertyValueValidator());
        public static final Name USERDIRECTORIES_LDAPCUSTOMATTRIBUTES = new Name("User Directories", "LDAP Custom Attributes", true);
        public static final Name USERDIRECTORIES_INTERNALBUILTINATTRIBUTES = new Name("User Directories", "Internal Built-in Attributes", true, new BuiltInAttributesPropertyValueValidator());
        public static final Name USERDIRECTORIES_INTERNALCUSTOMATTRIBUTES = new Name("User Directories", "Internal Custom Attributes", true);
        public static final Name HOSTLIST = new Name("Host List", "Host List", false, new ReadOnlyPropertyValueValidator());
        public static final Name WEBREPORTS = new Name("Web Reports", null, false, new WebReportPropertyValueValidator());

        public String nodeName() {
            return this.m_node;
        }

        public String listName() {
            return this.m_list;
        }

        public boolean isSub() {
            return this.m_isSub;
        }

        public String toString() {
            if (this.m_isSub) {
                return this.m_node + ":" + this.m_list;
            }
            return this.m_node + ":list";
        }

        PropertyValueValidator validator() {
            return this.m_validator;
        }

        private Name(String node) {
            this(node, null, false, null);
        }

        private Name(String node, String list, boolean isSub) {
            this(node, list, isSub, null);
        }

        private Name(String node, String list, boolean isSub, PropertyValueValidator validator) {
            this.m_node = node;
            this.m_list = list;
            this.m_isSub = isSub;
            this.m_validator = validator;
        }
    }
}

