/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.SiteResolverHelper;
import Xm.SiteResolverPackage.NonUniqueMatch;
import Xm.SiteResolverPackage.NotReady;
import Xm.SiteResolverPackage.SiteNotFound;
import com.interstarinc.xmedius.HostList;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import java.util.Properties;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;

public class SiteResolver {
    private Xm.SiteResolver m_resolver = null;

    public static SiteResolver create(String[] servers) throws XmediusException {
        return FreeSiteResolver.create(servers);
    }

    public static SiteResolver create(Session session) throws XmediusException {
        return SessionSiteResolver.create(session);
    }

    public String getIdentifier(String name) throws XmediusException {
        try {
            return this.m_resolver.GetSiteIdByName(name);
        }
        catch (SiteNotFound e) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, e.getMessage());
        }
        catch (NonUniqueMatch e) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, e.getMessage());
        }
        catch (NotReady e) {
            throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, e.getMessage());
        }
        catch (UserException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
        catch (SystemException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
    }

    public String getName(String identifier) throws XmediusException {
        try {
            return this.m_resolver.GetSiteNameById(identifier);
        }
        catch (SiteNotFound e) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, e.getMessage());
        }
        catch (NotReady e) {
            throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, e.getMessage());
        }
        catch (UserException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
        catch (SystemException e) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, e.getMessage());
        }
    }

    protected SiteResolver(Xm.SiteResolver resolver) {
        this.m_resolver = resolver;
    }

    private static class FreeSiteResolver
    extends SiteResolver {
        private ORB m_orb = null;
        private HostList m_hostList = null;

        private FreeSiteResolver(ORB orb, Xm.SiteResolver resolver) {
            super(resolver);
            this.m_orb = orb;
        }

        public static FreeSiteResolver create(String[] hosts) throws XmediusException {
            try {
                HostList hostList = new HostList(hosts);
                Properties sslProps = new Properties();
                sslProps.put("jacorb.security.support_ssl", "off");
                sslProps.put("jacorb.security.default_user", "");
                sslProps.put("jacorb.security.default_password", "");
                ORB orb = Session.orbInit("FreeSiteResolver", sslProps);
                Object obj = Session.getObjectFromTrader(orb, hostList, "SiteResolver", "");
                Xm.SiteResolver resolver = SiteResolverHelper.narrow((Object)obj);
                if (resolver == null) {
                    throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, "SiteResolver");
                }
                return new FreeSiteResolver(orb, resolver);
            }
            catch (NO_PERMISSION ex) {
                throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveSiteResolver");
            }
            catch (SystemException ex) {
                throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
            }
        }
    }

    private static class SessionSiteResolver
    extends SiteResolver {
        private Session m_session = null;

        private SessionSiteResolver(Session session, Xm.SiteResolver resolver) {
            super(resolver);
            this.m_session = session;
        }

        public static SessionSiteResolver create(Session session) throws XmediusException {
            try {
                Object obj = session.getObjectFromTrader("SiteResolver", "");
                Xm.SiteResolver resolver = SiteResolverHelper.narrow((Object)obj);
                if (resolver == null) {
                    throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, "SiteResolver");
                }
                return new SessionSiteResolver(session, resolver);
            }
            catch (NO_PERMISSION ex) {
                throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveSiteResolver");
            }
            catch (SystemException ex) {
                throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
            }
        }
    }
}

