/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteAdminPropertyValueValidator;
import com.interstarinc.xmedius.XmediusException;

public class SiteListNodeId
extends ListNodeId {
    private Name m_name = null;
    private String m_site = null;

    public static SiteListNodeId create(Name name, String siteIdentifier) throws NullPointerException {
        if (name == null || siteIdentifier == null) {
            throw new NullPointerException();
        }
        return new SiteListNodeId(name, siteIdentifier);
    }

    public String nodeName() {
        return this.m_name.nodeName();
    }

    public String toString() {
        return this.m_site + " - " + this.m_name.toString();
    }

    String constraint(Session session) throws NullPointerException, XmediusException {
        StringBuffer buf = new StringBuffer();
        buf.append("Type");
        buf.append(" == '");
        buf.append(this.m_name.nodeName());
        buf.append("' and ");
        buf.append("Guid");
        buf.append(" == '");
        buf.append(this.m_site);
        buf.append("'");
        return buf.toString();
    }

    String listName() {
        return this.m_name.listName();
    }

    boolean isSub() {
        return this.m_name.isSub();
    }

    boolean isList(String name) {
        return name != null && name.equals(this.m_name.toString());
    }

    PropertyValueValidator validator() {
        return this.m_name.validator();
    }

    private SiteListNodeId(Name name, String site) {
        this.m_name = name;
        this.m_site = site;
    }

    public static class Name {
        private String m_node = null;
        private String m_list = null;
        private boolean m_isSub = false;
        private PropertyValueValidator m_validator = null;
        public static final Name GENERAL_SMTPGTWYMAILSERVERS = new Name("Company General", "List_SmtpGtwyMailServers", false);
        public static final Name USERS = new Name("Company Users");
        public static final Name PROFILES = new Name("Company Profiles");
        public static final Name PROFILES_COVERSHEETS = new Name("Company Profiles", "List_CoverSheets", true);
        public static final Name PROFILES_ADDITIONALFEEDBACKDESTINATIONS = new Name("Company Profiles", "List_AlternateFeedbackDestinations", true);
        public static final Name COVERSHEETS = new Name("Company Cover Sheets");
        public static final Name ROUTING = new Name("Company Routing");
        public static final Name ROUTING_DESTINATIONS = new Name("Company Routing", "List_RoutingDestinations", true);
        public static final Name BILLINGCODEGROUPS = new Name("Company Billing Code Groups");
        public static final Name BILLINGCODEGROUPS_BILLINGCODES = new Name("Company Billing Code Groups", "List_BillingCodes", true);
        public static final Name NUMBERRESTRICTIONGROUPS = new Name("Company Number Restriction Groups");
        public static final Name NUMBERRESTRICTIONGROUPS_NUMBERRESTRICTIONS = new Name("Company Number Restriction Groups", "List_NumberRestrictions", true);
        public static final Name MAILDESTINATIONS = new Name("Company Mail Destinations");
        public static final Name PRINTERDESTINATIONS = new Name("Company Printer Destinations");
        public static final Name FOLDERDESTINATIONS = new Name("Company Directory Destinations");
        public static final Name EXTERNALAPPLICATIONDESTINATIONS = new Name("Company Corba Destinations");
        public static final Name PYTHONDESTINATIONS = new Name("Company Python Destinations");
        public static final Name SITEADMINISTRATORS = new Name("Company Administrators", null, false, new SiteAdminPropertyValueValidator());
        public static final Name NOTIFICATIONPROFILES = new Name("Company Notification Profiles");
        public static final Name PROFILELOOKUPRULES = new Name("Company Profile Lookup Rules");
        public static final Name PROFILELOOKUPRULES_CONDITIONS = new Name("Company Profile Lookup Rules", "List_Conditions", true);
        public static final Name PROFILES_PHONEBOOKS = new Name("Company Profiles", "List_Phonebooks", true);

        public String nodeName() {
            return this.m_node;
        }

        public String listName() {
            return this.m_list;
        }

        public boolean isSub() {
            return this.m_isSub;
        }

        public String toString() {
            if (this.m_isSub) {
                return this.m_node + ":" + this.m_list;
            }
            return this.m_node + ":list";
        }

        PropertyValueValidator validator() {
            return this.m_validator;
        }

        private Name(String node) {
            this(node, null, false, null);
        }

        private Name(String node, String list, boolean isSub) {
            this(node, list, isSub, null);
        }

        private Name(String node, String list, boolean isSub, PropertyValueValidator validator) {
            this.m_node = node;
            this.m_list = list;
            this.m_isSub = isSub;
            this.m_validator = validator;
        }
    }
}

