/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.ConfigNodeId;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;

public class SiteConfigNodeId
extends ConfigNodeId {
    private Name m_name = null;
    private String m_site = null;

    public static SiteConfigNodeId create(Name name, String siteIdentifier) throws NullPointerException {
        if (name == null || siteIdentifier == null) {
            throw new NullPointerException();
        }
        return new SiteConfigNodeId(name, siteIdentifier);
    }

    public String nodeName() {
        return this.m_name.nodeName();
    }

    public String toString() {
        return this.m_site + " - " + this.m_name.toString();
    }

    String constraint(Session session) throws NullPointerException, XmediusException {
        StringBuffer buf = new StringBuffer();
        buf.append("Type");
        buf.append(" == '");
        buf.append(this.m_name.nodeName());
        buf.append("' and ");
        buf.append("Guid");
        buf.append(" == '");
        buf.append(this.m_site);
        buf.append("'");
        return buf.toString();
    }

    PropertyValueValidator validator() {
        return null;
    }

    private SiteConfigNodeId(Name name, String site) {
        this.m_name = name;
        this.m_site = site;
    }

    public static class Name {
        private String m_node = null;
        public static final Name GENERAL = new Name("Company General");

        public String nodeName() {
            return this.m_node;
        }

        public String toString() {
            return this.m_node;
        }

        private Name(String node) {
            this.m_node = node;
        }
    }
}

