/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.JavaUtils.PasswordHashing;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyMultiValue;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.RightsBuilder;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteListNodeId;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

class SiteAdminPropertyValueValidator
extends PropertyValueValidator {
    void onSetValues(PropertyValue[] values) throws XmediusException {
        for (int i = 0; i < values.length; ++i) {
            if (values[i].def() == PropertyDef.SITEADMINISTRATORS_RIGHTS) {
                if (RightsBuilder.validate(values[i].stringValue())) continue;
                throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, this.myName() + ": " + values[i].stringValue() + " cannot be applied to SITEADMINISTRATORS_RIGHTS");
            }
            if (values[i].def() != PropertyDef.SITEADMINISTRATORS_PASSWORD) continue;
            String hashed = new PasswordHashing().LegacyDigest(values[i].stringValue());
            values[i].stringValue(hashed);
        }
    }

    void onSetMultiValues(PropertyMultiValue[] values) throws XmediusException {
        for (int i = 0; i < values.length; ++i) {
            String[] stringValues;
            if (values[i].def() == PropertyDef.SITEADMINISTRATORS_RIGHTS) {
                stringValues = values[i].stringValues();
                for (int j = 0; j < stringValues.length; ++j) {
                    if (RightsBuilder.validate(stringValues[j])) continue;
                    throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, this.myName() + ": " + stringValues[j] + " cannot be applied to SITEADMINISTRATORS_RIGHTS");
                }
                continue;
            }
            if (values[i].def() != PropertyDef.SITEADMINISTRATORS_PASSWORD) continue;
            stringValues = values[i].stringValues();
            String[] hashed = new String[stringValues.length];
            for (int j = 0; j < stringValues.length; ++j) {
                hashed[j] = new PasswordHashing().LegacyDigest(stringValues[j]);
            }
            values[i].stringValues(hashed);
        }
    }

    void onAddRecord(PropertyValue[] values) throws XmediusException {
        this.onSetValues(values);
    }

    void onAddRecords(PropertyMultiValue[] values) throws XmediusException {
        this.onSetMultiValues(values);
    }

    void onDeleteRecord() throws XmediusException {
    }

    SiteAdminPropertyValueValidator() {
    }

    private String myName() {
        return Session.ToPublicNodeName(SiteListNodeId.Name.SITEADMINISTRATORS.nodeName());
    }
}

