/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.JavaUtils.Credentials;
import Xm.JavaUtils.DirectoryHelper;
import Xm.JavaUtils.XmKeyCert;
import Xm.JavaUtils.XmKeyStoreException;
import Xm.JavaUtils.XmKeyStoreHelper;
import Xm.License.Initializing;
import Xm.License.InvalidLicense;
import Xm.License.LicenseExpired;
import Xm.License.LicenseManager;
import Xm.License.LicenseManagerHelper;
import com.interstarinc.xmedius.HostList;
import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.SystemListNodeId;
import com.interstarinc.xmedius.Trader;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static boolean m_isActive = false;
    private ORB m_orb = null;
    private HashMap<String, String> m_hostMap = null;
    private HostList m_hostList = null;

    public static synchronized Session open(String username, String password) throws NullPointerException, XmediusException {
        String[] servers = Session.getHostListOrLocal();
        SessionToken token = SessionToken.create(username, password, servers);
        return Session.create(token);
    }

    public static synchronized Session open(String username, String password, String[] servers) throws NullPointerException, XmediusException {
        SessionToken token = SessionToken.create(username, password, servers);
        return Session.create(token);
    }

    public static synchronized Session open(String site, String username, String password) throws NullPointerException, XmediusException {
        String[] servers = Session.getHostListOrLocal();
        SessionToken token = SessionToken.create(site, username, password, servers);
        return Session.create(token);
    }

    public static synchronized Session open(String site, String username, String password, String[] servers) throws NullPointerException, XmediusException {
        SessionToken token = SessionToken.create(site, username, password, servers);
        return Session.create(token);
    }

    private static Session create(SessionToken token) throws XmediusException {
        if (m_isActive) {
            throw new XmediusException(XmediusExceptionCause.INVALID_STATE, "Session already active");
        }
        Properties sslProps = Session.loadKeyCertificate(token);
        Session session = new Session(token, sslProps);
        session.validateLicense();
        m_isActive = true;
        return session;
    }

    private static Properties loadKeyCertificate(SessionToken token) throws XmediusException {
        String keyStorePwd = token.password();
        String principalId = token.username();
        String principalPwd = token.password();
        String caId = "ca";
        String directory = DirectoryHelper.GetClientFolder();
        StringBuffer buf = new StringBuffer(directory);
        buf.append("/JavaSecurity/");
        buf.append(token.site());
        buf.append(token.username());
        String keyStoreFilename = buf.toString() + "KeyStore.keystore";
        String certFilename = buf.toString() + "Cert.pem";
        String caCertFilename = buf.toString() + "CaCert.pem";
        String[] servers = token.servers();
        StringBuffer hosts = new StringBuffer();
        for (int i = 0; i < servers.length; ++i) {
            hosts.append(servers[i]);
            hosts.append(",");
        }
        byte[] key = null;
        Credentials.IntHolder result = new Credentials.IntHolder();
        key = token.isIsp() ? Credentials.GetPrincipalKeyCert((String)principalId, (String)principalPwd, (String)hosts.toString(), (String)certFilename, (String)caCertFilename, (Credentials.IntHolder)result) : Credentials.GetSitePrincipalKeyCert((String)token.site(), (String)principalId, (String)principalPwd, (String)hosts.toString(), (String)certFilename, (String)caCertFilename, (Credentials.IntHolder)result);
        if (key == null) {
            switch (result.Value()) {
                case 1: {
                    throw new XmediusException(XmediusExceptionCause.AUTHENTICATION_FAILED, "Credentials not found");
                }
                case 2: {
                    throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, "Unable to reach the certificate authority");
                }
                case 3: {
                    throw new XmediusException(XmediusExceptionCause.AUTHENTICATION_FAILED, "The user in not authorized");
                }
                case 4: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "File I/O error while processing key and certificates");
                }
                case 5: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Error while processing key and certificates");
                }
            }
            throw new XmediusException(XmediusExceptionCause.UNKNOWN, "Error while loading key and certificates <" + result.Value() + ">");
        }
        try {
            XmKeyStoreHelper store = new XmKeyStoreHelper();
            store.load(null, keyStorePwd);
            XmKeyCert keyCert = new XmKeyCert(principalId, principalPwd);
            keyCert.loadPrivateKey(key);
            keyCert.loadCert(certFilename);
            store.setKeyCert(keyCert);
            keyCert = new XmKeyCert(caId, null);
            keyCert.loadCert(caCertFilename);
            store.setCert(keyCert);
            store.store(keyStoreFilename, keyStorePwd);
        }
        catch (XmKeyStoreException ex) {
            throw new XmediusException(XmediusExceptionCause.AUTHENTICATION_FAILED, ex.toString());
        }
        Properties props = new Properties();
        props.put("jacorb.security.support_ssl", "on");
        props.put("jacorb.security.keystore", keyStoreFilename);
        props.put("jacorb.security.keystore_password", keyStorePwd);
        props.put("jacorb.security.default_user", principalId);
        props.put("jacorb.security.default_password", principalPwd);
        return props;
    }

    private Session(SessionToken token, Properties sslProps) {
        this.m_hostList = new HostList(token.servers());
        this.m_orb = Session.orbInit("", sslProps);
    }

    Object getObjectFromTrader(String type, String constraint) throws XmediusException {
        return Session.getObjectFromTrader(this.m_orb, this.m_hostList, type, constraint);
    }

    static Object getObjectFromTrader(ORB orb, HostList hostList, String type, String constraint) throws XmediusException {
        return Trader.getInstance().queryUniqueReference(orb, hostList, type, constraint);
    }

    HashMap<String, String> getDriverNameToGuidMap() throws XmediusException {
        return Trader.getInstance().getDriverNameToGuidMap(this.m_orb, this.m_hostList);
    }

    synchronized String fromHostNameToHostGuid(String hostName) {
        if (this.m_hostMap == null) {
            this.m_hostMap = new HashMap();
            try {
                SystemListNodeId nodeId = SystemListNodeId.create(SystemListNodeId.Name.HOSTLIST);
                ListNode hostList = ListNode.getNode(this, nodeId);
                PropertyDef[] props = new PropertyDef[]{PropertyDef.HOSTLIST_HOSTS_NAME, PropertyDef.HOSTLIST_HOSTS_GUID};
                View view = hostList.getView(props);
                long[] ids = view.recordIds();
                for (int i = 0; i < ids.length; ++i) {
                    PropertyValue[] values = view.values(ids[i]);
                    this.m_hostMap.put(values[0].stringValue().toUpperCase(), values[1].stringValue());
                }
            }
            catch (XmediusException xmediusException) {
                // empty catch block
            }
        }
        return this.m_hostMap.get(hostName.toUpperCase());
    }

    static String ToPublicNodeName(String Input) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        if (Input.equalsIgnoreCase("Company")) {
            buf.append("Site");
        } else if (Input.equalsIgnoreCase("Companies")) {
            buf.append("Sites");
        } else if (Input.startsWith("Company")) {
            buf.append("Site");
            buf.append(Input.substring(7));
        } else {
            buf.append(Input);
        }
        buf.append(">");
        return buf.toString();
    }

    static ORB orbInit(String orbId, Properties sslProps) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        props.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        if (!orbId.equals("")) {
            props.put("org.omg.CORBA.ORBId", orbId);
        }
        props.putAll((Map<?, ?>)sslProps);
        return ORB.init((String[])new String[0], (Properties)props);
    }

    private static String[] getHostListOrLocal() {
        Xm.JavaUtils.HostList hostList = new Xm.JavaUtils.HostList();
        String[] servers = hostList.GetHostNames();
        if (servers == null || servers.length == 0) {
            servers = new String[]{Session.getLocalHost()};
        }
        return servers;
    }

    private static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private void validateLicense() throws XmediusException {
        String type = "LicenseManagerGroup";
        String constraint = "";
        try {
            Object obj = this.getObjectFromTrader(type, constraint);
            LicenseManager licenseManager = LicenseManagerHelper.narrow((Object)obj);
            if (licenseManager == null) {
                throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, "License Manager");
            }
            if (!licenseManager.IsEnabled((short)301)) {
                throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "The JavaAPI is not enabled by the license");
            }
        }
        catch (Initializing ex) {
            throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, "License Manager not ready");
        }
        catch (LicenseExpired ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "The license is expired");
        }
        catch (InvalidLicense ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "The license is invalid");
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, ex.getMessage());
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    private static class SessionToken {
        private boolean m_isIsp;
        private String m_site;
        private String m_username;
        private String m_password;
        private String[] m_servers;

        public static SessionToken create(String username, String password, String[] servers) {
            SessionToken.Validate("", username, password, servers);
            return new SessionToken(true, "", username, password, servers);
        }

        public static SessionToken create(String site, String username, String password, String[] servers) {
            SessionToken.Validate(site, username, password, servers);
            return new SessionToken(false, site, username, password, servers);
        }

        public boolean isIsp() {
            return this.m_isIsp;
        }

        public String site() {
            return this.m_site;
        }

        public String username() {
            return this.m_username;
        }

        public String password() {
            return this.m_password;
        }

        public String[] servers() {
            return this.m_servers;
        }

        private SessionToken(boolean isIsp, String site, String username, String password, String[] servers) {
            this.m_isIsp = isIsp;
            this.m_site = site;
            this.m_username = username;
            this.m_password = password;
            this.m_servers = servers;
        }

        private static void Validate(String site, String username, String password, String[] servers) throws NullPointerException {
            if (site == null || username == null || password == null || servers == null) {
                throw new NullPointerException();
            }
            int serverCount = servers.length;
            if (serverCount == 0) {
                throw new NullPointerException();
            }
            for (int i = 0; i < serverCount; ++i) {
                if (servers[i] != null) continue;
                throw new NullPointerException();
            }
        }
    }
}

