/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.CommaSeparatedValues;
import java.util.HashSet;
import java.util.Set;

public class RightsBuilder {
    private Set<String> m_set = new HashSet<String>();

    public void clear() {
        this.m_set.clear();
    }

    public void add(AccessRight right) {
        if (right != null) {
            this.m_set.add(right.value());
        }
    }

    public void add(String rights) {
        if (rights != null) {
            AccessRight[] values = RightsBuilder.valueOf(CommaSeparatedValues.fromString(rights));
            for (int i = 0; i < values.length; ++i) {
                this.add(values[i]);
            }
        }
    }

    public void remove(AccessRight right) {
        if (right != null) {
            this.m_set.remove(right.value());
        }
    }

    public boolean contains(AccessRight right) {
        if (right != null) {
            return this.m_set.contains(right.value());
        }
        return false;
    }

    public String toString() {
        return CommaSeparatedValues.toString(this.m_set.toArray(new String[0]));
    }

    static boolean validate(String rights) {
        AccessRight[] values = RightsBuilder.valueOf(CommaSeparatedValues.fromString(rights));
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            return false;
        }
        return true;
    }

    private static AccessRight[] valueOf(String[] rights) {
        AccessRight[] values = new AccessRight[rights.length];
        for (int i = 0; i < rights.length; ++i) {
            values[i] = AccessRight.valueOf(rights[i]);
        }
        return values;
    }

    public static class AccessRight {
        private String m_value;
        public static final AccessRight GENERAL = new AccessRight("CompanyGeneral");
        public static final AccessRight SITEADMINISTRATORS = new AccessRight("CompanyAdministrators");
        public static final AccessRight USERS = new AccessRight("CompanyUsers");
        public static final AccessRight PROFILES = new AccessRight("CompanyProfiles");
        public static final AccessRight COVERSHEETS = new AccessRight("CompanyCoverSheets");
        public static final AccessRight ROUTING = new AccessRight("CompanyRouting");
        public static final AccessRight BILLINGCODEGROUPS = new AccessRight("CompanyBillingCodeGroups");
        public static final AccessRight NUMBERRESTRICTIONGROUPS = new AccessRight("CompanyNumberRestrictionGroups");
        public static final AccessRight MAILDESTINATIONS = new AccessRight("CompanyMailDestinations");
        public static final AccessRight PRINTERDESTINATIONS = new AccessRight("CompanyPrinterDestinations");
        public static final AccessRight FOLDERDESTINATIONS = new AccessRight("CompanyDirectoryDestinations");
        public static final AccessRight EXTERNALAPPLICATIONDESTINATIONS = new AccessRight("CompanyCorbaDestinations");
        public static final AccessRight PYTHONDESTINATIONS = new AccessRight("CompanyPythonDestinations");
        public static final AccessRight NOTIFICATIONPROFILES = new AccessRight("CompanyNotificationProfiles");
        public static final AccessRight MONITORING = new AccessRight("CompanyMonitoring");
        public static final AccessRight PROFILELOOKUPRULES = new AccessRight("CompanyProfileLookupRules");
        public static final AccessRight PHONEBOOKS = new AccessRight("CompanyPhonebooks");

        String value() {
            return this.m_value;
        }

        static AccessRight valueOf(String right) {
            if (right.equals(GENERAL.value())) {
                return GENERAL;
            }
            if (right.equals(SITEADMINISTRATORS.value())) {
                return SITEADMINISTRATORS;
            }
            if (right.equals(USERS.value())) {
                return USERS;
            }
            if (right.equals(PROFILES.value())) {
                return PROFILES;
            }
            if (right.equals(COVERSHEETS.value())) {
                return COVERSHEETS;
            }
            if (right.equals(ROUTING.value())) {
                return ROUTING;
            }
            if (right.equals(BILLINGCODEGROUPS.value())) {
                return BILLINGCODEGROUPS;
            }
            if (right.equals(NUMBERRESTRICTIONGROUPS.value())) {
                return NUMBERRESTRICTIONGROUPS;
            }
            if (right.equals(MAILDESTINATIONS.value())) {
                return MAILDESTINATIONS;
            }
            if (right.equals(PRINTERDESTINATIONS.value())) {
                return PRINTERDESTINATIONS;
            }
            if (right.equals(FOLDERDESTINATIONS.value())) {
                return FOLDERDESTINATIONS;
            }
            if (right.equals(EXTERNALAPPLICATIONDESTINATIONS.value())) {
                return EXTERNALAPPLICATIONDESTINATIONS;
            }
            if (right.equals(PYTHONDESTINATIONS.value())) {
                return PYTHONDESTINATIONS;
            }
            if (right.equals(NOTIFICATIONPROFILES.value())) {
                return NOTIFICATIONPROFILES;
            }
            if (right.equals(MONITORING.value())) {
                return MONITORING;
            }
            if (right.equals(PROFILELOOKUPRULES.value())) {
                return PROFILELOOKUPRULES;
            }
            if (right.equals(PHONEBOOKS.value())) {
                return PHONEBOOKS;
            }
            return null;
        }

        private AccessRight(String value) {
            this.m_value = value;
        }
    }
}

