/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public class RecordMover {
    private ListNode m_listNode = null;
    private PropertyDef m_mainProp = null;
    private String m_listNodeName = null;

    public synchronized boolean reorder(long[] recordIds) throws NullPointerException, IllegalStateException, XmediusException {
        if (recordIds == null) {
            throw new NullPointerException();
        }
        if (!this.assertState()) {
            throw new IllegalStateException();
        }
        long[] recordIdsFrom = this.getCurrentOrder();
        int[] moveUps = this.getMoveUps(recordIdsFrom, recordIds);
        this.moveUp(recordIds, moveUps);
        return true;
    }

    public synchronized void destroy() {
        this.m_listNode = null;
        this.m_mainProp = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RecordMover for ListNode ");
        buf.append(this.m_listNodeName);
        if (!this.assertState()) {
            buf.append(" (destroyed)");
        }
        return buf.toString();
    }

    static RecordMover getRecordMover(ListNode node, PropertyDef property) throws NullPointerException {
        if (node == null || property == null) {
            throw new NullPointerException();
        }
        return new RecordMover(node, property);
    }

    private RecordMover(ListNode node, PropertyDef property) {
        this.m_listNode = node;
        this.m_mainProp = property;
        this.m_listNodeName = node.name();
    }

    private boolean assertState() {
        return this.m_listNode != null && this.m_mainProp != null;
    }

    private int[] getMoveUps(long[] recordIdsFrom, long[] recordIdsTo) throws XmediusException {
        int toLen = recordIdsTo.length;
        int fromLen = recordIdsFrom.length;
        if (toLen == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_RECORD_ID, "The destination array is empty");
        }
        if (fromLen == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_RECORD_ID, "The source array is empty");
        }
        int[] pos = new int[toLen];
        int[] moveUps = new int[toLen];
        int i = 0;
        int j = 0;
        boolean bFound = false;
        for (i = 0; i < toLen; ++i) {
            bFound = false;
            for (j = 0; j < fromLen; ++j) {
                if (recordIdsTo[i] != recordIdsFrom[j]) continue;
                pos[i] = j;
                bFound = true;
                break;
            }
            if (bFound) continue;
            throw new XmediusException(XmediusExceptionCause.INVALID_RECORD_ID, "", recordIdsTo[i]);
        }
        for (i = 0; i < toLen; ++i) {
            moveUps[i] = pos[i] - i;
            int jmin = i + 1;
            if (jmin < toLen) {
                for (j = jmin; j < toLen; ++j) {
                    if (pos[j] >= pos[i]) continue;
                    int n = j;
                    pos[n] = pos[n] + 1;
                }
            }
            pos[i] = 0;
        }
        return moveUps;
    }

    private long[] getCurrentOrder() throws XmediusException {
        PropertyDef[] properties = new PropertyDef[]{this.m_mainProp};
        View view = this.m_listNode.getView(properties);
        return view.recordIds();
    }

    private void moveUp(long[] recordIds, int[] moveUps) throws XmediusException {
        for (int i = 0; i < recordIds.length; ++i) {
            int moves = moveUps[i];
            long id = recordIds[i];
            for (int j = 0; j < moves; ++j) {
                this.m_listNode.moveUp(id);
            }
        }
    }
}

