/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.TypedColumn;
import Xm.TypedValue;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyType;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public final class PropertyValue {
    private PropertyDef m_def = null;
    private int m_intValue = 0;
    private String m_stringValue = "";
    private boolean m_booleanValue = false;

    public PropertyValue(PropertyDef def) throws NullPointerException {
        if (def == null) {
            throw new NullPointerException();
        }
        this.m_def = def;
    }

    public PropertyValue(PropertyDef def, String value) throws IllegalStateException, NullPointerException {
        this(def);
        this.stringValue(value);
    }

    public PropertyValue(PropertyDef def, int value) throws IllegalStateException, NullPointerException {
        this(def);
        this.intValue(value);
    }

    public PropertyValue(PropertyDef def, boolean value) throws IllegalStateException, NullPointerException {
        this(def);
        this.booleanValue(value);
    }

    public PropertyType type() {
        return this.m_def.type();
    }

    public String name() {
        return this.m_def.name();
    }

    public void stringValue(String value) throws IllegalStateException, NullPointerException {
        this.assertString();
        if (value == null) {
            throw new NullPointerException();
        }
        this.m_stringValue = value;
    }

    public String stringValue() throws IllegalStateException {
        this.assertString();
        return this.m_stringValue;
    }

    public void intValue(int value) throws IllegalStateException {
        this.assertInt();
        this.m_intValue = value;
    }

    public int intValue() throws IllegalStateException {
        this.assertInt();
        return this.m_intValue;
    }

    public void booleanValue(boolean value) throws IllegalStateException {
        this.assertBoolean();
        this.m_booleanValue = value;
    }

    public boolean booleanValue() throws IllegalStateException {
        this.assertBoolean();
        return this.m_booleanValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_def.toString());
        buf.append(" = ");
        switch (this.m_def.type().value()) {
            case 0: {
                buf.append(Integer.toString(this.m_intValue));
                break;
            }
            case 1: {
                buf.append(this.m_stringValue);
                break;
            }
            case 2: {
                if (this.m_booleanValue) {
                    buf.append("true");
                    break;
                }
                buf.append("false");
                break;
            }
        }
        return buf.toString();
    }

    public final boolean equals(Object anObject) {
        if (anObject != null && anObject instanceof PropertyValue) {
            PropertyValue other = (PropertyValue)anObject;
            if (this.m_def.equals(other.m_def)) {
                switch (this.m_def.type().value()) {
                    case 0: {
                        if (this.m_intValue != other.m_intValue) break;
                        return true;
                    }
                    case 1: {
                        if (!this.m_stringValue.equals(other.m_stringValue)) break;
                        return true;
                    }
                    case 2: {
                        if (this.m_booleanValue != other.m_booleanValue) break;
                        return true;
                    }
                }
            }
        }
        return super.equals(anObject);
    }

    public int hashCode() {
        int code = 17;
        switch (this.m_def.type().value()) {
            case 0: {
                code += 53 * (this.m_intValue + 11);
                break;
            }
            case 1: {
                code += 53 * (this.m_stringValue.hashCode() + 11);
                break;
            }
            case 2: {
                if (this.m_booleanValue) {
                    code += 2739;
                    break;
                }
                code += 1013;
                break;
            }
        }
        return this.m_def.hashCode() * 17 + code;
    }

    PropertyValue(PropertyValue copy) {
        if (copy != null) {
            this.m_def = copy.m_def;
            this.m_intValue = copy.m_intValue;
            this.m_stringValue = copy.m_stringValue;
            this.m_booleanValue = copy.m_booleanValue;
        }
    }

    PropertyDef def() {
        return this.m_def;
    }

    static PropertyValue fromTypedValueAndDef(TypedValue typedValue, PropertyDef property) throws NullPointerException, XmediusException {
        if (typedValue == null || property == null) {
            throw new NullPointerException();
        }
        PropertyValue value = new PropertyValue(property);
        try {
            switch (typedValue.discriminator().value()) {
                case 1: {
                    value.intValue(typedValue.long_value());
                    break;
                }
                case 2: {
                    value.stringValue(typedValue.wstring_value());
                    break;
                }
                case 3: {
                    value.booleanValue(typedValue.boolean_value());
                    break;
                }
                default: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + property.name());
                }
            }
        }
        catch (IllegalStateException ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + ex.getMessage());
        }
        return value;
    }

    static PropertyValue fromTypedColumnIndexAndDef(TypedColumn typedColumn, int index, PropertyDef property) throws NullPointerException, IndexOutOfBoundsException, XmediusException {
        if (typedColumn == null || property == null) {
            throw new NullPointerException();
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        PropertyValue value = new PropertyValue(property);
        try {
            switch (typedColumn.discriminator().value()) {
                case 1: {
                    value.intValue(typedColumn.long_column()[index]);
                    break;
                }
                case 2: {
                    value.stringValue(typedColumn.wstring_column()[index]);
                    break;
                }
                case 3: {
                    value.booleanValue(typedColumn.boolean_column()[index]);
                    break;
                }
                default: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + property.name());
                }
            }
        }
        catch (IllegalStateException ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + ex.getMessage());
        }
        return value;
    }

    static PropertyValue[] fromTypedValuesAndDefs(TypedValue[] typedValues, PropertyDef[] properties) throws NullPointerException, XmediusException {
        if (typedValues == null || properties == null) {
            throw new NullPointerException();
        }
        int valueLen = typedValues.length;
        int propertyLen = properties.length;
        if (valueLen != propertyLen) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property counts mismatch");
        }
        PropertyValue[] values = new PropertyValue[valueLen];
        for (int i = 0; i < valueLen; ++i) {
            values[i] = PropertyValue.fromTypedValueAndDef(typedValues[i], properties[i]);
        }
        return values;
    }

    static String[] toPropertyNameArray(PropertyValue[] values) throws NullPointerException {
        if (values == null) {
            throw new NullPointerException();
        }
        int valueLen = values.length;
        String[] propertyNames = new String[valueLen];
        for (int i = 0; i < valueLen; ++i) {
            propertyNames[i] = values[i].name();
        }
        return propertyNames;
    }

    static TypedValue[] toTypeValueArray(PropertyValue[] values) throws NullPointerException, XmediusException {
        if (values == null) {
            throw new NullPointerException();
        }
        int valueLen = values.length;
        TypedValue[] typedValues = new TypedValue[valueLen];
        block5: for (int i = 0; i < valueLen; ++i) {
            typedValues[i] = new TypedValue();
            switch (values[i].type().value()) {
                case 0: {
                    typedValues[i].long_value(values[i].intValue());
                    continue block5;
                }
                case 1: {
                    typedValues[i].wstring_value(values[i].stringValue());
                    continue block5;
                }
                case 2: {
                    typedValues[i].boolean_value(values[i].booleanValue());
                    continue block5;
                }
                default: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + values[i].name());
                }
            }
        }
        return typedValues;
    }

    private void assertString() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.STRING) {
            throw new IllegalStateException(this.m_def.name());
        }
    }

    private void assertInt() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.INT) {
            throw new IllegalStateException(this.m_def.name());
        }
    }

    private void assertBoolean() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.BOOLEAN) {
            throw new IllegalStateException(this.m_def.name());
        }
    }
}

