/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.TypedValue;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyType;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public final class PropertyMultiValue {
    private PropertyDef m_def = null;
    private int[] m_intValues = new int[0];
    private String[] m_stringValues = new String[0];
    private boolean[] m_booleanValues = new boolean[0];

    public PropertyMultiValue(PropertyDef def) throws NullPointerException {
        if (def == null) {
            throw new NullPointerException();
        }
        this.m_def = def;
    }

    public PropertyType type() {
        return this.m_def.type();
    }

    public String name() {
        return this.m_def.name();
    }

    public void stringValues(String[] values) throws IllegalStateException, NullPointerException {
        this.assertString();
        if (values == null) {
            throw new NullPointerException();
        }
        this.m_stringValues = this.duplicate(values);
    }

    public String[] stringValues() throws IllegalStateException {
        this.assertString();
        return this.m_stringValues;
    }

    public void intValues(int[] values) throws IllegalStateException, NullPointerException {
        this.assertInt();
        if (values == null) {
            throw new NullPointerException();
        }
        this.m_intValues = this.duplicate(values);
    }

    public int[] intValues() throws IllegalStateException {
        this.assertInt();
        return this.m_intValues;
    }

    public void booleanValues(boolean[] values) throws IllegalStateException, NullPointerException {
        this.assertBoolean();
        if (values == null) {
            throw new NullPointerException();
        }
        this.m_booleanValues = this.duplicate(values);
    }

    public boolean[] booleanValues() throws IllegalStateException {
        this.assertBoolean();
        return this.m_booleanValues;
    }

    PropertyMultiValue(PropertyMultiValue copy) {
        if (copy != null) {
            this.m_def = copy.m_def;
            this.m_intValues = this.duplicate(copy.m_intValues);
            this.m_stringValues = this.duplicate(copy.m_stringValues);
            this.m_booleanValues = this.duplicate(copy.m_booleanValues);
        }
    }

    PropertyDef def() {
        return this.m_def;
    }

    int valueCount() {
        switch (this.m_def.type().value()) {
            case 0: {
                return this.m_intValues.length;
            }
            case 1: {
                return this.m_stringValues.length;
            }
            case 2: {
                return this.m_booleanValues.length;
            }
        }
        return 0;
    }

    static String[] toPropertyNameArray(PropertyMultiValue[] values) throws NullPointerException {
        if (values == null) {
            throw new NullPointerException();
        }
        int valueLen = values.length;
        String[] propertyNames = new String[valueLen];
        for (int i = 0; i < valueLen; ++i) {
            propertyNames[i] = values[i].name();
        }
        return propertyNames;
    }

    static TypedValue[] toTypeValueArray(PropertyMultiValue[] values, int valueIndex) throws NullPointerException, XmediusException {
        if (values == null) {
            throw new NullPointerException();
        }
        int valueLen = values.length;
        for (int i = 0; i < valueLen; ++i) {
            if (values[i].valueCount() > valueIndex) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        TypedValue[] typedValues = new TypedValue[valueLen];
        block6: for (int i = 0; i < valueLen; ++i) {
            typedValues[i] = new TypedValue();
            switch (values[i].type().value()) {
                case 0: {
                    typedValues[i].long_value(values[i].intValues()[valueIndex]);
                    continue block6;
                }
                case 1: {
                    typedValues[i].wstring_value(values[i].stringValues()[valueIndex]);
                    continue block6;
                }
                case 2: {
                    typedValues[i].boolean_value(values[i].booleanValues()[valueIndex]);
                    continue block6;
                }
                default: {
                    throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, "Value and property type mismatch: " + values[i].name());
                }
            }
        }
        return typedValues;
    }

    private void assertString() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.STRING) {
            throw new IllegalStateException(this.m_def.name());
        }
    }

    private void assertInt() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.INT) {
            throw new IllegalStateException(this.m_def.name());
        }
    }

    private void assertBoolean() throws IllegalStateException {
        if (this.m_def.type() != PropertyType.BOOLEAN) {
            throw new IllegalStateException(this.m_def.name());
        }
    }

    private String[] duplicate(String[] values) {
        String[] copy = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            copy[i] = values[i];
        }
        return copy;
    }

    private int[] duplicate(int[] values) {
        int[] copy = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            copy[i] = values[i];
        }
        return copy;
    }

    private boolean[] duplicate(boolean[] values) {
        boolean[] copy = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            copy[i] = values[i];
        }
        return copy;
    }
}

