/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.MediaStore.DestroyFileFailure;
import Xm.MediaStore.FileAccess;
import Xm.MediaStore.FileAccessHelper;
import Xm.MediaStore.FileId;
import Xm.MediaStore.InvalidFileId;
import Xm.MediaStore.ReadFileFailure;
import Xm.MediaStore.WriteFileFailure;
import com.interstarinc.xmedius.MediaStoreFileId;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;

public class MediaStore {
    private FileAccess m_mediaStore;
    public static final String SYSTEM_SUBSTORE = "System";

    public MediaStore(Session session) throws XmediusException {
        this.m_mediaStore = MediaStore.resolveMediaStore(session);
    }

    public MediaStoreFileId createFile(String subStore, String fileType) throws XmediusException {
        try {
            FileId id = this.m_mediaStore.CreateFile(subStore, fileType);
            return new MediaStoreFileId(id.SubStoreId, id.EntryId);
        }
        catch (WriteFileFailure ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveMediaStore");
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.toString());
        }
    }

    public void writeFile(MediaStoreFileId fileId, int offset, byte[] data) throws XmediusException {
        FileId id = new FileId(fileId.subStore(), fileId.url());
        try {
            this.m_mediaStore.WriteFile(id, offset, data);
        }
        catch (InvalidFileId ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (WriteFileFailure ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveMediaStore");
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.toString());
        }
    }

    public byte[] readFile(MediaStoreFileId fileId, int length, int offset) throws XmediusException {
        FileId id = new FileId(fileId.subStore(), fileId.url());
        try {
            return this.m_mediaStore.ReadFile(id, length, offset, new StringHolder());
        }
        catch (InvalidFileId ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (ReadFileFailure ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveMediaStore");
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.toString());
        }
    }

    public void destroyFile(MediaStoreFileId fileId) throws XmediusException {
        FileId id = new FileId(fileId.subStore(), fileId.url());
        try {
            this.m_mediaStore.DestroyFile(id);
        }
        catch (InvalidFileId ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (DestroyFileFailure ex) {
            throw new XmediusException(XmediusExceptionCause.FATAL_ERROR, ex.toString());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveMediaStore");
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.toString());
        }
    }

    static FileAccess resolveMediaStore(Session session) throws XmediusException {
        if (session == null) {
            throw new NullPointerException();
        }
        try {
            Object obj = session.getObjectFromTrader("ConfigManagerMediaStoreFileAccessGroup", "");
            FileAccess file_access = FileAccessHelper.narrow((Object)obj);
            if (file_access == null) {
                throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, "MediaStore");
            }
            return file_access;
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "resolveMediaStore");
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }
}

