/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.BadParamsX;
import Xm.BatchFailureHolder;
import Xm.InvalidPropertiesX;
import Xm.List;
import Xm.NotSupportedX;
import Xm.Records;
import Xm.StorageException;
import Xm.TypedValue;
import com.interstarinc.xmedius.ConfigNode;
import com.interstarinc.xmedius.ErrorCollector;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyMultiValue;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.RecordMover;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteListNodeId;
import com.interstarinc.xmedius.SystemListNodeId;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.ViewRecords;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;

public class ListNode {
    private List m_list = null;
    private ListNodeId m_nodeId = null;

    public static ListNode getNode(Session session, ListNodeId nodeId) throws NullPointerException, XmediusException {
        ConfigNode config = new ConfigNode(ConfigNode.getConfig(session, nodeId), nodeId);
        return new ListNode(config.getList(nodeId), nodeId);
    }

    public ListNode getNode(long recordId, ListNodeId nodeId) throws NullPointerException, XmediusException {
        if (nodeId == null) {
            throw new NullPointerException();
        }
        if (!nodeId.isSub()) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "The ListNodeId specified is not linked to a record");
        }
        this.assertState();
        try {
            List subList = this.m_list.GetListInterface(recordId, nodeId.listName());
            if (subList == null) {
                throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, nodeId.toString());
            }
            return new ListNode(subList, nodeId);
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getNode on " + Session.ToPublicNodeName(nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public View getView(PropertyDef[] properties) throws NullPointerException, XmediusException {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.assertState();
        String[] propertyNames = PropertyDef.toPropertyNameArray(properties);
        if (propertyNames.length == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
        }
        try {
            Records records = this.m_list.GetAllRecords(propertyNames);
            return ViewRecords.fromRecordsAndDefs(records, properties);
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getView on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public PropertyValue[] getValues(long recordId, PropertyDef[] properties) throws NullPointerException, XmediusException {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.assertState();
        String[] propertyNames = PropertyDef.toPropertyNameArray(properties);
        if (propertyNames.length == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
        }
        try {
            TypedValue[] typedValues = this.m_list.GetTypedValues(recordId, propertyNames);
            return PropertyValue.fromTypedValuesAndDefs(typedValues, properties);
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage(), recordId);
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getValues on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public void setValues(long[] recordIds, PropertyValue[] values) throws NullPointerException, XmediusException {
        String[] propertyNames;
        if (recordIds == null || values == null) {
            throw new NullPointerException();
        }
        this.assertState();
        if (this.m_nodeId.validator() != null) {
            this.m_nodeId.validator().onSetValues(values);
        }
        if ((propertyNames = PropertyValue.toPropertyNameArray(values)).length == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
        }
        try {
            TypedValue[] typedValues = PropertyValue.toTypeValueArray(values);
            this.m_list.SetTypedValues(recordIds, propertyNames, typedValues);
            return;
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (BadParamsX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "setValues on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public void setValues(long recordId, PropertyValue[] values) throws NullPointerException, XmediusException {
        long[] ids = new long[]{recordId};
        this.setValues(ids, values);
    }

    public long addRecord(PropertyValue[] values) throws NullPointerException, XmediusException {
        if (values == null) {
            throw new NullPointerException();
        }
        this.assertState();
        if (this.m_nodeId.validator() != null) {
            this.m_nodeId.validator().onAddRecord(values);
        }
        try {
            String[] propertyNames = PropertyValue.toPropertyNameArray(values);
            if (propertyNames.length == 0) {
                throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
            }
            TypedValue[] typedValues = PropertyValue.toTypeValueArray(values);
            return this.m_list.AddTypedValues(propertyNames, typedValues);
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (BadParamsX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "addRecord on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public long[] addRecords(PropertyMultiValue[] values, ErrorCollector errors) throws NullPointerException, ArrayIndexOutOfBoundsException, XmediusException {
        if (values == null || errors == null) {
            throw new NullPointerException();
        }
        errors.reset();
        this.assertState();
        if (this.m_nodeId.validator() != null) {
            this.m_nodeId.validator().onAddRecords(values);
        }
        try {
            String[] propertyNames = PropertyMultiValue.toPropertyNameArray(values);
            if (propertyNames.length == 0) {
                throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
            }
            int valueCount = values[0].valueCount();
            TypedValue[][] typedValues = new TypedValue[valueCount][];
            for (int i = 0; i < valueCount; ++i) {
                typedValues[i] = PropertyMultiValue.toTypeValueArray(values, i);
            }
            BatchFailureHolder failure = new BatchFailureHolder();
            long[] ids = this.m_list.AddBatchTypedValues(propertyNames, (TypedValue[][])typedValues, failure);
            errors.set(failure.value.InvalidIndexes, failure.value.Descriptions);
            return ids;
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (BadParamsX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, ex.getMessage());
        }
        catch (NotSupportedX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "addRecord on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public void deleteRecords(long[] recordIds) throws NullPointerException, XmediusException {
        if (recordIds == null) {
            throw new NullPointerException();
        }
        this.assertState();
        if (this.m_nodeId.validator() != null) {
            this.m_nodeId.validator().onDeleteRecord();
        }
        try {
            this.m_list.DeleteRecords(recordIds);
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "deleteRecords on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public void deleteRecord(long recordId) throws XmediusException {
        long[] ids = new long[]{recordId};
        this.deleteRecords(ids);
    }

    public RecordMover getRecordMover() {
        PropertyDef property = this.getMovingPropertyDef();
        if (property == null) {
            return null;
        }
        return RecordMover.getRecordMover(this, property);
    }

    public String toString() {
        return this.m_nodeId.toString();
    }

    public String name() {
        return this.m_nodeId.listName();
    }

    private ListNode(List list, ListNodeId nodeId) {
        this.m_list = list;
        this.m_nodeId = nodeId;
    }

    private void assertState() throws XmediusException {
        if (this.m_list == null) {
            throw new XmediusException(XmediusExceptionCause.INVALID_STATE);
        }
    }

    private void deleteSilently(long recordId) {
        try {
            long[] ids = new long[]{recordId};
            this.m_list.DeleteRecords(ids);
        }
        catch (StorageException ex) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    void moveUp(long recordId) throws XmediusException {
        this.assertState();
        if (this.getMovingPropertyDef() == null) {
            throw new XmediusException(XmediusExceptionCause.INVALID_OPERATION, "Node is not movable");
        }
        try {
            this.m_list.MoveUp(recordId);
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage(), recordId);
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "moveUp on " + Session.ToPublicNodeName(this.m_nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    private PropertyDef getMovingPropertyDef() {
        PropertyDef result = null;
        if (this.m_nodeId.isList(SiteListNodeId.Name.ROUTING.toString())) {
            result = PropertyDef.ROUTING_TYPE;
        } else if (this.m_nodeId.isList(SystemListNodeId.Name.MODIFICATIONTABLE_ACTIONS.toString())) {
            result = PropertyDef.MODIFICATIONTABLE_ACTIONS_OFFSET;
        } else if (this.m_nodeId.isList(SystemListNodeId.Name.LOADBALANCINGPROFILES_RULES.toString())) {
            result = PropertyDef.LOADBALANCINGPROFILES_RULES_NAME;
        } else if (this.m_nodeId.isList(SiteListNodeId.Name.PROFILELOOKUPRULES.toString())) {
            result = PropertyDef.PROFILELOOKUPRULES_TYPE;
        } else if (this.m_nodeId.isList(SystemListNodeId.Name.SITELOOKUPRULES.toString())) {
            result = PropertyDef.SITELOOKUPRULES_TYPE;
        } else if (this.m_nodeId.isList(SystemListNodeId.Name.USERDIRECTORIES.toString())) {
            result = PropertyDef.USERDIRECTORIES_TYPE;
        }
        return result;
    }
}

