/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public class HostListNodeId
extends ListNodeId {
    private Name m_name = null;
    private String m_hostName = null;
    private String m_hostGuid = null;

    public static HostListNodeId create(Name name, String hostName) throws NullPointerException {
        if (name == null || hostName == null) {
            throw new NullPointerException();
        }
        return new HostListNodeId(name, hostName, null);
    }

    public static HostListNodeId createWithGuid(Name name, String hostGuid) throws NullPointerException {
        if (name == null || hostGuid == null) {
            throw new NullPointerException();
        }
        return new HostListNodeId(name, "", hostGuid);
    }

    public String nodeName() {
        return this.m_name.nodeName();
    }

    public String toString() {
        return this.m_name.toString();
    }

    String constraint(Session session) throws NullPointerException, XmediusException {
        String hostGuid;
        String string = hostGuid = this.m_hostGuid != null ? this.m_hostGuid : session.fromHostNameToHostGuid(this.m_hostName);
        if (hostGuid == null) {
            throw new XmediusException(XmediusExceptionCause.UNKNOWN_HOST, this.m_hostName);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Type");
        buf.append(" == '");
        buf.append(this.m_name.nodeName());
        buf.append("' and ");
        buf.append("Host");
        buf.append(" == '");
        buf.append(hostGuid);
        buf.append("'");
        return buf.toString();
    }

    String listName() {
        return this.m_name.listName();
    }

    boolean isSub() {
        return this.m_name.isSub();
    }

    boolean isList(String name) {
        return name != null && name.equals(this.m_name.toString());
    }

    PropertyValueValidator validator() {
        return null;
    }

    private HostListNodeId(Name name, String hostName, String hostGuid) {
        this.m_name = name;
        this.m_hostName = hostName;
        this.m_hostGuid = hostGuid;
    }

    public static class Name {
        private String m_node = null;
        private String m_list = null;
        private boolean m_isSub = false;
        public static final Name DRIVER_MODIFICATIONTABLE = new Name("Driver Modification Table");
        public static final Name DRIVER_MODIFICATIONTABLE_ACTIONS = new Name("Driver Modification Table", "Action List", true);
        public static final Name DRIVER_T38_DIALPLAN = new Name("Driver", "Dial Plan", false);
        public static final Name DRIVER_T38_DIALPLAN_PEERS = new Name("Driver", "Peers", true);
        public static final Name DRIVER_T38_PEERS = new Name("Driver", "Peer List", false);
        public static final Name DRIVER_T38_PEERS_SUPPORTEDCODECS = new Name("Driver", "Supported Codecs List", true);
        public static final Name DRIVER_T38_DEFAULTSIPPEERPROPERTIES_SUPPORTEDCODECS = new Name("Driver", "DefaultSipPeerProperties,Supported Codecs List", false);
        public static final Name DRIVER_T38_REALMS = new Name("Driver", "T38,Realm List", false);
        public static final Name DRIVER_CHANNELS = new Name("Channels");

        public String nodeName() {
            return this.m_node;
        }

        public String listName() {
            return this.m_list;
        }

        public boolean isSub() {
            return this.m_isSub;
        }

        public String toString() {
            if (this.m_isSub) {
                return this.m_node + ":" + this.m_list;
            }
            return this.m_node + ":list";
        }

        private Name(String node) {
            this(node, null, false);
        }

        private Name(String node, String list, boolean isSub) {
            this.m_node = node;
            this.m_list = list;
            this.m_isSub = isSub;
        }
    }
}

