/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.ConfigNodeId;
import com.interstarinc.xmedius.DriverPropertyValueValidator;
import com.interstarinc.xmedius.PropertyValueValidator;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;

public class HostConfigNodeId
extends ConfigNodeId {
    private Name m_name = null;
    private String m_hostGuid = null;

    public static HostConfigNodeId createWithGuid(Name name, String hostGuid) throws NullPointerException {
        if (name == null || hostGuid == null) {
            throw new NullPointerException();
        }
        return new HostConfigNodeId(name, hostGuid);
    }

    public String nodeName() {
        return this.m_name.nodeName();
    }

    public String toString() {
        return this.m_name.toString();
    }

    String constraint(Session session) throws NullPointerException, XmediusException {
        StringBuffer buf = new StringBuffer();
        buf.append("Type");
        buf.append(" == '");
        buf.append(this.m_name.nodeName());
        buf.append("' and ");
        buf.append("Host");
        buf.append(" == '");
        buf.append(this.m_hostGuid);
        buf.append("'");
        return buf.toString();
    }

    PropertyValueValidator validator() {
        return this.m_name.validator();
    }

    private HostConfigNodeId(Name name, String hostGuid) {
        this.m_name = name;
        this.m_hostGuid = hostGuid;
    }

    public static class Name {
        private String m_node = null;
        private PropertyValueValidator m_validator = null;
        public static final Name SMTPGATEWAY = new Name("SMTP Gateway");
        public static final Name DRIVER = new Name("Driver", new DriverPropertyValueValidator());

        public String nodeName() {
            return this.m_node;
        }

        public String toString() {
            return this.m_node;
        }

        PropertyValueValidator validator() {
            return this.m_validator;
        }

        private Name(String node) {
            this(node, null);
        }

        private Name(String node, PropertyValueValidator validator) {
            this.m_node = node;
            this.m_validator = validator;
        }
    }
}

