/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DriverMap {
    private HashMap m_map = null;

    public static DriverMap getMap(Session session) throws NullPointerException, XmediusException {
        if (session == null) {
            throw new NullPointerException();
        }
        return new DriverMap(session.getDriverNameToGuidMap());
    }

    public String getGuidFromName(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.m_map != null) {
            return (String)this.m_map.get(name);
        }
        return null;
    }

    public String getNameFromGuid(String guid) throws NullPointerException {
        Set ids;
        if (guid == null) {
            throw new NullPointerException();
        }
        String name = null;
        if (this.m_map != null && !(ids = this.m_map.keySet()).isEmpty()) {
            for (String tentativeName : ids) {
                String value = (String)this.m_map.get(tentativeName);
                if (value == null || !value.equalsIgnoreCase(guid)) continue;
                name = tentativeName;
                break;
            }
        }
        return name;
    }

    public String toString() {
        Set ids;
        if (this.m_map != null && !(ids = this.m_map.keySet()).isEmpty()) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = ids.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                String name = (String)iter.next();
                String guid = (String)this.m_map.get(name);
                buf.append("[");
                buf.append(name);
                buf.append(" : ");
                buf.append(guid);
                buf.append("]");
            }
            return buf.toString();
        }
        return "EMPTY MAP";
    }

    private DriverMap(HashMap map) {
        this.m_map = map;
    }
}

