/*
 * Decompiled with CFR 0.152.
 */
package com.interstarinc.xmedius;

import Xm.BadParamsX;
import Xm.Config;
import Xm.ConfigHelper;
import Xm.InvalidPropertiesX;
import Xm.List;
import Xm.StorageException;
import Xm.TypedValue;
import com.interstarinc.xmedius.ConfigNodeId;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.NodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ConfigNode {
    private Config m_config = null;
    private NodeId m_nodeId = null;

    public static ConfigNode getNode(Session session, ConfigNodeId nodeId) throws NullPointerException, XmediusException {
        return new ConfigNode(ConfigNode.getConfig(session, nodeId), nodeId);
    }

    public PropertyValue[] getValues(PropertyDef[] properties) throws NullPointerException, XmediusException {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.assertState();
        String[] propertyNames = PropertyDef.toPropertyNameArray(properties);
        if (propertyNames.length == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
        }
        try {
            TypedValue[] typedValues = this.m_config.GetTypedValues(propertyNames);
            PropertyValue[] values = PropertyValue.fromTypedValuesAndDefs(typedValues, properties);
            return values;
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getValues on " + Session.ToPublicNodeName(this.name()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public void setValues(PropertyValue[] values) throws NullPointerException, XmediusException {
        String[] propertyNames;
        if (values == null) {
            throw new NullPointerException();
        }
        this.assertState();
        if (this.m_nodeId.validator() != null) {
            this.m_nodeId.validator().onSetValues(values);
        }
        if ((propertyNames = PropertyValue.toPropertyNameArray(values)).length == 0) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, "No property specified");
        }
        TypedValue[] typedValues = PropertyValue.toTypeValueArray(values);
        try {
            this.m_config.SetTypedValues(propertyNames, typedValues);
            return;
        }
        catch (InvalidPropertiesX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_PROPERTY, ex.getMessage());
        }
        catch (BadParamsX ex) {
            throw new XmediusException(XmediusExceptionCause.INVALID_VALUE, ex.getMessage());
        }
        catch (StorageException ex) {
            XmediusExceptionCause cause = XmediusExceptionCause.fromStorageExceptionCause(ex.Cause);
            throw new XmediusException(cause, ex.getMessage());
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "setValues on " + Session.ToPublicNodeName(this.name()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    public String name() {
        return this.m_nodeId.nodeName();
    }

    public String toString() {
        return this.name();
    }

    ConfigNode(Config config, NodeId nodeId) {
        this.m_config = config;
        this.m_nodeId = nodeId;
    }

    static Config getConfig(Session session, NodeId nodeId) throws NullPointerException, XmediusException {
        if (session == null || nodeId == null) {
            throw new NullPointerException();
        }
        String constraint = nodeId.constraint(session);
        try {
            Object obj = session.getObjectFromTrader("Config", constraint);
            Config config = ConfigHelper.narrow((Object)obj);
            if (config == null) {
                throw new XmediusException(XmediusExceptionCause.UNREACHABLE_NODE, nodeId.toString());
            }
            return config;
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getNode on " + Session.ToPublicNodeName(nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    List getList(ListNodeId nodeId) throws NullPointerException, XmediusException {
        if (nodeId == null) {
            throw new NullPointerException();
        }
        this.assertState();
        try {
            String listName = nodeId.listName();
            if (listName != null) {
                return this.m_config.GetListInterface(listName);
            }
            return this.m_config.GetPrimaryList();
        }
        catch (NO_PERMISSION ex) {
            throw new XmediusException(XmediusExceptionCause.NO_PERMISSION, "getNode on " + Session.ToPublicNodeName(nodeId.nodeName()));
        }
        catch (SystemException ex) {
            throw new XmediusException(XmediusExceptionCause.COMMUNICATION_ERROR, ex.getMessage());
        }
    }

    void assertState() throws XmediusException {
        if (this.m_config == null) {
            throw new XmediusException(XmediusExceptionCause.INVALID_STATE);
        }
    }
}

