/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.ConfigNode;
import com.interstarinc.xmedius.ConfigNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteConfigNodeId;
import com.interstarinc.xmedius.XmediusException;

public class XmSite
extends XmBase {
    private static final String G3 = "G3";
    private static final String G4 = "G4";

    public void execute(String string) {
        String[] stringArray = null;
        this.doWork(stringArray);
    }

    public static void main(String[] stringArray) {
        XmSite xmSite = new XmSite();
        xmSite.doWork(stringArray);
    }

    private void doWork(String[] stringArray) {
        System.out.println("\nXmSite - Change site tiff encoding");
        System.out.println("------------------------------------------------------------\n");
        this.processArgs(stringArray);
        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] stringArray) {
        XmBase.ParsedCommandLine parsedCommandLine = null;
        try {
            parsedCommandLine = XmBase.getParsedCommandLine(stringArray);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.toString());
            return;
        }
        boolean bl = true;
        if (parsedCommandLine.remainingArgs.length == 0) {
            this.outputUsage();
            return;
        }
        if (parsedCommandLine.remainingArgs[0].equalsIgnoreCase(G3)) {
            bl = true;
        } else if (parsedCommandLine.remainingArgs[0].equalsIgnoreCase(G4)) {
            bl = false;
        } else {
            this.outputUsage();
            return;
        }
        if (!this.validateLoginInfo(parsedCommandLine, true)) {
            return;
        }
        Session session = this.openSession(parsedCommandLine);
        if (session == null) {
            return;
        }
        try {
            parsedCommandLine.targetSite = this.getSiteGuidFromSiteName(session, parsedCommandLine.targetSite);
            SiteConfigNodeId siteConfigNodeId = SiteConfigNodeId.create((SiteConfigNodeId.Name)SiteConfigNodeId.Name.GENERAL, (String)parsedCommandLine.targetSite);
            ConfigNode configNode = ConfigNode.getNode((Session)session, (ConfigNodeId)siteConfigNodeId);
            PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.GENERAL_SMTPGTWYPOSTMASTER};
            PropertyValue[] propertyValueArray = configNode.getValues(propertyDefArray);
            String string = propertyValueArray[0].stringValue();
            this.outputInformation("Current Value: " + string);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    private String outputValue(String string) {
        if (string.equalsIgnoreCase(G3)) {
            return G3;
        }
        if (string.equalsIgnoreCase(G4)) {
            return G4;
        }
        return string;
    }

    private void outputUsage() {
        this.outputInformation("Usages:");
        this.outputInformation("");
        this.outputInformation("Change tiff encoding to G3: XmSite {LoginInfo} G3");
        this.outputInformation("Change tiff encoding to G4: XmSite {LoginInfo} G4");
        this.outputInformation("");
        String[] stringArray = XmSite.GetLoginUsageSite();
        String string = "Where {LoginInfo} is: ";
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputInformation(string + stringArray[i]);
            string = "                  or: ";
        }
    }
}

