/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.ConfigNode;
import com.interstarinc.xmedius.ConfigNodeId;
import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.PropertyValue;
import com.interstarinc.xmedius.RightsBuilder;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteConfigNodeId;
import com.interstarinc.xmedius.SiteListNodeId;
import com.interstarinc.xmedius.SystemListNodeId;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;
import com.interstarinc.xmedius.XmediusExceptionCause;

public class XmNewSite
extends XmBase {
    public void execute(String string) {
        String[] stringArray = null;
        this.doWork(stringArray);
    }

    public static void main(String[] stringArray) {
        XmNewSite xmNewSite = new XmNewSite();
        xmNewSite.doWork(stringArray);
    }

    private void doWork(String[] stringArray) {
        System.out.println("\nXmNewSite - Create a new site");
        System.out.println("------------------------------------------------------------\n");
        this.processArgs(stringArray);
        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] stringArray) {
        XmBase.ParsedCommandLine parsedCommandLine = null;
        try {
            parsedCommandLine = XmBase.getParsedCommandLine(stringArray);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.toString());
            return;
        }
        if (parsedCommandLine.remainingArgs.length == 0) {
            this.outputUsage();
            return;
        }
        if (parsedCommandLine.remainingArgs[0].equalsIgnoreCase("-h")) {
            this.outputUsage();
            return;
        }
        String string = parsedCommandLine.remainingArgs[0];
        String string2 = parsedCommandLine.remainingArgs[1];
        String string3 = parsedCommandLine.remainingArgs[2];
        if (!this.validateLoginInfo(parsedCommandLine, false)) {
            this.outputUsage();
            return;
        }
        Session session = this.openSession(parsedCommandLine);
        if (session == null) {
            return;
        }
        try {
            String string4 = this.CreateSite(session, string, string2, string3);
            this.outputInformation("Created new site: " + string);
            this.outputInformation("            GUID: " + string4);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    private String CreateSite(Session session, String string, String string2, String string3) throws XmediusException {
        SystemListNodeId systemListNodeId = SystemListNodeId.create((SystemListNodeId.Name)SystemListNodeId.Name.SITES);
        ListNode listNode = ListNode.getNode((Session)session, (ListNodeId)systemListNodeId);
        PropertyValue[] propertyValueArray = new PropertyValue[20];
        propertyValueArray[0] = new PropertyValue(PropertyDef.SITES_NAME);
        propertyValueArray[0].stringValue(string);
        propertyValueArray[1] = new PropertyValue(PropertyDef.SITES_WEBALIAS);
        propertyValueArray[1].stringValue(string + ".sp.com");
        propertyValueArray[2] = new PropertyValue(PropertyDef.SITES_REFERENCE);
        propertyValueArray[2].stringValue("");
        propertyValueArray[3] = new PropertyValue(PropertyDef.SITES_CONTACT);
        propertyValueArray[3].stringValue(string3);
        propertyValueArray[4] = new PropertyValue(PropertyDef.SITES_ENABLED);
        propertyValueArray[4].booleanValue(true);
        propertyValueArray[5] = new PropertyValue(PropertyDef.SITES_QOSMAXOUTBOUND);
        propertyValueArray[5].intValue(0);
        propertyValueArray[6] = new PropertyValue(PropertyDef.SITES_QOSMAXINBOUND);
        propertyValueArray[6].intValue(0);
        propertyValueArray[7] = new PropertyValue(PropertyDef.SITES_QOSMAXINBOUNDANDOUTBOUND);
        propertyValueArray[7].intValue(240);
        propertyValueArray[8] = new PropertyValue(PropertyDef.SITES_QOSWEIGHT);
        propertyValueArray[8].intValue(100);
        propertyValueArray[9] = new PropertyValue(PropertyDef.SITES_INCOMINGAUTODELETEENTRY);
        propertyValueArray[9].booleanValue(false);
        propertyValueArray[10] = new PropertyValue(PropertyDef.SITES_INCOMINGENTRYOLDERTHAN);
        propertyValueArray[10].intValue(0);
        propertyValueArray[11] = new PropertyValue(PropertyDef.SITES_INCOMINGAUTODELETEFAX);
        propertyValueArray[11].booleanValue(false);
        propertyValueArray[12] = new PropertyValue(PropertyDef.SITES_INCOMINGFAXOLDERTHAN);
        propertyValueArray[12].intValue(0);
        propertyValueArray[13] = new PropertyValue(PropertyDef.SITES_INCOMINGBACKUPFAX);
        propertyValueArray[13].booleanValue(false);
        propertyValueArray[14] = new PropertyValue(PropertyDef.SITES_OUTGOINGAUTODELETEENTRY);
        propertyValueArray[14].booleanValue(false);
        propertyValueArray[15] = new PropertyValue(PropertyDef.SITES_OUTGOINGENTRYOLDERTHAN);
        propertyValueArray[15].intValue(0);
        propertyValueArray[16] = new PropertyValue(PropertyDef.SITES_OUTGOINGAUTODELETEFAX);
        propertyValueArray[16].booleanValue(true);
        propertyValueArray[17] = new PropertyValue(PropertyDef.SITES_OUTGOINGFAXOLDERTHAN);
        propertyValueArray[17].intValue(60);
        propertyValueArray[18] = new PropertyValue(PropertyDef.SITES_OUTGOINGBACKUPFAX);
        propertyValueArray[18].booleanValue(false);
        propertyValueArray[19] = new PropertyValue(PropertyDef.SITES_REFERENCE);
        propertyValueArray[19].stringValue(string2);
        long l = listNode.addRecord(propertyValueArray);
        PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.SITES_GUID};
        View view = listNode.getView(propertyDefArray);
        String string4 = view.values(l)[0].stringValue();
        SiteConfigNodeId siteConfigNodeId = SiteConfigNodeId.create((SiteConfigNodeId.Name)SiteConfigNodeId.Name.GENERAL, (String)string4);
        ConfigNode configNode = ConfigNode.getNode((Session)session, (ConfigNodeId)siteConfigNodeId);
        PropertyValue[] propertyValueArray2 = new PropertyValue[]{new PropertyValue(PropertyDef.GENERAL_SMTPGTWYPOSTMASTER)};
        propertyValueArray2[0].stringValue("FaxIPLAN@iplan.com.ar");
        configNode.setValues(propertyValueArray2);
        return string4;
    }

    private void CreateSiteAdmin(Session session, String string) throws XmediusException {
        SiteListNodeId siteListNodeId = SiteListNodeId.create((SiteListNodeId.Name)SiteListNodeId.Name.SITEADMINISTRATORS, (String)string);
        ListNode listNode = null;
        boolean bl = false;
        while (!bl) {
            try {
                listNode = ListNode.getNode((Session)session, (ListNodeId)siteListNodeId);
                bl = true;
            }
            catch (XmediusException xmediusException) {
                if (xmediusException.cause() != XmediusExceptionCause.UNREACHABLE_NODE) {
                    throw xmediusException;
                }
                try {
                    this.outputWarning("Administrators node is unreachable, waiting one second for it to be created");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    throw xmediusException;
                }
            }
        }
        PropertyValue[] propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_NAME);
        propertyValueArray[0].stringValue("Administrator");
        propertyValueArray[1] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_PASSWORD);
        propertyValueArray[1].stringValue("");
        long l = listNode.addRecord(propertyValueArray);
        RightsBuilder rightsBuilder = new RightsBuilder();
        rightsBuilder.add(RightsBuilder.AccessRight.GENERAL);
        rightsBuilder.add(RightsBuilder.AccessRight.SITEADMINISTRATORS);
        rightsBuilder.add(RightsBuilder.AccessRight.USERS);
        rightsBuilder.add(RightsBuilder.AccessRight.PROFILES);
        rightsBuilder.add(RightsBuilder.AccessRight.COVERSHEETS);
        rightsBuilder.add(RightsBuilder.AccessRight.ROUTING);
        rightsBuilder.add(RightsBuilder.AccessRight.BILLINGCODEGROUPS);
        rightsBuilder.add(RightsBuilder.AccessRight.NUMBERRESTRICTIONGROUPS);
        rightsBuilder.add(RightsBuilder.AccessRight.MAILDESTINATIONS);
        rightsBuilder.add(RightsBuilder.AccessRight.PRINTERDESTINATIONS);
        rightsBuilder.add(RightsBuilder.AccessRight.FOLDERDESTINATIONS);
        rightsBuilder.add(RightsBuilder.AccessRight.EXTERNALAPPLICATIONDESTINATIONS);
        rightsBuilder.add(RightsBuilder.AccessRight.NOTIFICATIONPROFILES);
        rightsBuilder.add(RightsBuilder.AccessRight.MONITORING);
        rightsBuilder.add(RightsBuilder.AccessRight.PROFILELOOKUPRULES);
        propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_RIGHTS);
        propertyValueArray[0].stringValue(rightsBuilder.toString());
        propertyValueArray[1] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_MUSTCHANGEPASSWORD);
        propertyValueArray[1].booleanValue(true);
        listNode.setValues(l, propertyValueArray);
    }

    private void outputUsage() {
        this.outputInformation("Usages:");
        this.outputInformation("");
        this.outputInformation("Create a new site: XmNewSite {LoginInfo} \"new_site_name\"");
        this.outputInformation("");
        String[] stringArray = XmNewSite.GetLoginUsageSystem();
        String string = "Where {LoginInfo} is: ";
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputInformation(string + stringArray[i]);
            string = "                  or: ";
        }
    }
}

