/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SystemListNodeId;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;

public class XmExistsSite
extends XmBase {
    public void execute(String string) {
        String[] stringArray = null;
        this.doWork(stringArray);
    }

    public static void main(String[] stringArray) {
        XmExistsSite xmExistsSite = new XmExistsSite();
        xmExistsSite.doWork(stringArray);
    }

    private void doWork(String[] stringArray) {
        System.out.println("\nXmExistsSite - Show if a site exists or throw error");
        System.out.println("------------------------------------------------------------\n");
        this.processArgs(stringArray);
        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] stringArray) {
        XmBase.ParsedCommandLine parsedCommandLine = null;
        try {
            parsedCommandLine = XmBase.getParsedCommandLine(stringArray);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.toString());
            return;
        }
        if (parsedCommandLine.remainingArgs.length == 0) {
            this.outputUsage();
            return;
        }
        if (parsedCommandLine.remainingArgs[0].equalsIgnoreCase("-h")) {
            this.outputUsage();
            return;
        }
        String string = parsedCommandLine.remainingArgs[0];
        if (!this.validateLoginInfo(parsedCommandLine, false)) {
            this.outputUsage();
            return;
        }
        Session session = this.openSession(parsedCommandLine);
        if (session == null) {
            return;
        }
        try {
            String string2 = this.ExistsSite(session, string);
            this.outputInformation("Exists site: " + string);
            this.outputInformation("       GUID: " + string2);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    private String ExistsSite(Session session, String string) throws XmediusException {
        String string2 = this.getSiteGuidFromSiteName(session, string);
        SystemListNodeId systemListNodeId = SystemListNodeId.create((SystemListNodeId.Name)SystemListNodeId.Name.SITES);
        ListNode listNode = ListNode.getNode((Session)session, (ListNodeId)systemListNodeId);
        PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.SITES_GUID};
        View view = listNode.getView(propertyDefArray);
        long[] lArray = view.recordIds();
        return string2;
    }

    private void outputUsage() {
        this.outputInformation("Usages:");
        this.outputInformation("");
        this.outputInformation("Check if a site exists: XmExistsSite {LoginInfo} \"site_name\"");
        this.outputInformation("");
        String[] stringArray = XmExistsSite.GetLoginUsageSystem();
        String string = "Where {LoginInfo} is: ";
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputInformation(string + stringArray[i]);
            string = "                  or: ";
        }
    }
}

