/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.ListNode;
import com.interstarinc.xmedius.ListNodeId;
import com.interstarinc.xmedius.PropertyDef;
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SystemListNodeId;
import com.interstarinc.xmedius.View;
import com.interstarinc.xmedius.XmediusException;

public class XmDeleteSite
extends XmBase {
    public void execute(String string) {
        String[] stringArray = null;
        this.doWork(stringArray);
    }

    public static void main(String[] stringArray) {
        XmDeleteSite xmDeleteSite = new XmDeleteSite();
        xmDeleteSite.doWork(stringArray);
    }

    private void doWork(String[] stringArray) {
        System.out.println("\nXmDeleteSite - delete a site");
        System.out.println("------------------------------------------------------------\n");
        this.processArgs(stringArray);
        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] stringArray) {
        XmBase.ParsedCommandLine parsedCommandLine = null;
        try {
            parsedCommandLine = XmBase.getParsedCommandLine(stringArray);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.toString());
            return;
        }
        if (parsedCommandLine.remainingArgs.length == 0) {
            this.outputUsage();
            return;
        }
        if (parsedCommandLine.remainingArgs[0].equalsIgnoreCase("-h")) {
            this.outputUsage();
            return;
        }
        String string = parsedCommandLine.remainingArgs[0];
        if (!this.validateLoginInfo(parsedCommandLine, false)) {
            this.outputUsage();
            return;
        }
        Session session = this.openSession(parsedCommandLine);
        if (session == null) {
            return;
        }
        try {
            String string2 = this.DeleteSite(session, string);
            this.outputInformation("Deleted site: " + string);
            this.outputInformation("        GUID: " + string2);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
        }
    }

    private String DeleteSite(Session session, String string) throws XmediusException {
        String string2 = this.getSiteGuidFromSiteName(session, string);
        SystemListNodeId systemListNodeId = SystemListNodeId.create((SystemListNodeId.Name)SystemListNodeId.Name.SITES);
        ListNode listNode = ListNode.getNode((Session)session, (ListNodeId)systemListNodeId);
        PropertyDef[] propertyDefArray = new PropertyDef[]{PropertyDef.SITES_GUID};
        View view = listNode.getView(propertyDefArray);
        long[] lArray = view.recordIds();
        for (int i = 0; i < lArray.length; ++i) {
            if (!view.values(lArray[i])[0].stringValue().equals(string2)) continue;
            listNode.deleteRecord(lArray[i]);
        }
        return string2;
    }

    private void outputUsage() {
        this.outputInformation("Usages:");
        this.outputInformation("");
        this.outputInformation("Delete a site: XmDeleteSite {LoginInfo} \"site_name\"");
        this.outputInformation("");
        String[] stringArray = XmDeleteSite.GetLoginUsageSystem();
        String string = "Where {LoginInfo} is: ";
        for (int i = 0; i < stringArray.length; ++i) {
            this.outputInformation(string + stringArray[i]);
            string = "                  or: ";
        }
    }
}

