/*
 * Decompiled with CFR 0.152.
 */
import com.interstarinc.xmedius.Session;
import com.interstarinc.xmedius.SiteResolver;
import com.interstarinc.xmedius.XmediusException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.StringTokenizer;
import java.util.Vector;

public class XmBase {
    public static final String LOGIN_NAME = "-LoginName";
    public static final String LOGIN_PWD = "-LoginPwd";
    public static final String LOGIN_SERVERS = "-LoginServers";
    public static final String LOGIN_SITE = "-LoginSite";
    public static final String TARGET_SITE = "-Site";

    public void execute(String string) {
    }

    protected void outputError(String string) {
        this.outputMessage("ERROR  : ", string);
    }

    protected void outputWarning(String string) {
        this.outputMessage("WARNING: ", string);
    }

    protected void outputInformation(String string) {
        this.outputMessage("INFO   : ", string);
    }

    protected BufferedReader getBufferedFileReader(String string) {
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder charsetDecoder = charset.newDecoder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charsetDecoder);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.outputError("Failed to open " + string);
        }
        return bufferedReader;
    }

    protected BufferedWriter getBufferedFileWriter(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder charsetEncoder = charset.newEncoder();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charsetEncoder);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.outputError("Failed to open " + string);
        }
        return bufferedWriter;
    }

    protected static ParsedCommandLine getParsedCommandLine(String[] stringArray) throws XmediusException {
        ArgVector argVector = new ArgVector();
        argVector.add("");
        argVector.add(stringArray);
        return XmBase.createParsedCommandLine(argVector.toStringArray());
    }

    protected boolean validateLoginInfo(ParsedCommandLine parsedCommandLine, boolean bl) {
        StringBuffer stringBuffer;
        if (parsedCommandLine == null) {
            return false;
        }
        boolean bl2 = true;
        boolean bl3 = bl;
        if (parsedCommandLine.loginName == null) {
            bl2 = false;
            stringBuffer = new StringBuffer();
            stringBuffer.append("Missing login name. Use ");
            stringBuffer.append(LOGIN_NAME);
            stringBuffer.append(" \"your administrator name\" at the command line.");
            this.outputError(stringBuffer.toString());
        }
        if (parsedCommandLine.loginPassword == null) {
            bl2 = false;
            stringBuffer = new StringBuffer();
            stringBuffer.append("Missing login password. Use ");
            stringBuffer.append(LOGIN_PWD);
            stringBuffer.append(" \"your password\" at the command line.");
            this.outputError(stringBuffer.toString());
        }
        if (bl3 && parsedCommandLine.targetSite == null) {
            bl2 = false;
            stringBuffer = new StringBuffer();
            stringBuffer.append("Missing target site. Use ");
            stringBuffer.append(TARGET_SITE);
            stringBuffer.append(" \"site name\" at the command line if login as a system administrator.");
            this.outputError(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer.append("Missing target site. Use ");
            stringBuffer.append(LOGIN_SITE);
            stringBuffer.append(" \"site name\" at the command line if login as a site administrator.");
            this.outputError(stringBuffer.toString());
        }
        if (parsedCommandLine.loginServers == null || parsedCommandLine.loginServers.length == 0) {
            bl2 = false;
            stringBuffer = new StringBuffer();
            stringBuffer.append("Missing login servers. Use ");
            stringBuffer.append(LOGIN_SERVERS);
            stringBuffer.append(" \"server1[,server2]\"");
            this.outputError(stringBuffer.toString());
        }
        return bl2;
    }

    protected Session openSession(ParsedCommandLine parsedCommandLine) {
        if (parsedCommandLine == null || parsedCommandLine.loginName == null || parsedCommandLine.loginPassword == null || parsedCommandLine.loginServers == null || parsedCommandLine.loginServers.length == 0) {
            return null;
        }
        try {
            boolean bl;
            boolean bl2 = bl = parsedCommandLine.loginSite != null;
            if (bl) {
                parsedCommandLine.targetSite = parsedCommandLine.loginSite = this.getSiteGuidFromSiteName(parsedCommandLine.loginServers, parsedCommandLine.loginSite);
                return Session.open((String)parsedCommandLine.loginSite, (String)parsedCommandLine.loginName, (String)parsedCommandLine.loginPassword, (String[])parsedCommandLine.loginServers);
            }
            return Session.open((String)parsedCommandLine.loginName, (String)parsedCommandLine.loginPassword, (String[])parsedCommandLine.loginServers);
        }
        catch (XmediusException xmediusException) {
            this.outputError(xmediusException.getMessage());
            return null;
        }
    }

    protected static String[] GetLoginUsageSystem() {
        String[] stringArray = new String[1];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LOGIN_NAME);
        stringBuffer.append(" \"system_admin_name\" ");
        stringBuffer.append(LOGIN_PWD);
        stringBuffer.append(" \"pwd\" ");
        stringBuffer.append(LOGIN_SERVERS);
        stringBuffer.append(" \"server1[,server2]\"");
        stringArray[0] = stringBuffer.toString();
        return stringArray;
    }

    protected static String[] GetLoginUsageSite() {
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LOGIN_NAME);
        stringBuffer.append(" \"system_admin_name\" ");
        stringBuffer.append(LOGIN_PWD);
        stringBuffer.append(" \"pwd\" ");
        stringBuffer.append(TARGET_SITE);
        stringBuffer.append(" \"target_site_name\" ");
        stringBuffer.append(LOGIN_SERVERS);
        stringBuffer.append(" \"server1[,server2]\"");
        stringArray[0] = stringBuffer.toString();
        stringBuffer = new StringBuffer();
        stringBuffer.append(LOGIN_NAME);
        stringBuffer.append(" \"site_admin_name\" ");
        stringBuffer.append(LOGIN_PWD);
        stringBuffer.append(" \"pwd\" ");
        stringBuffer.append(LOGIN_SITE);
        stringBuffer.append(" \"site_guid\" ");
        stringBuffer.append(LOGIN_SERVERS);
        stringBuffer.append(" \"server1[,server2]\"");
        stringArray[1] = stringBuffer.toString();
        return stringArray;
    }

    public String getSiteGuidFromSiteName(Session session, String string) throws XmediusException {
        if (XmBase.isAGuid(string)) {
            return string;
        }
        SiteResolver siteResolver = SiteResolver.create((Session)session);
        return siteResolver.getIdentifier(string);
    }

    public String getSiteGuidFromSiteName(String[] stringArray, String string) throws XmediusException {
        if (XmBase.isAGuid(string)) {
            return string;
        }
        SiteResolver siteResolver = SiteResolver.create((String[])stringArray);
        return siteResolver.getIdentifier(string);
    }

    private void outputMessage(String string, String string2) {
        System.out.println(string + string2);
    }

    private static boolean isAGuid(String string) {
        boolean bl = true;
        bl = 38 == string.length();
        block5: for (int i = 0; bl && i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (i) {
                case 0: {
                    bl = '{' == c;
                    continue block5;
                }
                case 9: 
                case 14: 
                case 19: 
                case 24: {
                    bl = '-' == c;
                    continue block5;
                }
                case 37: {
                    bl = '}' == c;
                    continue block5;
                }
                default: {
                    bl = '0' <= c && '9' >= c || 'A' <= c && 'F' >= c || 'a' <= c && 'f' >= c;
                }
            }
        }
        return bl;
    }

    private static ParsedCommandLine createParsedCommandLine(String[] stringArray) throws XmediusException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        ParsedCommandLine parsedCommandLine = new ParsedCommandLine();
        ArgWalker argWalker = new ArgWalker(stringArray);
        String string = argWalker.next();
        while (string != null) {
            if (string.equalsIgnoreCase(LOGIN_NAME)) {
                parsedCommandLine.loginName = argWalker.next();
            } else if (string.equalsIgnoreCase(LOGIN_PWD)) {
                parsedCommandLine.loginPassword = argWalker.next();
            } else if (string.equalsIgnoreCase(LOGIN_SERVERS)) {
                vector.clear();
                string = argWalker.next();
                if (string != null) {
                    String string2;
                    StringBuffer stringBuffer = new StringBuffer("");
                    int n = string.length();
                    block5: for (int i = 0; i < n; ++i) {
                        char c = string.charAt(i);
                        switch (c) {
                            case ' ': {
                                continue block5;
                            }
                            case ',': {
                                string2 = stringBuffer.toString();
                                if (string2.equals("")) continue block5;
                                vector.add(string2);
                                stringBuffer = new StringBuffer("");
                                continue block5;
                            }
                            default: {
                                stringBuffer.append(c);
                            }
                        }
                    }
                    string2 = stringBuffer.toString();
                    if (!string2.equals("")) {
                        vector.add(string2);
                    }
                }
            } else if (string.equalsIgnoreCase(LOGIN_SITE)) {
                parsedCommandLine.loginSite = argWalker.next();
            } else if (string.equalsIgnoreCase(TARGET_SITE)) {
                parsedCommandLine.targetSite = argWalker.next();
            } else {
                vector2.add(string);
            }
            string = argWalker.next();
        }
        if (parsedCommandLine.targetSite == null) {
            parsedCommandLine.targetSite = parsedCommandLine.loginSite;
        }
        if (!vector.isEmpty()) {
            parsedCommandLine.loginServers = vector.toArray(new String[0]);
        }
        parsedCommandLine.remainingArgs = !vector2.isEmpty() ? vector2.toArray(new String[0]) : new String[0];
        return parsedCommandLine;
    }

    private static void outputCommandLine(ParsedCommandLine parsedCommandLine) {
        int n;
        if (parsedCommandLine == null) {
            return;
        }
        String string = parsedCommandLine.loginName;
        System.out.println("loginName: " + (string != null ? string : "null"));
        string = parsedCommandLine.loginPassword;
        System.out.println("loginPassword: " + (string != null ? string : "null"));
        string = parsedCommandLine.loginSite;
        System.out.println("loginSite: " + (string != null ? string : "null"));
        string = parsedCommandLine.targetSite;
        System.out.println("targetSite: " + (string != null ? string : "null"));
        StringBuffer stringBuffer = new StringBuffer("servers: ");
        String[] stringArray = parsedCommandLine.loginServers;
        if (stringArray == null) {
            stringBuffer.append("null");
        } else {
            if (stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
            }
            for (n = 1; n < stringArray.length; ++n) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[n]);
            }
        }
        System.out.println(stringBuffer.toString());
        stringBuffer = new StringBuffer("remainingArgs: ");
        stringArray = parsedCommandLine.remainingArgs;
        if (stringArray == null) {
            stringBuffer.append("null");
        } else {
            if (stringArray.length > 0) {
                stringBuffer.append(stringArray[0]);
            }
            for (n = 1; n < stringArray.length; ++n) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[n]);
            }
        }
        System.out.println(stringBuffer.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Tokenizer {
        private Vector<String> m_tokens;
        private int m_next;

        public Tokenizer(String string) {
            Vector<String> vector = new Vector<String>();
            if (string.equals("")) {
                vector.add("");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(stringTokenizer.nextToken());
                }
            }
            this.m_tokens = this.getTokens(vector);
            this.m_next = 0;
        }

        public String getNextToken(String string) {
            if (this.m_tokens.size() > this.m_next) {
                String string2 = this.m_tokens.elementAt(this.m_next);
                ++this.m_next;
                return string2;
            }
            return string;
        }

        private Vector<String> getTokens(Vector<String> vector) {
            Vector<String> vector2 = new Vector<String>();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = vector.elementAt(i);
                if (string.equals(",")) {
                    if (0 == i) {
                        vector2.add("");
                    } else {
                        String string2 = vector.elementAt(i - 1);
                        if (string2.equals(",")) {
                            vector2.add("");
                        }
                    }
                    if (n - 1 != i) continue;
                    vector2.add("");
                    continue;
                }
                vector2.add(string);
            }
            return vector2;
        }
    }

    private static class ArgWalker {
        private String[] m_args = null;
        private int m_index = -1;

        public ArgWalker(String[] stringArray) {
            if (stringArray != null) {
                this.m_args = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_args[i] = stringArray[i];
                }
            } else {
                this.m_args = new String[0];
            }
        }

        public String next() {
            ++this.m_index;
            while (this.m_index < this.m_args.length) {
                String string = this.m_args[this.m_index];
                if (string != null) {
                    return string;
                }
                ++this.m_index;
            }
            return null;
        }
    }

    private static class ArgVector {
        private Vector<String> m_args = new Vector();

        public void add(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_args.add(stringArray[i]);
            }
        }

        public void add(String string) {
            if (string == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ' ': {
                        if (bl2) {
                            stringBuffer.append(c);
                            break;
                        }
                        if (!bl) break;
                        bl3 = true;
                        break;
                    }
                    case '\"': {
                        if (bl2) {
                            bl3 = true;
                            break;
                        }
                        if (bl) {
                            bl3 = true;
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl = true;
                        stringBuffer.append(c);
                    }
                }
                if (!bl3) continue;
                this.m_args.add(stringBuffer.toString());
                stringBuffer = new StringBuffer("");
                bl = false;
                bl2 = false;
                bl3 = false;
            }
            if (bl) {
                this.m_args.add(stringBuffer.toString());
            }
        }

        public String[] toStringArray() {
            return this.m_args.toArray(new String[0]);
        }
    }

    public static class ParsedCommandLine {
        public String loginName = null;
        public String loginPassword = null;
        public String loginSite = null;
        public String[] loginServers = null;
        public String targetSite = null;
        public String[] remainingArgs = null;
    }
}

